/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.poll.storage;

import io.meeds.kernel.test.KernelExtension;
import io.meeds.poll.BasePollTest;
import io.meeds.poll.dao.PollDAO;
import io.meeds.poll.dao.PollOptionDAO;
import io.meeds.poll.dao.PollVoteDAO;
import io.meeds.poll.entity.PollEntity;
import io.meeds.poll.entity.PollOptionEntity;
import io.meeds.poll.entity.PollVoteEntity;
import io.meeds.poll.model.Poll;
import io.meeds.poll.model.PollOption;
import io.meeds.poll.model.PollVote;
import io.meeds.poll.storage.PollStorage;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class, KernelExtension.class})
@SpringBootApplication(scanBasePackages={"io.meeds.poll", "io.meeds.spring.kernel.test", "io.meeds.spring.jpa", "io.meeds.spring.liquibase"})
@EnableJpaRepositories(basePackages={"io.meeds.poll"})
@TestPropertySource(properties={"spring.liquibase.change-log=classpath:db/changelog/poll-rdbms.db.changelog-master.xml"})
public class PollStorageTest
extends BasePollTest {
    private static final long STORED_POLL_CREATOR_ID = 653L;
    private static final long STORED_VOTER_ID = 225L;
    @Autowired
    private PollStorage pollStorage;
    @Autowired
    private PollDAO pollDAO;
    @Autowired
    private PollOptionDAO pollOptionDAO;
    @Autowired
    private PollVoteDAO pollVoteDAO;

    @AfterEach
    public void teardown() {
        this.pollVoteDAO.deleteAll();
        this.pollOptionDAO.deleteAll();
        this.pollDAO.deleteAll();
    }

    @Test
    public void createPoll() throws Exception {
        Poll poll = this.createPollInstance();
        PollOption pollOption = this.createPollOptionInstance(poll);
        Poll createdPoll = this.pollStorage.createPoll(poll, Collections.singletonList(pollOption));
        Assertions.assertNotNull((Object)createdPoll);
        Assertions.assertEquals((Object)poll.getQuestion(), (Object)createdPoll.getQuestion());
        Assertions.assertEquals((Object)poll.getCreatedDate(), (Object)createdPoll.getCreatedDate());
        Assertions.assertEquals((Object)poll.getEndDate(), (Object)createdPoll.getEndDate());
        Assertions.assertEquals((long)poll.getCreatorId(), (long)createdPoll.getCreatorId());
    }

    @Test
    public void getPollById() throws Exception {
        PollEntity pollEntity = this.createPollEntity();
        Poll poll = this.pollStorage.getPollById(pollEntity.getId().longValue());
        Assertions.assertNotNull((Object)poll);
        Assertions.assertEquals((long)pollEntity.getId(), (long)poll.getId());
        Assertions.assertEquals((Object)pollEntity.getQuestion(), (Object)poll.getQuestion());
        Assertions.assertEquals((Object)pollEntity.getCreatedDate(), (Object)poll.getCreatedDate());
        Assertions.assertEquals((Object)pollEntity.getEndDate(), (Object)poll.getEndDate());
        Assertions.assertEquals((long)pollEntity.getCreatorId(), (long)poll.getCreatorId());
    }

    @Test
    public void getPollOptionsByPollId() throws Exception {
        PollEntity pollEntity = this.createPollEntity();
        PollOptionEntity pollOptionEntity = this.createPollOptionEntity(pollEntity);
        List retrievedPollOptions = this.pollStorage.getPollOptionsByPollId(pollEntity.getId().longValue());
        Assertions.assertNotNull((Object)retrievedPollOptions);
        Assertions.assertEquals((long)pollOptionEntity.getId(), (long)((PollOption)retrievedPollOptions.get(0)).getId());
        Assertions.assertEquals((Object)pollOptionEntity.getDescription(), (Object)((PollOption)retrievedPollOptions.get(0)).getDescription());
    }

    @Test
    public void updatePoll() throws Exception {
        PollEntity pollEntity = this.createPollEntity();
        Poll poll = this.pollStorage.getPollById(pollEntity.getId().longValue());
        poll.setActivityId(55468L);
        Poll updatedPoll = this.pollStorage.updatePoll(poll);
        Assertions.assertNotNull((Object)updatedPoll);
        Assertions.assertEquals((long)poll.getActivityId(), (long)updatedPoll.getActivityId());
        updatedPoll = this.pollStorage.getPollById(pollEntity.getId().longValue());
        Assertions.assertEquals((long)poll.getActivityId(), (long)updatedPoll.getActivityId());
    }

    @Test
    public void createPollVote() throws Exception {
        PollEntity pollEntity = this.createPollEntity();
        PollOptionEntity pollOptionEntity = this.createPollOptionEntity(pollEntity);
        PollVote pollVote = this.createPollVoteInstance(pollOptionEntity.getId());
        PollVote createdPollVote = this.pollStorage.createPollVote(pollVote);
        Assertions.assertNotNull((Object)createdPollVote);
        Assertions.assertEquals((long)pollVote.getVoterId(), (long)createdPollVote.getVoterId());
        Assertions.assertEquals((long)pollVote.getPollOptionId(), (long)createdPollVote.getPollOptionId());
    }

    @Test
    public void countPollOptionTotalVotes() throws Exception {
        PollEntity pollEntity = this.createPollEntity();
        PollOptionEntity pollOptionEntity = this.createPollOptionEntity(pollEntity);
        Assertions.assertEquals((int)0, (int)this.pollStorage.countPollOptionTotalVotes(pollOptionEntity.getId().longValue()));
        this.pollStorage.createPollVote(new PollVote(pollOptionEntity.getId().longValue(), 1L, new Date()));
        Assertions.assertEquals((int)1, (int)this.pollStorage.countPollOptionTotalVotes(pollOptionEntity.getId().longValue()));
        Assertions.assertThrows(Exception.class, () -> this.pollStorage.createPollVote(new PollVote(pollOptionEntity.getId().longValue(), 1L, new Date())));
        Assertions.assertEquals((int)1, (int)this.pollStorage.countPollOptionTotalVotes(pollOptionEntity.getId().longValue()));
        this.pollStorage.createPollVote(new PollVote(pollOptionEntity.getId().longValue(), 2L, new Date()));
        Assertions.assertEquals((int)2, (int)this.pollStorage.countPollOptionTotalVotes(pollOptionEntity.getId().longValue()));
    }

    @Test
    public void countPollOptionTotalVotesByUser() throws Exception {
        PollEntity pollEntity = this.createPollEntity();
        PollOptionEntity pollOptionEntity = this.createPollOptionEntity(pollEntity);
        Assertions.assertEquals((int)0, (int)this.pollStorage.countPollOptionTotalVotesByUser(pollOptionEntity.getId().longValue(), 1L));
        Assertions.assertEquals((int)0, (int)this.pollStorage.countPollOptionTotalVotesByUser(pollOptionEntity.getId().longValue(), 2L));
        this.pollStorage.createPollVote(new PollVote(pollOptionEntity.getId().longValue(), 1L, new Date()));
        Assertions.assertEquals((int)1, (int)this.pollStorage.countPollOptionTotalVotesByUser(pollOptionEntity.getId().longValue(), 1L));
        Assertions.assertEquals((int)0, (int)this.pollStorage.countPollOptionTotalVotesByUser(pollOptionEntity.getId().longValue(), 2L));
        Assertions.assertThrows(Exception.class, () -> this.pollStorage.createPollVote(new PollVote(pollOptionEntity.getId().longValue(), 1L, new Date())));
        Assertions.assertEquals((int)1, (int)this.pollStorage.countPollOptionTotalVotesByUser(pollOptionEntity.getId().longValue(), 1L));
        Assertions.assertEquals((int)0, (int)this.pollStorage.countPollOptionTotalVotesByUser(pollOptionEntity.getId().longValue(), 2L));
        this.pollStorage.createPollVote(new PollVote(pollOptionEntity.getId().longValue(), 2L, new Date()));
        Assertions.assertEquals((int)1, (int)this.pollStorage.countPollOptionTotalVotesByUser(pollOptionEntity.getId().longValue(), 1L));
        Assertions.assertEquals((int)1, (int)this.pollStorage.countPollOptionTotalVotesByUser(pollOptionEntity.getId().longValue(), 2L));
    }

    @Test
    public void getPollOptionById() throws Exception {
        PollEntity pollEntity = this.createPollEntity();
        PollOptionEntity pollOptionEntity = this.createPollOptionEntity(pollEntity);
        PollOption retrievedPollOption = this.pollStorage.getPollOptionById(pollOptionEntity.getId().longValue());
        Assertions.assertNotNull((Object)retrievedPollOption);
        Assertions.assertEquals((long)pollOptionEntity.getId(), (long)retrievedPollOption.getId());
        Assertions.assertEquals((long)pollEntity.getId(), (long)retrievedPollOption.getPollId());
        Assertions.assertEquals((Object)pollOptionEntity.getDescription(), (Object)retrievedPollOption.getDescription());
    }

    @Test
    public void countPollOptionsByPollId() throws Exception {
        PollEntity pollEntity = this.createPollEntity();
        this.createPollOptionEntity(pollEntity);
        Assertions.assertEquals((int)1, (int)this.pollStorage.countPollOptionsByPollId(pollEntity.getId().longValue()));
        this.createPollOptionEntity(pollEntity);
        Assertions.assertEquals((int)2, (int)this.pollStorage.countPollOptionsByPollId(pollEntity.getId().longValue()));
    }

    @Test
    public void countPollTotalVotes() throws Exception {
        PollEntity pollEntity = this.createPollEntity();
        PollOptionEntity pollOptionEntity = this.createPollOptionEntity(pollEntity);
        Assertions.assertEquals((int)0, (int)this.pollStorage.countPollTotalVotes(pollEntity.getId().longValue()));
        this.pollStorage.createPollVote(new PollVote(pollOptionEntity.getId().longValue(), 1L, new Date()));
        Assertions.assertEquals((int)1, (int)this.pollStorage.countPollTotalVotes(pollEntity.getId().longValue()));
        Assertions.assertThrows(Exception.class, () -> this.pollStorage.createPollVote(new PollVote(pollOptionEntity.getId().longValue(), 1L, new Date())));
        Assertions.assertEquals((int)1, (int)this.pollStorage.countPollTotalVotes(pollEntity.getId().longValue()));
        this.pollStorage.createPollVote(new PollVote(pollOptionEntity.getId().longValue(), 2L, new Date()));
        Assertions.assertEquals((int)2, (int)this.pollStorage.countPollTotalVotes(pollEntity.getId().longValue()));
    }

    @Test
    public void didVote() throws Exception {
        PollEntity pollEntity = this.createPollEntity();
        PollOptionEntity pollOptionEntity = this.createPollOptionEntity(pollEntity);
        boolean didVote = this.pollStorage.didVote(225L, pollEntity.getId());
        Assertions.assertFalse((boolean)didVote);
        this.createPollVoteEntity(pollOptionEntity);
        didVote = this.pollStorage.didVote(225L, pollEntity.getId());
        Assertions.assertTrue((boolean)didVote);
    }

    protected Poll createPollInstance() {
        Date createdDate = new Date(System.currentTimeMillis());
        Date endDate = new Date(11508484583260L);
        Poll poll = new Poll();
        poll.setQuestion("q1");
        poll.setCreatedDate(createdDate);
        poll.setEndDate(endDate);
        poll.setCreatorId(1L);
        return poll;
    }

    protected PollOption createPollOptionInstance(Poll poll) {
        PollOption pollOption = new PollOption();
        pollOption.setPollId(poll.getId());
        pollOption.setDescription("pollOption description");
        return pollOption;
    }

    protected PollVote createPollVoteInstance(long optionId) {
        PollVote pollVote = new PollVote();
        pollVote.setVoteDate(new Date());
        pollVote.setPollOptionId(optionId);
        pollVote.setVoterId(8554L);
        return pollVote;
    }

    protected PollEntity createPollEntity() {
        Date createdDate = new Date(System.currentTimeMillis());
        Date endDate = new Date(11508484583260L);
        PollEntity pollEntity = new PollEntity();
        pollEntity.setQuestion("q" + System.currentTimeMillis());
        pollEntity.setCreatedDate(createdDate);
        pollEntity.setEndDate(endDate);
        pollEntity.setCreatorId(653L);
        return (PollEntity)this.pollDAO.save((Object)pollEntity);
    }

    protected PollOptionEntity createPollOptionEntity(PollEntity pollEntity) {
        PollOptionEntity pollOptionEntity = new PollOptionEntity();
        pollOptionEntity.setPoll(pollEntity);
        pollOptionEntity.setDescription("pollOption description");
        return (PollOptionEntity)this.pollOptionDAO.save((Object)pollOptionEntity);
    }

    protected PollVoteEntity createPollVoteEntity(PollOptionEntity pollOptionEntity) {
        Date createdDate = new Date(System.currentTimeMillis());
        PollVoteEntity pollVoteEntity = new PollVoteEntity();
        pollVoteEntity.setPollOption(pollOptionEntity);
        pollVoteEntity.setVoterId(Long.valueOf(225L));
        pollVoteEntity.setVoteDate(createdDate);
        return (PollVoteEntity)this.pollVoteDAO.save((Object)pollVoteEntity);
    }
}

