/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ps.integration.notification;

import java.util.HashSet;
import java.util.LinkedList;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.ps.entity.ProjectSubEntity;
import org.exoplatform.ps.entity.StaffEntity;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.service.rest.Util;

public class PSSendITBPlugin
extends BaseNotificationPlugin {
    private static final Log LOG = ExoLogger.getLogger(PSSendITBPlugin.class);
    public static final String ID = "PSSendITBPlugin";
    public static final ArgumentLiteral<ProjectSubEntity> PROJECT = new ArgumentLiteral(ProjectSubEntity.class, "PROJECT");
    public static final ArgumentLiteral<StaffEntity> STAFF = new ArgumentLiteral(StaffEntity.class, "STAFF");
    public static final ArgumentLiteral<String> POSTER = new ArgumentLiteral(String.class, "poster");
    public static final ArgumentLiteral<String> END_DATE = new ArgumentLiteral(String.class, "time");
    public static final ArgumentLiteral<String> CREATORSTAFF = new ArgumentLiteral(String.class, "creatorStaff");
    public static final ArgumentLiteral<String> GC_PHONE = new ArgumentLiteral(String.class, "gc_phone");
    public static final ArgumentLiteral<String> GC_CONTACT = new ArgumentLiteral(String.class, "gc_contact");
    public static final ArgumentLiteral<String> COMPANY_NAME = new ArgumentLiteral(String.class, "companyname");
    IdentityManager identityManager;

    public PSSendITBPlugin(InitParams initParams, IdentityManager identityManager) {
        super(initParams);
        this.identityManager = identityManager;
    }

    public String getId() {
        return ID;
    }

    public boolean isValid(NotificationContext ctx) {
        return true;
    }

    protected NotificationInfo makeNotification(NotificationContext ctx) {
        ProjectSubEntity projectSubEntity = (ProjectSubEntity)ctx.value(PROJECT);
        HashSet<String> receivers = new HashSet<String>();
        receivers.add(projectSubEntity.getSubContractor().getManager());
        StringBuilder projectId = new StringBuilder("SendITB");
        projectId.append("-").append(projectSubEntity.getId());
        String poster = (String)ctx.value(POSTER);
        String creatorStaff = (String)ctx.value(CREATORSTAFF);
        String gc_phone = (String)ctx.value(GC_PHONE);
        String gc_contact = (String)ctx.value(GC_CONTACT);
        String companyname = (String)ctx.value(COMPANY_NAME);
        String time = (String)ctx.value(END_DATE);
        String projectid = projectSubEntity.getProjectId();
        String portalContainerName = "portal";
        SpaceService spaceService = Util.getSpaceService((String)"portal");
        Space project_ = spaceService.getSpaceByPrettyName(projectid);
        Identity prIdentity = Util.getIdentityManager((String)"portal").getOrCreateIdentity("space", project_.getPrettyName(), true);
        Profile sProfile = prIdentity.getProfile();
        String link = CommonsUtils.getCurrentDomain() + "/portal/g/:spaces:";
        return NotificationInfo.instance().setFrom("SendITB").to(new LinkedList(receivers)).with("creator", poster != null ? poster : "").with("period", time != null ? project_.getDescription() : "").with("creatorStaff", creatorStaff != null ? creatorStaff : "").with("gc_contact", gc_contact != null ? gc_contact : "").with("gc_phone", gc_phone != null ? gc_phone : "").with("companyname", companyname != null ? companyname : "").with("subcontractor", projectSubEntity.getSubContractor().getManager() != null ? projectSubEntity.getSubContractor().getManager() : "").with("sub_company", projectSubEntity.getSubContractor().getCompany() != null ? projectSubEntity.getSubContractor().getCompany() : "").with("bids_due", sProfile.getProperty("bidsDueDate") != null ? sProfile.getProperty("bidsDueDate").toString() : "").with("categorie", projectSubEntity.getCategory().getCatCsiDesc() != null ? projectSubEntity.getCategory().getCatCsiDesc() : "").with("projectname", project_.getDisplayName() != null ? project_.getDisplayName() : "").with("project_descr", project_.getDescription() != null ? project_.getDescription() : "").with("phone", projectSubEntity.getSubContractor().getPhone() != null ? projectSubEntity.getSubContractor().getPhone() : "").with("contact", projectSubEntity.getSubContractor().getCountry() + "" + projectSubEntity.getSubContractor().getCountry() + "" + projectSubEntity.getSubContractor().getState()).with("mail", projectSubEntity.getSubContractor().getEmail() != null ? projectSubEntity.getSubContractor().getEmail() : "").with("ProjectUrl", project_.getUrl() != null ? project_.getUrl() : "").with("projectstatus", sProfile.getProperty("projectStatus") != null ? sProfile.getProperty("projectStatus").toString() : "").with("projectType", sProfile.getProperty("projectType") != null ? sProfile.getProperty("projectType").toString() : "").with("pre_bid_meeting", sProfile.getProperty("preBidMeetingDate") != null ? sProfile.getProperty("preBidMeetingDate").toString() : "").with("stories_above_grd", sProfile.getProperty("storiesAboveGrd") != null ? sProfile.getProperty("storiesAboveGrd").toString() : "").with("nbBuildings", sProfile.getProperty("nbBuildings") != null ? sProfile.getProperty("nbBuildings").toString() : "").with("start_date", sProfile.getProperty("startDate") != null ? sProfile.getProperty("startDate").toString() : "").with("totalSqFt", sProfile.getProperty("totalSqFt") != null ? sProfile.getProperty("totalSqFt").toString() : "").with("pre_bid", sProfile.getProperty("bidsDueDate") != null ? sProfile.getProperty("bidsDueDate").toString() : "").with("ownerType", sProfile.getProperty("ownerType") != null ? sProfile.getProperty("ownerType").toString() : "").with("url", link + project_.getUrl() + "/" + project_.getUrl() + "/projectSettings").key(this.getKey()).end();
    }
}

