/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ps.listeners;

import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;

public class UserTimeZoneListener
extends UserEventListener {
    private static final String GC_TIMEZONE = "gcTimeZone";
    private static final Log LOG = ExoLogger.getLogger(UserTimeZoneListener.class);
    private final CalendarService calendarService;
    private final SettingService settingService;

    public UserTimeZoneListener(SettingService settingService, CalendarService calendarService) {
        this.calendarService = calendarService;
        this.settingService = settingService;
    }

    public void postSave(User user, boolean isNew) throws Exception {
        if (isNew) {
            CalendarSetting calendarSettings = this.calendarService.getCalendarSetting(user.getUserName());
            if (this.settingService.get(Context.GLOBAL, Scope.GLOBAL, GC_TIMEZONE) != null) {
                calendarSettings.setTimeZone(this.settingService.get(Context.GLOBAL, Scope.GLOBAL, GC_TIMEZONE).getValue().toString());
                this.calendarService.saveCalendarSetting(user.getUserName(), calendarSettings);
            }
        }
    }
}

