/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ps.rest;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import org.exoplatform.ps.utils.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;

public class ChangeBidScopeStatusRunner
implements Runnable {
    private static final Log LOG = ExoLogger.getLogger((String)ChangeBidScopeStatusRunner.class.getName());
    private String projectId;
    private String uid;
    private String refuid;
    private String bidStatus;
    private ConversationState myConversationState;

    ChangeBidScopeStatusRunner(String uid, String projectId, String refuid, String bidStatus, ConversationState conversationState) {
        this.uid = uid;
        this.projectId = projectId;
        this.refuid = refuid;
        this.bidStatus = bidStatus;
    }

    @Override
    public void run() {
        block9: {
            if (this.bidStatus.equals("AWARDED")) {
                this.bidStatus = "BIDDING";
            }
            if (this.bidStatus.equals("UNDECIDED")) {
                this.bidStatus = "REVIEWING";
            }
            if (this.bidStatus.equals("BIDDING") || this.bidStatus.equals("REVIEWING") || this.bidStatus.equals("NOT_BIDDING")) {
                LOG.info((Object)"Updating BidScop tatus");
                try {
                    Calendar calendar = Calendar.getInstance();
                    Date date = null;
                    try {
                        date = Utils.getTime();
                        calendar.setTime(date);
                    }
                    catch (IOException e) {
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                    }
                    int month = calendar.get(2);
                    String checksum = this.uid + "_" + (month + 1) + "bbbuild2015";
                    checksum = Utils.getMd5(checksum);
                    String webPage = "http://www.theProjectSpace.com/wsnsa.dll/WService=wsbrk1/web_api/woupd_bidstat.p?appname=bb-build&uid=" + this.uid + "&ProjectID=" + this.projectId + "&refuid=" + this.refuid + "&CheckSum=" + checksum + "&bidStatus=" + this.bidStatus;
                    URL url = new URL(webPage);
                    HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
                    if (urlConnection.getResponseCode() == 200) {
                        LOG.info((Object)("Status updated: " + urlConnection.getResponseMessage()));
                        break block9;
                    }
                    LOG.info((Object)("Status not updated: " + urlConnection.getResponseMessage()));
                }
                catch (Exception e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            } else {
                LOG.info((Object)"Wrong Status");
            }
        }
    }
}

