/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ps.rest;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.ps.reporting.ReportingService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.service.rest.Util;

@Path(value="/bbdownloadservice")
public class DownloadRestService
implements ResourceContainer {
    @GET
    @Path(value="/download/{nodesPath:.*}")
    public Response download(@PathParam(value="nodesPath") String nodesPath) throws Exception {
        String mimeType = "application/zip";
        ArrayList<Node> listNodes = new ArrayList<Node>();
        String[] splittedNodesPath = nodesPath.split(";");
        RepositoryService repositoryService = (RepositoryService)PortalContainer.getInstance().getComponentInstanceOfType(RepositoryService.class);
        ReportingService reportingService = (ReportingService)PortalContainer.getInstance().getComponentInstanceOfType(ReportingService.class);
        ManageableRepository manageableRepository = repositoryService.getCurrentRepository();
        String projectDisplayName = new String();
        SpaceService spaceService = Util.getSpaceService((String)"portal");
        for (String nodePath : splittedNodesPath) {
            Session session = manageableRepository.getSystemSession(nodePath.split(":")[0]);
            Node node = (Node)session.getItem(nodePath.split(":")[1]);
            if (!node.isNodeType("nt:file")) continue;
            if (nodePath.split(":")[1].contains("/Groups/spaces/")) {
                if (nodePath.split(":")[1].split("/Groups/spaces/")[1].split("/Documents/").length <= 1) continue;
                projectDisplayName = spaceService.getSpaceByPrettyName(nodePath.split(":")[1].split("/Groups/spaces/")[1].split("/Documents/")[0]).getDisplayName();
                reportingService.docDownloadsReporting(node);
                listNodes.add(node);
                continue;
            }
            projectDisplayName = "Personal Documents";
            listNodes.add(node);
        }
        String fileName = projectDisplayName + ".zip";
        return Response.ok((Object)this.zip(listNodes), (String)mimeType).header("Content-Disposition", (Object)("attachment; filename=\"" + fileName + "\"")).build();
    }

    private InputStream zip(List<Node> listNodes) throws Exception {
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ZipOutputStream zout = new ZipOutputStream(byteArrayOutputStream);
        for (Node node : listNodes) {
            int length;
            InputStream fin = node.getNode("jcr:content").getProperty("jcr:data").getStream();
            zout.putNextEntry(new ZipEntry(node.getName()));
            while ((length = fin.read(buffer)) > 0) {
                zout.write(buffer, 0, length);
            }
            zout.closeEntry();
            fin.close();
        }
        zout.close();
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }
}

