/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ps.rest;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.ps.DAO.GeneralContractorDAO;
import org.exoplatform.ps.DAO.ProjectSubDAO;
import org.exoplatform.ps.DAO.StaffDAO;
import org.exoplatform.ps.DAO.SubCatDAO;
import org.exoplatform.ps.DAO.SubContractorDAO;
import org.exoplatform.ps.DAO.SubGcDAO;
import org.exoplatform.ps.DAO.SubStaffCompanyDAO;
import org.exoplatform.ps.DTO.SubContractor;
import org.exoplatform.ps.entity.CategoryEntity;
import org.exoplatform.ps.entity.GeneralContractorEntity;
import org.exoplatform.ps.entity.ProjectSubEntity;
import org.exoplatform.ps.entity.StaffEntity;
import org.exoplatform.ps.entity.SubCatEntity;
import org.exoplatform.ps.entity.SubContractorEntity;
import org.exoplatform.ps.entity.SubGcEntity;
import org.exoplatform.ps.entity.SubStaffCompanyEntity;
import org.exoplatform.ps.model.StaffUser;
import org.exoplatform.ps.rest.GeneralContarctorsRestService;
import org.exoplatform.ps.storage.api.BBCategoryStorage;
import org.exoplatform.ps.storage.api.ProjectSubRelationShipStorage;
import org.exoplatform.ps.storage.api.SubCatGroupRelationStorage;
import org.exoplatform.ps.storage.api.SubCatStorage;
import org.exoplatform.ps.storage.api.SubUserInfoStorage;
import org.exoplatform.ps.utils.Utils;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipTypeHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.service.rest.RestChecker;
import org.exoplatform.social.service.rest.Util;
import org.exoplatform.upload.UploadService;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Path(value="/subcontarctorsservice")
public class SubContarctorsRestService
implements ResourceContainer {
    private static final String portalContainerName = "portal";
    private static final String[] SUPPORTED_FORMATS = new String[]{"json"};
    private static final Log LOG = ExoLogger.getLogger((String)SubContarctorsRestService.class.getName());
    private static Boolean requestStarted = false;
    private static final String GCS_GROUP = "/organization/gcs";
    private static final String ADMIN_GROUP = "/platform/administrators";
    private static final String DEFAULT_AVATAR_ICON_MIME_TYPE = "image/png";
    private static final String DEFAULT_AVATAR_ICON_NAMESPACE = "projectspace";
    private final CacheControl cacheControl = new CacheControl();
    private final GeneralContractorDAO generalContractorDAO;
    private final UploadService uploadService;
    private final FileService fileService;
    private final SubGcDAO subGcDAO;
    private final SubStaffCompanyDAO subStaffCompanyDAO;
    private final SubCatDAO subCatDAO;
    private final SubContractorDAO subContractorDAO;
    private final OrganizationService orgService;
    private final SubCatStorage subCatStorage;
    private final ProjectSubDAO projectSubDAO;

    public SubContarctorsRestService(SubContractorDAO subContractorDAO, SubCatDAO subCatDAO, GeneralContractorDAO generalContractorDAO, SubCatStorage subCatStorage, SubGcDAO subGcDAO, SubStaffCompanyDAO subStaffCompanyDAO, OrganizationService orgService, UploadService uploadService, FileService fileService, ProjectSubDAO projectSubDAO) {
        this.cacheControl.setNoCache(true);
        this.cacheControl.setNoStore(true);
        this.generalContractorDAO = generalContractorDAO;
        this.subContractorDAO = subContractorDAO;
        this.subGcDAO = subGcDAO;
        this.subCatDAO = subCatDAO;
        this.subStaffCompanyDAO = subStaffCompanyDAO;
        this.uploadService = uploadService;
        this.fileService = fileService;
        this.orgService = orgService;
        this.subCatStorage = subCatStorage;
        this.projectSubDAO = projectSubDAO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="createsubstaff")
    public Response add(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, StaffUser subStaffUser) throws com.sun.star.uno.Exception {
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        try {
            UserHandler uh = this.orgService.getUserHandler();
            try {
                Query query = new Query();
                query.setEmail(subStaffUser.getEmail());
                if (uh.findUsersByQuery(query).getSize() > 0) {
                    LOG.warn((Object)("A Vendor with the email: " + subStaffUser.getEmail() + " exists"));
                    Response response2 = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("A Vendor with the email: " + subStaffUser.getUserid() + " exists")).build();
                    return response2;
                }
                if (uh.findUserByName(subStaffUser.getUserid()) != null) {
                    LOG.warn((Object)"A Vendor with the login  exists");
                    Response response3 = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("A Vendor with the email: " + subStaffUser.getUserid() + " exists")).build();
                    return response3;
                }
                this.startRequest();
                User user = uh.createUserInstance(subStaffUser.getUserid());
                user.setPassword(subStaffUser.getPassword());
                user.setEmail(subStaffUser.getEmail());
                user.setLastName(subStaffUser.getLastName());
                user.setFirstName(subStaffUser.getFirstName());
                user.setDisplayName(subStaffUser.getFirstName() + " " + subStaffUser.getLastName());
                uh.createUser(user, true);
                GroupHandler gHandler = this.orgService.getGroupHandler();
                MembershipHandler mHandler = this.orgService.getMembershipHandler();
                MembershipTypeHandler mtHandler = this.orgService.getMembershipTypeHandler();
                Group subGroup = gHandler.findGroupById("/organization/subcontractors");
                mHandler.linkMembership(user, subGroup, mtHandler.findMembershipType("member"), false);
                LOG.info((Object)("SubContractor " + subStaffUser.getFirstName() + " " + subStaffUser.getFirstName() + " imported"));
                this.endRequest();
                SubContractorEntity subContractorEntity = null;
                if (subStaffUser.getCompanyId() != null) {
                    subContractorEntity = (SubContractorEntity)this.subContractorDAO.find((Serializable)((Object)subStaffUser.getCompanyId()));
                }
                if (subContractorEntity == null) {
                    subContractorEntity = new SubContractorEntity();
                    subContractorEntity.setId(subStaffUser.getCompany().replaceAll("\\W", ""));
                    subContractorEntity.setCompany(subStaffUser.getCompany());
                    subContractorEntity.setEmail(subStaffUser.getCompanyEmail());
                    subContractorEntity.setManager(user.getUserName());
                    subContractorEntity = (SubContractorEntity)this.subContractorDAO.create(subContractorEntity);
                    GeneralContractorEntity generalContractorEntity = (GeneralContractorEntity)this.generalContractorDAO.find(subStaffUser.getGcId());
                    if (generalContractorEntity != null) {
                        SubGcEntity subGcEntity = new SubGcEntity(subContractorEntity, generalContractorEntity);
                        this.subGcDAO.create(subGcEntity);
                    }
                }
                SubStaffCompanyEntity subStaffCompanyEntity = new SubStaffCompanyEntity(subContractorEntity, user.getUserName());
                this.subStaffCompanyDAO.create(subStaffCompanyEntity);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.endRequest();
            }
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", (Object)" User Created");
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (JSONException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="getallsubcats")
    public Response getAllSubcats(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, @QueryParam(value="projectId") String projectId) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        if (sourceIdentity == null || !SubContarctorsRestService.isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        JSONArray jsonArray = new JSONArray();
        StaffDAO staffDAO = (StaffDAO)((Object)PortalContainer.getInstance().getComponentInstanceOfType(StaffDAO.class));
        SubCatDAO subCatDAO = (SubCatDAO)((Object)PortalContainer.getInstance().getComponentInstanceOfType(SubCatDAO.class));
        StaffEntity staff = (StaffEntity)staffDAO.find((Serializable)((Object)ConversationState.getCurrent().getIdentity().getUserId()));
        if (staff == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            SubCatStorage subCatStorage = (SubCatStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubCatStorage.class);
            ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage)PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
            SubCatGroupRelationStorage subCatGroupRelationStorage = (SubCatGroupRelationStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubCatGroupRelationStorage.class);
            MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
            List<Object> subCats = new ArrayList();
            subCats = subCatDAO.getSubCatByGc(staff.getGeneralContractorEntity().getId(), 0, 0);
            for (SubCatEntity subCatEntity : subCats) {
                JSONObject json = new JSONObject();
                String status = "Not Selected";
                try {
                    if (projectSubRelationShipStorage.getRelationShip(subCatEntity.getSubContractor().getId(), projectId, subCatEntity.getCategory().getId()) != null) {
                        status = projectSubRelationShipStorage.getRelationShip(subCatEntity.getSubContractor().getId(), projectId, subCatEntity.getCategory().getId()).getStatus();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                json.put("userName", (Object)subCatEntity.getSubContractor().getId());
                json.put("weburl", (Object)subCatEntity.getSubContractor().getWeburl());
                json.put("proview", (Object)subCatEntity.getSubContractor().getProview());
                json.put("company", (Object)subCatEntity.getSubContractor().getCompany());
                json.put("contact", (Object)subCatEntity.getSubContractor().getDisplayName());
                json.put("categories", (Object)subCatEntity.getCategory().getCatCsiDesc());
                json.put("phone", (Object)subCatEntity.getSubContractor().getPhone());
                json.put("rank", (Object)subCatEntity.getSubContractor().getRank());
                json.put("city", (Object)subCatEntity.getSubContractor().getCity());
                json.put("state", (Object)subCatEntity.getSubContractor().getState());
                json.put("county", (Object)subCatEntity.getSubContractor().getCountry());
                json.put("union", (Object)subCatEntity.getSubContractor().getUnion());
                json.put("nonUnion", (Object)subCatEntity.getSubContractor().getNonUnion());
                json.put("subCatId", (Object)subCatEntity.getId());
                json.put("status", (Object)status);
                jsonArray.put((Object)json);
            }
            response.setContentType("application/json");
            response.setHeader("Cache-Control", "no-store");
            return Response.ok((Object)jsonArray.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @GET
    @Path(value="getcurrentsub")
    public Response getCurrentSub(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo) throws com.sun.star.uno.Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        SubStaffCompanyDAO subStaffCompanyDAO = SubContarctorsRestService.getService(SubStaffCompanyDAO.class, null);
        SubStaffCompanyEntity subStaffCompanyEntity = (SubStaffCompanyEntity)subStaffCompanyDAO.find((Serializable)((Object)sourceIdentity.getRemoteId()));
        if (subStaffCompanyEntity == null) {
            return Response.noContent().build();
        }
        return Response.ok((Object)subStaffCompanyEntity.getSubContractorEntity(), (MediaType)mediaType).build();
    }

    @GET
    @Path(value="getcompany/{id}")
    public Response getcompany(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, @PathParam(value="id") String id) throws com.sun.star.uno.Exception {
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        if (id != null && id != "") {
            SubContractorEntity subContractorEntity = (SubContractorEntity)this.subContractorDAO.find((Serializable)((Object)id));
            if (subContractorEntity == null) {
                return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
            }
            return Response.ok((Object)subContractorEntity, (MediaType)mediaType).build();
        }
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        SubStaffCompanyDAO subStaffCompanyDAO = SubContarctorsRestService.getService(SubStaffCompanyDAO.class, null);
        SubStaffCompanyEntity subStaffCompanyEntity = (SubStaffCompanyEntity)subStaffCompanyDAO.find((Serializable)((Object)sourceIdentity.getRemoteId()));
        if (subStaffCompanyEntity == null) {
            return Response.noContent().build();
        }
        return Response.ok((Object)subStaffCompanyEntity.getSubContractorEntity(), (MediaType)mediaType).build();
    }

    @GET
    @Path(value="getcurrentsubconnect")
    public Response getCurrentSubConnect(@Context HttpServletRequest request, @Context HttpServletResponse response) throws com.sun.star.uno.Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        SubStaffCompanyDAO subStaffCompanyDAO = SubContarctorsRestService.getService(SubStaffCompanyDAO.class, null);
        SubStaffCompanyEntity subStaffCompanyEntity = (SubStaffCompanyEntity)subStaffCompanyDAO.find((Serializable)((Object)sourceIdentity.getRemoteId()));
        if (subStaffCompanyEntity == null) {
            return Response.noContent().build();
        }
        return Response.ok((Object)subStaffCompanyEntity.getSubContractorEntity(), (MediaType)mediaType).build();
    }

    @GET
    @Path(value="getcurrentconnectrole")
    public Response getCurrentConnect(@Context HttpServletRequest request, @Context HttpServletResponse response) throws com.sun.star.uno.Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        StaffDAO staffDAO = SubContarctorsRestService.getService(StaffDAO.class, null);
        StaffEntity staffEntity = (StaffEntity)staffDAO.find((Serializable)((Object)sourceIdentity.getRemoteId()));
        if (staffEntity == null) {
            return Response.noContent().build();
        }
        return Response.ok((Object)staffEntity, (MediaType)mediaType).build();
    }

    @GET
    @Path(value="getallsub")
    public Response getAllSub(@Context HttpServletRequest request, @Context HttpServletResponse response) throws com.sun.star.uno.Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        return Response.ok((Object)this.subContractorDAO.findAll(), (MediaType)mediaType).build();
    }

    @GET
    @Path(value="getallsubCat")
    public Response getAllSubCat(@Context HttpServletRequest request, @Context HttpServletResponse response) throws com.sun.star.uno.Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        return Response.ok((Object)this.subCatDAO.findAll(), (MediaType)mediaType).build();
    }

    @GET
    @Path(value="deletesubCat/{subcatid}")
    public Response DeleteSubCat(@Context HttpServletRequest request, @Context HttpServletResponse response, @PathParam(value="subcatid") String subcatid) throws com.sun.star.uno.Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        SubCatStorage subCatStorage = (SubCatStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubCatStorage.class);
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            subCatStorage.deleteSubCat(subcatid);
            LOG.info((Object)"SubCatEntity is deleted");
            this.endRequest();
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", (Object)" SubCatEntity is deleted");
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("An internal error has occured: " + e.getMessage())).build();
        }
    }

    @GET
    @Path(value="getcurrentsubcategories/{subid}")
    public Response getcurrentsubCategorie(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, @PathParam(value="subid") String sub) throws com.sun.star.uno.Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            return Response.ok(this.subCatStorage.getSubCatsBySubId(sub, 0, 0), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("An internal error has occured: " + e.getMessage())).build();
        }
    }

    @GET
    @Path(value="getcurrentsubprojectcats/{subid}/{projectid}")
    public Response getCurrentSubProjectCats(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, @PathParam(value="subid") String sub, @PathParam(value="projectid") String projectid) throws com.sun.star.uno.Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            return Response.ok(this.projectSubDAO.getRelationShipByProjectIdAndSubId(projectid, sub, 0, 0), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("An internal error has occured: " + e.getMessage())).build();
        }
    }

    @POST
    @Path(value="savesub")
    @Consumes(value={"application/json"})
    public Response saveSub(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, SubContractor userIn) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        BBCategoryStorage bBCategoryStorage = SubContarctorsRestService.getService(BBCategoryStorage.class, null);
        SubUserInfoStorage subUserInfoStorage = SubContarctorsRestService.getService(SubUserInfoStorage.class, null);
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        try {
            String[] uploadResource;
            FileItem fileItem = null;
            if (userIn.getUploadId() != null && (uploadResource = this.uploadService.getUploadResource(userIn.getUploadId())) != null) {
                fileItem = new FileItem(null, userIn.getId(), uploadResource.getMimeType(), DEFAULT_AVATAR_ICON_NAMESPACE, (long)uploadResource.getUploadedSize(), new Date(), sourceIdentity.getRemoteId(), false, (InputStream)new FileInputStream(uploadResource.getStoreLocation()));
                fileItem = this.fileService.writeFile(fileItem);
                LOG.info((Object)("=================================" + fileItem.getFileInfo().getId()));
                userIn.setAvatarId(fileItem.getFileInfo().getId());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            userIn.setUserid(userIn.getCompany().replaceAll("\\W", ""));
            SubContractorEntity subUserInfo = subUserInfoStorage.updateSubUserInfo(userIn.getId(), userIn);
            if (userIn.getSelectedCats() != null) {
                for (String cat : userIn.getSelectedCats()) {
                    CategoryEntity cat_ = bBCategoryStorage.getBBCategory(cat);
                    String subcatis = cat_.getId() + userIn.getUserid();
                    SubCatEntity subCatEntity = this.subCatStorage.createSubCat(subcatis, cat_, subUserInfo, "0");
                }
            }
            LOG.info((Object)"SubContractor imported");
            this.endRequest();
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", (Object)" SubContractor Created");
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("An internal error has occured: " + e.getMessage())).build();
        }
    }

    @POST
    @Path(value="updateprojectsub")
    @Consumes(value={"application/json"})
    public Response updateProjectSub(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, ProjectSubEntity proSub) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        try {
            this.projectSubDAO.update(proSub);
            LOG.info((Object)"ProjectSubEntity updated");
            this.endRequest();
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", (Object)" SProjectSubEntity updated");
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("An internal error has occured: " + e.getMessage())).build();
        }
    }

    @POST
    @Path(value="deleteprojectsubcat/{ProjectSubReltId}")
    @Consumes(value={"application/json"})
    public Response DeleteProjectSubcat(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, @PathParam(value="ProjectSubReltId") String[] ProjectSubReltId) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage)PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        try {
            for (String id : ProjectSubReltId) {
                projectSubRelationShipStorage.deleteProjectSubRelationShip(id);
            }
            LOG.info((Object)"SubCatEntity is deleted");
            this.endRequest();
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", (Object)" SubCatEntity is deleted");
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("An internal error has occured: " + e.getMessage())).build();
        }
    }

    @GET
    @Path(value="sub/{sub}/avatar")
    public Response getSpaceAvatarById(@Context UriInfo uriInfo, @Context Request request, @PathParam(value="sub") String sub) throws IOException {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            InputStream stream = null;
            try {
                Response.ResponseBuilder builder;
                SubContractorEntity sub_ = (SubContractorEntity)this.subContractorDAO.find((Serializable)((Object)sub));
                Long lastUpdated = null;
                if (sub_ != null && sub_.getAvatarId() != null) {
                    lastUpdated = sub_.getLastModifiedDate().getTime();
                } else {
                    stream = GeneralContarctorsRestService.class.getClassLoader().getResourceAsStream("medias/images/logo_default.png");
                }
                EntityTag eTag = null;
                if (lastUpdated != null) {
                    eTag = new EntityTag(Integer.toString(lastUpdated.hashCode()));
                }
                Response.ResponseBuilder responseBuilder = builder = eTag == null ? null : request.evaluatePreconditions(eTag);
                if (builder == null) {
                    if (stream == null) {
                        if (sub_ != null) {
                            stream = Utils.getAvatarInputStream(sub_.getAvatarId());
                        } else {
                            throw new WebApplicationException(Response.Status.NOT_FOUND);
                        }
                    }
                    builder = Response.ok((Object)stream, (String)DEFAULT_AVATAR_ICON_MIME_TYPE);
                    builder.tag(eTag);
                }
                CacheControl cc = new CacheControl();
                cc.setMaxAge(86400);
                builder.cacheControl(cc);
                return builder.cacheControl(cc).build();
            }
            catch (Exception e) {
                LOG.error((Object)"Error getting badge's avatar", (Throwable)e);
                return Response.serverError().entity((Object)"Error getting badge's avatar").build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Unauthorized user").build();
    }

    @POST
    @Path(value="addnotinvited/{projectId}")
    @Consumes(value={"application/json"})
    public Response addNotInvited(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, @PathParam(value="projectId") String projectId, List<String> relations) throws com.sun.star.uno.Exception {
        try {
            org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
            UserHandler uh = this.orgService.getUserHandler();
            SpaceService spaceService = Util.getSpaceService((String)portalContainerName);
            ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage)PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
            IdentityManager identityManager = Util.getIdentityManager((String)portalContainerName);
            MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
            if (sourceIdentity == null) {
                LOG.warn((Object)"UNAUTHORIZED");
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            Space project = spaceService.getSpaceByPrettyName(projectId);
            if (project == null) {
                LOG.warn((Object)"Project not found");
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Project not found").build();
            }
            Boolean isMulti = false;
            for (String subcat : relations) {
                SubCatStorage subCatStorage = (SubCatStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubCatStorage.class);
                SubCatEntity subcat_ = subCatStorage.getSubCat(subcat);
                if (subcat_.getSubContractor().getId() != "" && subcat_.getCategory().getId() != "") {
                    projectSubRelationShipStorage.createProjectSubRelationShip(subcat_, project.getPrettyName(), "NOT_MESS", "", "0", "no");
                    continue;
                }
                LOG.warn((Object)"Sub Id or categorie is null, relationship will not be created");
            }
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", (Object)"Company Contacts have now been added to your project. To message those vendors please click on the \"Not Yet Invited\" tab");
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("An internal error has occured: " + e.getMessage())).build();
        }
    }

    @POST
    @Path(value="addinvited/{projectId}")
    @Consumes(value={"application/json"})
    public Response addInvited(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, @PathParam(value="projectId") String projectId, List<String> relations) throws com.sun.star.uno.Exception {
        try {
            org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
            UserHandler uh = this.orgService.getUserHandler();
            SpaceService spaceService = Util.getSpaceService((String)portalContainerName);
            ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage)PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
            ListenerService listenerService = (ListenerService)PortalContainer.getInstance().getComponentInstanceOfType(ListenerService.class);
            IdentityManager identityManager = Util.getIdentityManager((String)portalContainerName);
            SubCatStorage subCatStorage = (SubCatStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubCatStorage.class);
            MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
            ProjectSubDAO projectSubDAO = (ProjectSubDAO)((Object)PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubDAO.class));
            if (sourceIdentity == null) {
                LOG.warn((Object)"UNAUTHORIZED");
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            Space project = spaceService.getSpaceByPrettyName(projectId);
            if (project == null) {
                LOG.warn((Object)"Project not found");
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Project not found").build();
            }
            for (String subcat : relations) {
                SubCatEntity subcat_ = subCatStorage.getSubCat(subcat);
                if (subcat_.getSubContractor().getId() != "" && subcat_.getCategory().getId() != "") {
                    ProjectSubEntity projectSubEntity = (ProjectSubEntity)projectSubDAO.find((Serializable)((Object)(subcat_.getSubContractor().getId() + "_" + project.getPrettyName() + "_" + subcat_.getCategory().getId())));
                    if (projectSubEntity == null) {
                        projectSubEntity = projectSubRelationShipStorage.createProjectSubRelationShip(subcat_, project.getPrettyName(), "INVITED", "", "0", "no");
                    } else {
                        projectSubEntity.setStatus("INVITED");
                        projectSubEntity = (ProjectSubEntity)projectSubDAO.update(projectSubEntity);
                    }
                    spaceService.addMember(project, projectSubEntity.getSubContractor().getManager());
                    listenerService.broadcast("sendItb", (Object)projectSubEntity, (Object)sourceIdentity.getRemoteId());
                    continue;
                }
                LOG.warn((Object)"Sub Id or categorie is null, relationship will not be created");
            }
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", (Object)"Company Contacts have now been added to your project. To message those vendors please click on the \"Not Yet Invited\" tab");
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("An internal error has occured: " + e.getMessage())).build();
        }
    }

    @GET
    @Path(value="getbidmgndata/{projectId}")
    public Response getBidData(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, @PathParam(value="projectId") String projectId) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        if (sourceIdentity == null || !SubContarctorsRestService.isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        JSONArray jsonAllArray = new JSONArray();
        JSONArray jsonNotInvitedArray = new JSONArray();
        JSONArray jsonInvitedArray = new JSONArray();
        StaffDAO staffDAO = (StaffDAO)((Object)PortalContainer.getInstance().getComponentInstanceOfType(StaffDAO.class));
        SubCatDAO subCatDAO = (SubCatDAO)((Object)PortalContainer.getInstance().getComponentInstanceOfType(SubCatDAO.class));
        ProjectSubDAO projectSubDAO = (ProjectSubDAO)((Object)PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubDAO.class));
        StaffEntity staff = (StaffEntity)staffDAO.find((Serializable)((Object)ConversationState.getCurrent().getIdentity().getUserId()));
        if (staff == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        ArrayList<String> massaged = new ArrayList<String>();
        List<ProjectSubEntity> subs = projectSubDAO.getRelationShipByProjectId(projectId, 0, 0);
        for (ProjectSubEntity projectSubEntity : subs) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("userName", (Object)projectSubEntity.getSubContractor().getId());
            jSONObject.put("company", (Object)projectSubEntity.getSubContractor().getCompany());
            jSONObject.put("rank", (Object)projectSubEntity.getSubContractor().getRank());
            jSONObject.put("email", (Object)"");
            jSONObject.put("phone", (Object)projectSubEntity.getSubContractor().getPhone());
            jSONObject.put("faxnumber", (Object)"");
            jSONObject.put("itbsent", (Object)"");
            jSONObject.put("notes", (Object)projectSubEntity.getNote());
            jSONObject.put("bid", (Object)(projectSubEntity.getBid() != null && !projectSubEntity.getBid().equals("0") ? projectSubEntity.getBid() : ""));
            jSONObject.put("contact", (Object)projectSubEntity.getSubContractor().getDisplayName());
            jSONObject.put("categories", (Object)(projectSubEntity.getCategory().getId() + "-" + projectSubEntity.getCategory().getCatCsiDesc()));
            jSONObject.put("categoryId", (Object)projectSubEntity.getCategory().getId());
            jSONObject.put("relName", (Object)projectSubEntity.getId());
            jSONObject.put("status", (Object)projectSubEntity.getStatus());
            jSONObject.put("union", (Object)projectSubEntity.getSubContractor().getUnion());
            jSONObject.put("nonUnion", (Object)projectSubEntity.getSubContractor().getNonUnion());
            jSONObject.put("bidScoped", (Object)(projectSubEntity.getBidScoped() != null ? projectSubEntity.getBidScoped() : "no"));
            jSONObject.put("subCatId", (Object)(projectSubEntity.getSubContractor().getId() + "_" + projectSubEntity.getCategory().getId()));
            jSONObject.put("selected", (Object)"true");
            jSONObject.put("bbgroups", (Object)"");
            if (projectSubEntity.getStatus().equals("NOT_MESS")) {
                jsonNotInvitedArray.put((Object)jSONObject);
            } else {
                jsonInvitedArray.put((Object)jSONObject);
            }
            massaged.add(projectSubEntity.getSubContractor().getId() + "_" + projectSubEntity.getCategory().getId());
        }
        try {
            List<Object> subCats = new ArrayList();
            subCats = subCatDAO.getSubCatByGc(staff.getGeneralContractorEntity().getId(), 0, 0);
            for (SubCatEntity subCatEntity : subCats) {
                if (massaged.contains(subCatEntity.getId())) continue;
                JSONObject json = new JSONObject();
                json.put("userName", (Object)subCatEntity.getSubContractor().getId());
                json.put("weburl", (Object)subCatEntity.getSubContractor().getWeburl());
                json.put("proview", (Object)subCatEntity.getSubContractor().getProview());
                json.put("company", (Object)subCatEntity.getSubContractor().getCompany());
                json.put("contact", (Object)subCatEntity.getSubContractor().getDisplayName());
                json.put("categories", (Object)(subCatEntity.getCategory().getId() + "-" + subCatEntity.getCategory().getCatCsiDesc()));
                json.put("phone", (Object)subCatEntity.getSubContractor().getPhone());
                json.put("rank", (Object)subCatEntity.getSubContractor().getRank());
                json.put("city", (Object)subCatEntity.getSubContractor().getCity());
                json.put("state", (Object)subCatEntity.getSubContractor().getState());
                json.put("county", (Object)subCatEntity.getSubContractor().getCountry());
                json.put("union", (Object)subCatEntity.getSubContractor().getUnion());
                json.put("nonUnion", (Object)subCatEntity.getSubContractor().getNonUnion());
                json.put("subCatId", (Object)subCatEntity.getId());
                jsonAllArray.put((Object)json);
            }
            response.setContentType("application/json");
            response.setHeader("Cache-Control", "no-store");
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("notInvited", (Object)jsonNotInvitedArray);
            jSONObject.put("invited", (Object)jsonInvitedArray);
            jSONObject.put("allCats", (Object)jsonAllArray);
            return Response.ok((Object)jSONObject.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    public static <T> T getService(Class<T> clazz, String containerName) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        if (containerName != null) {
            container = RootContainer.getInstance().getPortalContainer(containerName);
        }
        if (container.getComponentInstanceOfType(clazz) == null) {
            containerName = PortalContainer.getCurrentPortalContainerName();
            container = RootContainer.getInstance().getPortalContainer(containerName);
        }
        return clazz.cast(container.getComponentInstanceOfType(clazz));
    }

    private void endRequest() {
        if (requestStarted.booleanValue() && this.orgService instanceof ComponentRequestLifecycle) {
            try {
                ((ComponentRequestLifecycle)this.orgService).endRequest((ExoContainer)PortalContainer.getInstance());
            }
            catch (Exception e) {
                LOG.warn((Object)e.getMessage(), (Throwable)e);
            }
            requestStarted = false;
        }
    }

    private void startRequest() {
        if (this.orgService instanceof ComponentRequestLifecycle) {
            ((ComponentRequestLifecycle)this.orgService).startRequest((ExoContainer)PortalContainer.getInstance());
            requestStarted = true;
        }
    }

    public static boolean isAdmin(Identity userId) {
        return userId.isMemberOf(ADMIN_GROUP) || userId.isMemberOf(GCS_GROUP) || userId.getUserId().equals(PropertyManager.getProperty((String)"exo.super.user"));
    }
}

