/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ps.storage.impl;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import org.chromattic.api.ChromatticSession;
import org.chromattic.api.query.QueryBuilder;
import org.chromattic.api.query.QueryResult;
import org.chromattic.core.query.QueryImpl;
import org.exoplatform.commons.chromattic.ChromatticLifeCycle;
import org.exoplatform.commons.chromattic.ChromatticManager;
import org.exoplatform.ps.chromattic.entity.CustomFields;
import org.exoplatform.ps.chromattic.entity.Field;
import org.exoplatform.ps.storage.api.CustomFieldsStorage;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.storage.impl.AbstractStorage;
import org.exoplatform.social.core.storage.query.JCRProperties;
import org.exoplatform.social.core.storage.query.WhereExpression;

public class CustomFieldsStorageImpl
extends AbstractStorage
implements CustomFieldsStorage {
    private static final Log LOG = ExoLogger.getLogger(CustomFieldsStorageImpl.class);
    private static final String CHROMATTIC_LIFECYCLE_NAME = "tbb";
    private ChromatticLifeCycle lifeCycle;

    public CustomFieldsStorageImpl(ChromatticManager chromatticManager, NodeHierarchyCreator nodeHierarchyCreator) {
        this.lifeCycle = chromatticManager.getLifeCycle(CHROMATTIC_LIFECYCLE_NAME);
    }

    @Override
    public ChromatticSession getSession() {
        return this.lifeCycle.getChromattic().openSession();
    }

    @Override
    public void createField(String fieldName, String label, String type, String value, boolean required) throws Exception {
        Node node = this.getSession().getJCRSession().getRootNode();
        if (!(node = node.getNode("production")).hasNode("customfields")) {
            node = node.addNode("customfields", "tbb:customFields");
            node.addMixin("mix:referenceable");
            node.getSession().save();
        } else {
            node = node.getNode("customfields");
        }
        CustomFields parentNode = (CustomFields)this.getSession().findByPath(CustomFields.class, node.getPath(), true);
        Field field = (Field)this.getSession().create(Field.class, fieldName);
        this.getSession().persist((Object)parentNode, (Object)field);
        this.getSession().save();
        field.setFieldName(fieldName);
        field.setLabel(label);
        field.setType(type);
        field.setValue(value);
        field.setRequired(required);
        this.getSession().save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteField(String fieldName) throws Exception {
        try (ChromatticSession session = this.getSession();){
            Field field = (Field)session.findByPath(Field.class, "/production/customfields/" + fieldName, true);
            if (field != null) {
                session.remove((Object)field);
                session.save();
            } else {
                LOG.error((Object)"Node to delete not found");
            }
        }
    }

    @Override
    public void deleteCustomField() throws Exception {
        try (ChromatticSession session = this.getSession();){
            CustomFields customField = (CustomFields)session.findByPath(CustomFields.class, "/production/customfields", true);
            if (customField != null) {
                session.remove((Object)customField);
                session.save();
            } else {
                LOG.error((Object)"Node to delete not found");
            }
        }
    }

    @Override
    public List<Field> getFields() throws Exception {
        QueryBuilder builder = this.getSession().createQueryBuilder(Field.class);
        WhereExpression whereExpression = new WhereExpression();
        whereExpression.like(JCRProperties.path, (Object)"/production/customfields/%");
        builder.where(whereExpression.toString());
        QueryImpl queryImpl = (QueryImpl)builder.get();
        ((org.exoplatform.services.jcr.impl.core.query.QueryImpl)queryImpl.getNativeQuery()).setCaseInsensitiveOrder(true);
        QueryResult results = queryImpl.objects();
        ArrayList<Field> sResult = new ArrayList<Field>();
        while (results.hasNext()) {
            Field field = (Field)results.next();
            sResult.add(field);
        }
        return sResult;
    }
}

