/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.pulse.service.ws;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.RuntimeDelegate;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.exoplatform.addon.pulse.service.activitystatistic.ActivityStatisticBean;
import org.exoplatform.addon.pulse.service.activitystatistic.ActivityStatisticService;
import org.exoplatform.addon.pulse.service.ws.ChartData;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.impl.RuntimeDelegateImpl;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;

@Path(value="activitystatistic")
@Produces(value={"application/json"})
public class RestActivitiesStatistic
implements ResourceContainer {
    private static final String FILTER_BY_DAY = "day";
    private static final String FILTER_BY_WEEK = "week";
    private static final String FILTER_BY_MONTH = "month";
    private static HashMap<String, CommunityStatistic> communityStatisticData;
    private static final Log LOG;
    private ActivityStatisticService service = (ActivityStatisticService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ActivityStatisticService.class);
    private static final CacheControl cacheControl;

    public RestActivitiesStatistic() {
        communityStatisticData = new HashMap();
    }

    @GET
    @Path(value="/upgrade")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    public Response migrateData(@Context SecurityContext sc, @Context UriInfo uriInfo) throws Exception {
        try {
            boolean doUpgrade = this.service.upgrade();
            if (doUpgrade) {
                return Response.ok((Object)"Migrate successfully", (String)"application/json").cacheControl(cacheControl).build();
            }
            return Response.ok((Object)"Migrate failured", (String)"application/json").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            LOG.info((Object)e);
            return Response.ok((Object)"Migrate failured", (String)"application/json").cacheControl(cacheControl).build();
        }
    }

    @GET
    @Path(value="/export/csv/{maxColumn}/{filter}/{from}")
    @Produces(value={"application/csv"})
    public Response getExportCsv(@Context SecurityContext sc, @Context UriInfo uriInfo, @PathParam(value="maxColumn") String maxColumn, @PathParam(value="filter") String filter, @PathParam(value="from") String from, @QueryParam(value="exportNewUsersData") String exportNewUsersData, @QueryParam(value="exportLoginCountData") String exportLoginCountData, @QueryParam(value="exportForumActiveUsersData") String exportForumActiveUsersData, @QueryParam(value="exportNewForumPostsData") String exportNewForumPostsData, @QueryParam(value="exportPlfDownloadsData") String exportPlfDownloadsData, @QueryParam(value="exportUserConnectionData") String exportUserConnectionData, @QueryParam(value="exportSocialPostData") String exportSocialPostData, @QueryParam(value="exportEmailNotificationData") String exportEmailNotificationData) throws Exception {
        if (null == maxColumn || maxColumn.length() == 0 || null == filter || filter.length() == 0 || null == from || from.length() == 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        boolean isExportNewUsersData = false;
        boolean isExportLoginCountData = false;
        boolean isExportForumActiveUsersData = false;
        boolean isExportNewForumPostsData = false;
        boolean isExportPlfDownloadsData = false;
        boolean isExportUserConnectionData = false;
        boolean isExportSocialPostData = false;
        boolean isExportEmailNotificationData = false;
        if (null != exportNewUsersData && exportNewUsersData.equalsIgnoreCase("true")) {
            isExportNewUsersData = true;
        }
        if (null != exportLoginCountData && exportLoginCountData.equalsIgnoreCase("true")) {
            isExportLoginCountData = true;
        }
        if (null != exportForumActiveUsersData && exportForumActiveUsersData.equalsIgnoreCase("true")) {
            isExportForumActiveUsersData = true;
        }
        if (null != exportNewForumPostsData && exportNewForumPostsData.equalsIgnoreCase("true")) {
            isExportNewForumPostsData = true;
        }
        if (null != exportPlfDownloadsData && exportPlfDownloadsData.equalsIgnoreCase("true")) {
            isExportPlfDownloadsData = true;
        }
        if (null != exportUserConnectionData && exportUserConnectionData.equalsIgnoreCase("true")) {
            isExportUserConnectionData = true;
        }
        if (null != exportSocialPostData && exportSocialPostData.equalsIgnoreCase("true")) {
            isExportSocialPostData = true;
        }
        if (null != exportEmailNotificationData && exportEmailNotificationData.equalsIgnoreCase("true")) {
            isExportEmailNotificationData = true;
        }
        Date fromDate = this.parseDate(from);
        String fileName = "export_" + maxColumn + "_" + filter + "_from_" + this.partString(fromDate, "yyyy.MM.dd") + ".csv";
        try {
            HSSFWorkbook workbook = this.buildExportDataForExcel(maxColumn, filter, fromDate, isExportNewUsersData, isExportLoginCountData, isExportForumActiveUsersData, isExportNewForumPostsData, isExportPlfDownloadsData, isExportUserConnectionData, isExportSocialPostData, isExportEmailNotificationData);
            byte[] csvContent = this.buildCsvContent(workbook).getBytes();
            Response.ResponseBuilder response = Response.ok((Object)csvContent);
            response.header("Content-Disposition", (Object)("attachment; filename=" + fileName));
            return response.build();
        }
        catch (Exception e) {
            LOG.info((Object)e.getMessage());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    @GET
    @Path(value="/export/excel/{maxColumn}/{filter}/{from}")
    @Produces(value={"application/vnd.ms-excel"})
    public Response getExportExcel(@Context SecurityContext sc, @Context UriInfo uriInfo, @PathParam(value="maxColumn") String maxColumn, @PathParam(value="filter") String filter, @PathParam(value="from") String from, @QueryParam(value="exportNewUsersData") String exportNewUsersData, @QueryParam(value="exportLoginCountData") String exportLoginCountData, @QueryParam(value="exportForumActiveUsersData") String exportForumActiveUsersData, @QueryParam(value="exportNewForumPostsData") String exportNewForumPostsData, @QueryParam(value="exportPlfDownloadsData") String exportPlfDownloadsData, @QueryParam(value="exportUserConnectionData") String exportUserConnectionData, @QueryParam(value="exportSocialPostData") String exportSocialPostData, @QueryParam(value="exportEmailNotificationData") String exportEmailNotificationData) throws Exception {
        if (null == maxColumn || maxColumn.length() == 0 || null == filter || filter.length() == 0 || null == from || from.length() == 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        boolean isExportNewUsersData = false;
        boolean isExportLoginCountData = false;
        boolean isExportForumActiveUsersData = false;
        boolean isExportNewForumPostsData = false;
        boolean isExportPlfDownloadsData = false;
        boolean isExportUserConnectionData = false;
        boolean isExportSocialPostData = false;
        boolean isExportEmailNotificationData = false;
        if (null != exportNewUsersData && exportNewUsersData.equalsIgnoreCase("true")) {
            isExportNewUsersData = true;
        }
        if (null != exportLoginCountData && exportLoginCountData.equalsIgnoreCase("true")) {
            isExportLoginCountData = true;
        }
        if (null != exportForumActiveUsersData && exportForumActiveUsersData.equalsIgnoreCase("true")) {
            isExportForumActiveUsersData = true;
        }
        if (null != exportNewForumPostsData && exportNewForumPostsData.equalsIgnoreCase("true")) {
            isExportNewForumPostsData = true;
        }
        if (null != exportPlfDownloadsData && exportPlfDownloadsData.equalsIgnoreCase("true")) {
            isExportPlfDownloadsData = true;
        }
        if (null != exportUserConnectionData && exportUserConnectionData.equalsIgnoreCase("true")) {
            isExportUserConnectionData = true;
        }
        if (null != exportSocialPostData && exportSocialPostData.equalsIgnoreCase("true")) {
            isExportSocialPostData = true;
        }
        if (null != exportEmailNotificationData && exportEmailNotificationData.equalsIgnoreCase("true")) {
            isExportEmailNotificationData = true;
        }
        try {
            Date fromDate = this.parseDate(from);
            String fileName = "export_" + maxColumn + "_" + filter + "_from_" + this.partString(fromDate, "yyyy.MM.dd") + ".xls";
            HSSFWorkbook hssfWorkbook = this.buildExportDataForExcel(maxColumn, filter, fromDate, isExportNewUsersData, isExportLoginCountData, isExportForumActiveUsersData, isExportNewForumPostsData, isExportPlfDownloadsData, isExportUserConnectionData, isExportSocialPostData, isExportEmailNotificationData);
            File tempFile = File.createTempFile(fileName, ".tmp");
            FileOutputStream fileOut = new FileOutputStream(tempFile);
            hssfWorkbook.write((OutputStream)fileOut);
            fileOut.flush();
            fileOut.close();
            tempFile.deleteOnExit();
            Response.ResponseBuilder response = Response.ok((Object)tempFile);
            response.header("Content-Disposition", (Object)("attachment; filename=" + fileName));
            return response.build();
        }
        catch (Exception e) {
            LOG.info((Object)e.getStackTrace());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    @GET
    @Path(value="/plfdownload/{maxColumn}/{filter}/{from}")
    @Produces(value={"application/json"})
    public Response getPLFdowloadStatisticByFilter(@Context SecurityContext sc, @Context UriInfo uriInfo, @PathParam(value="maxColumn") String maxColumn, @PathParam(value="filter") String filter, @PathParam(value="from") String from) throws Exception {
        if (null == maxColumn || maxColumn.length() == 0 || null == filter || filter.length() == 0 || null == from || from.length() == 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            Date fromDate = this.parseDate(from);
            ChartData chartData = this.buildPlfDownloadData(maxColumn, filter, fromDate);
            return Response.ok((Object)chartData, (String)"application/json").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            LOG.info((Object)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    @GET
    @Path(value="/{maxColumn}/{filter}/{from}")
    @Produces(value={"application/json"})
    public Response getStatisticByFilter(@Context SecurityContext sc, @Context UriInfo uriInfo, @PathParam(value="maxColumn") String maxColumn, @PathParam(value="filter") String filter, @PathParam(value="from") String from) throws Exception {
        if (null == maxColumn || maxColumn.length() == 0 || null == filter || filter.length() == 0 || null == from || from.length() == 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            Date fromDate = this.parseDate(from);
            ChartData chartData = this.buildStatisticByFilter(maxColumn, filter, fromDate);
            return Response.ok((Object)chartData, (String)"application/json").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            LOG.info((Object)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    @GET
    @Path(value="/all/{from}/{to}")
    @Produces(value={"application/json"})
    public Response getAllStatistic(@Context SecurityContext sc, @Context UriInfo uriInfo, @PathParam(value="from") String from, @PathParam(value="to") String to) throws Exception {
        Date fromDate = this.parseDate(from);
        Date toDate = this.parseDate(to);
        List<ActivityStatisticBean> list = this.service.getListActivityStatisticByDate(fromDate, toDate);
        return Response.ok(list, (String)"application/json").cacheControl(cacheControl).build();
    }

    @GET
    @Path(value="/data-statistic-currentweek")
    @Produces(value={"application/json"})
    public Response getCommunityStatisticCurrentWeek(@Context SecurityContext sc, @Context UriInfo uriInfo) throws Exception {
        String today = this.partString(new Date(), "yyyy-MM-dd");
        CommunityStatistic communityStatistic = communityStatisticData.get(today);
        if (null != communityStatistic) {
            return Response.ok((Object)communityStatistic, (String)"application/json").cacheControl(cacheControl).build();
        }
        communityStatistic = new CommunityStatistic();
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(5, -6);
        ChartData last7DaysData = this.buildStatisticByFilter("7", FILTER_BY_DAY, cal.getTime());
        ChartData weekPlfDownloadData = this.buildPlfDownloadData("2", FILTER_BY_WEEK, cal.getTime());
        communityStatistic.setTotalDownload(weekPlfDownloadData.getPlfDownloadsData().get(0));
        Long last7DaysTotalPost = 0L;
        List<Long> listPost = last7DaysData.getNewForumPostsData();
        for (Long obj : listPost) {
            last7DaysTotalPost = last7DaysTotalPost + obj;
        }
        communityStatistic.setTotalPost(last7DaysTotalPost);
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        IdentityManager identityManager = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
        ListAccess listAccess = identityManager.getIdentitiesByProfileFilter("organization", new ProfileFilter(), false);
        communityStatistic.setTotalMember(listAccess.getSize());
        communityStatisticData.put(today, communityStatistic);
        return Response.ok((Object)communityStatistic, (String)"application/json").cacheControl(cacheControl).build();
    }

    private Date parseDate(String date) {
        try {
            SimpleDateFormat format = new SimpleDateFormat("dd-MM-yyyy");
            Date ret = format.parse(date);
            return ret;
        }
        catch (Exception e) {
            return null;
        }
    }

    private Date parseDate(String date, String formatStr) {
        try {
            SimpleDateFormat format = new SimpleDateFormat(formatStr);
            Date ret = format.parse(date);
            return ret;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String partString(Date date, String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        String s = formatter.format(date);
        return s;
    }

    private String buildCsvContent(HSSFWorkbook workbook) {
        HSSFSheet sheet = workbook.getSheetAt(0);
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i <= sheet.getLastRowNum(); ++i) {
            HSSFRow row = sheet.getRow(i);
            for (int j = 0; j < row.getLastCellNum(); ++j) {
                HSSFCell cell = row.getCell(j);
                int cellType = cell.getCellType();
                if (cellType == 1) {
                    buffer.append(cell.getStringCellValue());
                } else if (cellType == 0) {
                    buffer.append(new DecimalFormat("#").format(cell.getNumericCellValue()));
                }
                if (j >= row.getLastCellNum() - 1) continue;
                buffer.append(',');
            }
            buffer.append('\n');
        }
        return buffer.toString();
    }

    private HSSFWorkbook buildExportDataForExcel(String maxColumn, String filter, Date fromDate, boolean isExportNewUsersData, boolean isExportLoginCountData, boolean isExportForumActiveUsersData, boolean isExportNewForumPostsData, boolean isExportPlfDownloadsData, boolean isExportUserConnectionData, boolean isExportSocialPostData, boolean isExportEmailNotificationData) throws Exception {
        HSSFCell metricTotalCell;
        HSSFCell cell;
        Long total;
        HSSFCell metricCell;
        HSSFRow metricRow;
        ChartData data = this.buildExportData(maxColumn, filter, fromDate, isExportPlfDownloadsData);
        String fileName = "export_" + maxColumn + "_" + filter + "_from_" + this.partString(fromDate, "yyyy.MM.dd") + ".xls";
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet worksheet = workbook.createSheet(fileName);
        HSSFCellStyle headerCellStyle = workbook.createCellStyle();
        HSSFFont hSSFFont = workbook.createFont();
        hSSFFont.setFontName("Arial");
        hSSFFont.setBoldweight((short)700);
        hSSFFont.setColor((short)8);
        headerCellStyle.setFont(hSSFFont);
        HSSFRow headerRow = worksheet.createRow(0);
        HSSFCell cellA1 = headerRow.createCell(0);
        cellA1.setCellValue("Statistics");
        cellA1.setCellStyle(headerCellStyle);
        for (int i = 0; i < data.getListTitle().size(); ++i) {
            HSSFCell cell2 = headerRow.createCell(i + 1);
            cell2.setCellValue(data.getListTitle().get(i));
            cell2.setCellStyle(headerCellStyle);
        }
        HSSFCell totalCell = headerRow.createCell(data.getListTitle().size() + 1);
        totalCell.setCellValue("Total");
        totalCell.setCellStyle(headerCellStyle);
        int rowIndex = 1;
        if (isExportNewUsersData) {
            metricRow = worksheet.createRow(rowIndex);
            metricCell = metricRow.createCell(0);
            metricCell.setCellValue("New Users Registration");
            total = 0L;
            for (int i = 0; i < data.getNewUsersData().size(); ++i) {
                total = total + data.getNewUsersData().get(i);
                cell = metricRow.createCell(i + 1);
                cell.setCellValue((double)data.getNewUsersData().get(i).longValue());
            }
            metricTotalCell = metricRow.createCell(data.getNewUsersData().size() + 1);
            metricTotalCell.setCellValue((double)total.longValue());
            ++rowIndex;
        }
        if (isExportLoginCountData) {
            metricRow = worksheet.createRow(rowIndex);
            metricCell = metricRow.createCell(0);
            metricCell.setCellValue("Nb Unique Login");
            total = 0L;
            for (int i = 0; i < data.getLoginCountData().size(); ++i) {
                total = total + data.getLoginCountData().get(i);
                cell = metricRow.createCell(i + 1);
                cell.setCellValue((double)data.getLoginCountData().get(i).longValue());
            }
            metricTotalCell = metricRow.createCell(data.getLoginCountData().size() + 1);
            metricTotalCell.setCellValue((double)total.longValue());
            ++rowIndex;
        }
        if (isExportForumActiveUsersData) {
            metricRow = worksheet.createRow(rowIndex);
            metricCell = metricRow.createCell(0);
            metricCell.setCellValue("Forum Active Users Average");
            total = 0L;
            int itemHasData = 0;
            for (int i = 0; i < data.getForumActiveUsersData().size(); ++i) {
                total = total + data.getForumActiveUsersData().get(i);
                if (data.getForumActiveUsersData().get(i) > 0L) {
                    ++itemHasData;
                }
                HSSFCell cell3 = metricRow.createCell(i + 1);
                cell3.setCellValue((double)data.getForumActiveUsersData().get(i).longValue());
            }
            HSSFCell metricTotalCell2 = metricRow.createCell(data.getForumActiveUsersData().size() + 1);
            Long average = itemHasData > 0 ? total / (long)itemHasData : 0L;
            metricTotalCell2.setCellValue((double)average.longValue());
            ++rowIndex;
        }
        if (isExportNewForumPostsData) {
            metricRow = worksheet.createRow(rowIndex);
            metricCell = metricRow.createCell(0);
            metricCell.setCellValue("New Forum Posts");
            total = 0L;
            for (int i = 0; i < data.getNewForumPostsData().size(); ++i) {
                total = total + data.getNewForumPostsData().get(i);
                cell = metricRow.createCell(i + 1);
                cell.setCellValue((double)data.getNewForumPostsData().get(i).longValue());
            }
            HSSFCell metricTotalCell3 = metricRow.createCell(data.getNewForumPostsData().size() + 1);
            metricTotalCell3.setCellValue((double)total.longValue());
            ++rowIndex;
        }
        if (isExportUserConnectionData) {
            metricRow = worksheet.createRow(rowIndex);
            metricCell = metricRow.createCell(0);
            metricCell.setCellValue("New User connections");
            total = 0L;
            for (int i = 0; i < data.getUserConnectionData().size(); ++i) {
                total = total + data.getUserConnectionData().get(i);
                cell = metricRow.createCell(i + 1);
                cell.setCellValue((double)data.getUserConnectionData().get(i).longValue());
            }
            HSSFCell metricTotalCell4 = metricRow.createCell(data.getUserConnectionData().size() + 1);
            metricTotalCell4.setCellValue((double)total.longValue());
            ++rowIndex;
        }
        if (isExportSocialPostData) {
            metricRow = worksheet.createRow(rowIndex);
            metricCell = metricRow.createCell(0);
            metricCell.setCellValue("New posts in activities stream");
            total = 0L;
            for (int i = 0; i < data.getSocialPostData().size(); ++i) {
                total = total + data.getSocialPostData().get(i);
                cell = metricRow.createCell(i + 1);
                cell.setCellValue((double)data.getSocialPostData().get(i).longValue());
            }
            HSSFCell metricTotalCell5 = metricRow.createCell(data.getSocialPostData().size() + 1);
            metricTotalCell5.setCellValue((double)total.longValue());
            ++rowIndex;
        }
        if (isExportEmailNotificationData) {
            metricRow = worksheet.createRow(rowIndex);
            metricCell = metricRow.createCell(0);
            metricCell.setCellValue("Number of notification emails sent");
            total = 0L;
            for (int i = 0; i < data.getEmailNotificationData().size(); ++i) {
                total = total + data.getEmailNotificationData().get(i);
                cell = metricRow.createCell(i + 1);
                cell.setCellValue((double)data.getEmailNotificationData().get(i).longValue());
            }
            HSSFCell metricTotalCell6 = metricRow.createCell(data.getEmailNotificationData().size() + 1);
            metricTotalCell6.setCellValue((double)total.longValue());
            ++rowIndex;
        }
        if (isExportPlfDownloadsData) {
            metricRow = worksheet.createRow(rowIndex);
            metricCell = metricRow.createCell(0);
            metricCell.setCellValue("PLF Downloads");
            total = 0L;
            for (int i = 0; i < data.getPlfDownloadsData().size(); ++i) {
                total = total + data.getPlfDownloadsData().get(i);
                cell = metricRow.createCell(i + 1);
                cell.setCellValue((double)data.getPlfDownloadsData().get(i).longValue());
            }
            HSSFCell metricTotalCell7 = metricRow.createCell(data.getPlfDownloadsData().size() + 1);
            metricTotalCell7.setCellValue((double)total.longValue());
            ++rowIndex;
        }
        return workbook;
    }

    private ChartData buildPlfDownloadData(String maxColumn, String filter, Date fromDate) {
        int totalDataCoulumn = 5;
        try {
            totalDataCoulumn = Integer.parseInt(maxColumn);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (filter.equalsIgnoreCase(FILTER_BY_DAY)) {
            ArrayList<String> listTitle = new ArrayList<String>();
            ArrayList<Long> plfDownloadsData = new ArrayList<Long>();
            for (int i = 0; i < totalDataCoulumn; ++i) {
                Calendar calendar = Calendar.getInstance();
                calendar.clear();
                calendar.setTime(fromDate);
                calendar.add(5, i);
                Date toDate = calendar.getTime();
                String toDateStr = this.partString(toDate, "yyyy-MM-dd");
                listTitle.add(this.partString(toDate, "dd-MM-yyyy"));
                String url = "http://sourceforge.net/projects/exo/files/stats/json?start_date=" + toDateStr + "&end_date=" + toDateStr;
                try {
                    String returnValue = this.httpGet(url);
                    plfDownloadsData.add(this.getTotalPlfDownloadDataFromJson(returnValue, toDate));
                    continue;
                }
                catch (Exception e) {
                    LOG.error((Object)e.getMessage());
                    plfDownloadsData.add(0L);
                }
            }
            ChartData chartData = new ChartData();
            chartData.setListTitle(listTitle);
            chartData.setPlfDownloadsData(plfDownloadsData);
            return chartData;
        }
        if (filter.equalsIgnoreCase(FILTER_BY_WEEK)) {
            ArrayList<String> listTitle = new ArrayList<String>();
            ArrayList<Long> plfDownloadsData = new ArrayList<Long>();
            String fromDateStr = this.partString(fromDate, "yyyy-MM-dd");
            Calendar calendar = Calendar.getInstance();
            calendar.clear();
            calendar.setTime(fromDate);
            int fromWeek = calendar.get(3);
            int fromMonth = calendar.get(2);
            if (fromMonth == 11 && fromWeek == 1) {
                fromWeek = 53;
            }
            int fromYear = calendar.get(1);
            calendar.clear();
            calendar.set(3, fromWeek);
            calendar.set(1, fromYear);
            Date beginWeekDate = calendar.getTime();
            calendar.clear();
            calendar.setTime(beginWeekDate);
            calendar.add(5, 6);
            Date endWeekDate = calendar.getTime();
            calendar.clear();
            String toDateStr = this.partString(endWeekDate, "yyyy-MM-dd");
            for (int i = 0; i < totalDataCoulumn; ++i) {
                calendar.setTime(endWeekDate);
                listTitle.add("W" + calendar.get(3) + "-" + calendar.get(1));
                String url = "http://sourceforge.net/projects/exo/files/stats/json?start_date=" + fromDateStr + "&end_date=" + toDateStr;
                try {
                    String returnValue = this.httpGet(url);
                    plfDownloadsData.add(this.getTotalPlfDownloadDataFromJson(returnValue, this.parseDate(fromDateStr, "yyyy-MM-dd")));
                }
                catch (Exception e) {
                    LOG.error((Object)e.getMessage());
                    plfDownloadsData.add(0L);
                }
                calendar.clear();
                fromDate = endWeekDate;
                calendar.setTime(fromDate);
                calendar.add(5, 1);
                fromDate = calendar.getTime();
                fromDateStr = this.partString(fromDate, "yyyy-MM-dd");
                calendar.add(5, 6);
                endWeekDate = calendar.getTime();
                toDateStr = this.partString(endWeekDate, "yyyy-MM-dd");
                calendar.clear();
            }
            ChartData chartData = new ChartData();
            chartData.setListTitle(listTitle);
            chartData.setPlfDownloadsData(plfDownloadsData);
            return chartData;
        }
        if (filter.equalsIgnoreCase(FILTER_BY_MONTH)) {
            ArrayList<String> listTitle = new ArrayList<String>();
            ArrayList<Long> plfDownloadsData = new ArrayList<Long>();
            String fromDateStr = this.partString(fromDate, "yyyy-MM-dd");
            Calendar calendar = Calendar.getInstance();
            calendar.clear();
            calendar.setTime(fromDate);
            int fromMonth = calendar.get(2);
            int fromYear = calendar.get(1);
            calendar.clear();
            calendar.set(2, fromMonth);
            calendar.set(1, fromYear);
            Date beginMonthDate = calendar.getTime();
            calendar.clear();
            calendar.setTime(beginMonthDate);
            int dayOfMonth = calendar.getActualMaximum(5);
            calendar.add(5, dayOfMonth - 1);
            Date endMonthDate = calendar.getTime();
            calendar.clear();
            String toDateStr = this.partString(endMonthDate, "yyyy-MM-dd");
            for (int i = 0; i < totalDataCoulumn; ++i) {
                calendar.setTime(endMonthDate);
                listTitle.add(this.partString(calendar.getTime(), "MMM") + "-" + calendar.get(1));
                String url = "http://sourceforge.net/projects/exo/files/stats/json?start_date=" + fromDateStr + "&end_date=" + toDateStr;
                try {
                    String returnValue = this.httpGet(url);
                    plfDownloadsData.add(this.getTotalPlfDownloadDataFromJson(returnValue, this.parseDate(fromDateStr, "yyyy-MM-dd")));
                }
                catch (Exception e) {
                    plfDownloadsData.add(0L);
                }
                calendar.clear();
                fromDate = endMonthDate;
                calendar.setTime(fromDate);
                calendar.add(5, 1);
                fromDate = calendar.getTime();
                fromDateStr = this.partString(fromDate, "yyyy-MM-dd");
                dayOfMonth = calendar.getActualMaximum(5);
                calendar.add(5, dayOfMonth - 1);
                endMonthDate = calendar.getTime();
                toDateStr = this.partString(endMonthDate, "yyyy-MM-dd");
                calendar.clear();
            }
            ChartData chartData = new ChartData();
            chartData.setListTitle(listTitle);
            chartData.setPlfDownloadsData(plfDownloadsData);
            return chartData;
        }
        return null;
    }

    private ChartData buildExportData(String maxColumn, String filter, Date fromDate, boolean isExportPlfDownloadsData) throws Exception {
        ChartData platformStatisticData = this.buildStatisticByFilter(maxColumn, filter, fromDate);
        if (isExportPlfDownloadsData) {
            ChartData platformDownloadStatisticData = this.buildPlfDownloadData(maxColumn, filter, fromDate);
            platformStatisticData.setPlfDownloadsData(platformDownloadStatisticData.getPlfDownloadsData());
        }
        return platformStatisticData;
    }

    private ChartData buildStatisticByFilter(String maxColumn, String filter, Date fromDate) throws Exception {
        int totalDataCoulumn = 5;
        try {
            totalDataCoulumn = Integer.parseInt(maxColumn);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (filter.equalsIgnoreCase(FILTER_BY_DAY)) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(fromDate);
            calendar.add(5, totalDataCoulumn - 1);
            Date toDate = calendar.getTime();
            List<ActivityStatisticBean> list = this.service.getListActivityStatisticByDate(fromDate, toDate);
            TreeMap<Date, ActivityStatisticBean> dateData = new TreeMap<Date, ActivityStatisticBean>();
            for (int i = 0; i < totalDataCoulumn; ++i) {
                calendar.clear();
                calendar.setTime(fromDate);
                calendar.add(5, i);
                Date nextDate = this.parseDate(this.partString(calendar.getTime(), "dd/MM/yyyy"), "dd/MM/yyyy");
                dateData.put(nextDate, null);
            }
            ArrayList<String> listTitle = new ArrayList<String>();
            ArrayList<Long> newUsersData = new ArrayList<Long>();
            ArrayList<Long> loginCountData = new ArrayList<Long>();
            ArrayList<Long> forumActiveUsersData = new ArrayList<Long>();
            ArrayList<Long> newForumPostsData = new ArrayList<Long>();
            ArrayList<Long> userConnectionData = new ArrayList<Long>();
            ArrayList<Long> socialPostData = new ArrayList<Long>();
            ArrayList<Long> emailNotificationData = new ArrayList<Long>();
            ChartData chartData = new ChartData();
            for (ActivityStatisticBean bean : list) {
                dateData.put(this.parseDate(this.partString(bean.getCreatedDate(), "dd/MM/yyyy"), "dd/MM/yyyy"), bean);
            }
            for (Date key : dateData.keySet()) {
                ActivityStatisticBean bean = (ActivityStatisticBean)dateData.get(key);
                if (bean != null) {
                    listTitle.add(this.partString(bean.getCreatedDate(), "dd-MM-yyyy"));
                    newUsersData.add(bean.getNewUserToday());
                    loginCountData.add(bean.getLoginCountToday());
                    forumActiveUsersData.add(bean.getForumActiveUserToday());
                    newForumPostsData.add(bean.getForumPostToday());
                    userConnectionData.add(bean.getUserConnectionCountToday());
                    socialPostData.add(bean.getSocialPostCountToday());
                    emailNotificationData.add(bean.getEmailNotificationCountToday());
                    continue;
                }
                listTitle.add(this.partString(key, "dd-MM-yyyy"));
                newUsersData.add(0L);
                loginCountData.add(0L);
                forumActiveUsersData.add(0L);
                newForumPostsData.add(0L);
                userConnectionData.add(0L);
                socialPostData.add(0L);
                emailNotificationData.add(0L);
            }
            chartData.setListTitle(listTitle);
            chartData.setNewUsersData(newUsersData);
            chartData.setLoginCountData(loginCountData);
            chartData.setForumActiveUsersData(forumActiveUsersData);
            chartData.setNewForumPostsData(newForumPostsData);
            chartData.setUserConnectionData(userConnectionData);
            chartData.setSocialPostData(socialPostData);
            chartData.setEmailNotificationData(emailNotificationData);
            return chartData;
        }
        if (filter.equalsIgnoreCase(FILTER_BY_WEEK)) {
            Calendar calendar = Calendar.getInstance();
            calendar.clear();
            calendar.setTime(fromDate);
            calendar.add(3, totalDataCoulumn - 1);
            Date nextFewWeek = calendar.getTime();
            List<ActivityStatisticBean> list = this.service.getListActivityStatisticByDate(fromDate, nextFewWeek);
            ArrayList<String> listTitle = new ArrayList<String>();
            ArrayList<Long> newUsersData = new ArrayList<Long>();
            ArrayList<Long> loginCountData = new ArrayList<Long>();
            ArrayList<Long> forumActiveUsersData = new ArrayList<Long>();
            ArrayList<Long> newForumPostsData = new ArrayList<Long>();
            ArrayList<Long> userConnectionData = new ArrayList<Long>();
            ArrayList<Long> socialPostData = new ArrayList<Long>();
            ArrayList<Long> emailNotificationData = new ArrayList<Long>();
            ChartData chartData = new ChartData();
            TreeMap weekData = new TreeMap();
            for (int i = 0; i < totalDataCoulumn; ++i) {
                calendar.clear();
                calendar.setTime(fromDate);
                calendar.add(3, i);
                int weekIndex = calendar.get(3);
                int monthIndex = calendar.get(2);
                if (monthIndex == 11 && weekIndex == 1) {
                    weekIndex = 53;
                }
                int year = calendar.get(1);
                calendar.clear();
                calendar.set(3, weekIndex);
                calendar.set(1, year);
                calendar.add(5, 6);
                String week = "";
                week = calendar.get(2) == 11 && calendar.get(3) == 1 ? "53-" + calendar.get(1) : calendar.get(3) + "-" + calendar.get(1);
                week = week.length() < 7 ? calendar.get(1) + "-" + "0" + week : calendar.get(1) + "-" + week;
                weekData.put(week, new ArrayList());
            }
            for (ActivityStatisticBean bean : list) {
                List<ActivityStatisticBean> listValueOfNode;
                calendar.clear();
                calendar.setTime(bean.getCreatedDate());
                int weekIndex = calendar.get(3);
                int monthIndex = calendar.get(2);
                if (monthIndex == 11 && weekIndex == 1) {
                    weekIndex = 53;
                }
                int year = calendar.get(1);
                calendar.clear();
                calendar.set(3, weekIndex);
                calendar.set(1, year);
                calendar.add(5, 6);
                String week = "";
                week = calendar.get(2) == 11 && calendar.get(3) == 1 ? "53-" + calendar.get(1) : calendar.get(3) + "-" + calendar.get(1);
                String string = week = week.length() < 7 ? calendar.get(1) + "-" + "0" + week : calendar.get(1) + "-" + week;
                if (weekData.containsKey(week)) {
                    listValueOfNode = (List)weekData.get(week);
                    listValueOfNode.add(bean);
                    continue;
                }
                listValueOfNode = new ArrayList();
                listValueOfNode.add(bean);
                weekData.put(week, listValueOfNode);
            }
            for (String key : weekData.keySet()) {
                List listValueOfNode = (List)weekData.get(key);
                Long weekNewUsersValue = 0L;
                Long weekLoginCountValue = 0L;
                Long weekForumActiveUsersValue = 0L;
                Long weekNewForumPostsValue = 0L;
                Long weekUserConnectionValue = 0L;
                Long weekSocialPostsValue = 0L;
                Long weekEmailNotificationValue = 0L;
                for (ActivityStatisticBean obj : listValueOfNode) {
                    weekNewUsersValue = weekNewUsersValue + obj.getNewUserToday();
                    weekLoginCountValue = weekLoginCountValue + obj.getLoginCountToday();
                    weekForumActiveUsersValue = weekForumActiveUsersValue + obj.getForumActiveUserToday();
                    weekNewForumPostsValue = weekNewForumPostsValue + obj.getForumPostToday();
                    weekUserConnectionValue = weekUserConnectionValue + obj.getUserConnectionCountToday();
                    weekSocialPostsValue = weekSocialPostsValue + obj.getSocialPostCountToday();
                    weekEmailNotificationValue = weekEmailNotificationValue + obj.getEmailNotificationCountToday();
                }
                String weekTitle = "W" + key.substring(5, key.length());
                listTitle.add(weekTitle);
                newUsersData.add(weekNewUsersValue);
                loginCountData.add(weekLoginCountValue);
                forumActiveUsersData.add(weekForumActiveUsersValue > 0L ? Long.valueOf(weekForumActiveUsersValue / (long)listValueOfNode.size()) : 0L);
                newForumPostsData.add(weekNewForumPostsValue);
                userConnectionData.add(weekUserConnectionValue);
                socialPostData.add(weekSocialPostsValue);
                emailNotificationData.add(weekEmailNotificationValue);
            }
            chartData.setListTitle(listTitle);
            chartData.setNewUsersData(newUsersData);
            chartData.setLoginCountData(loginCountData);
            chartData.setForumActiveUsersData(forumActiveUsersData);
            chartData.setNewForumPostsData(newForumPostsData);
            chartData.setUserConnectionData(userConnectionData);
            chartData.setSocialPostData(socialPostData);
            chartData.setEmailNotificationData(emailNotificationData);
            return chartData;
        }
        if (filter.equalsIgnoreCase(FILTER_BY_MONTH)) {
            Calendar calendar = Calendar.getInstance();
            calendar.clear();
            calendar.setTime(fromDate);
            calendar.add(2, totalDataCoulumn - 1);
            Date nextFewMonth = calendar.getTime();
            List<ActivityStatisticBean> list = this.service.getListActivityStatisticByDate(fromDate, nextFewMonth);
            ArrayList<String> listTitle = new ArrayList<String>();
            ArrayList<Long> newUsersData = new ArrayList<Long>();
            ArrayList<Long> loginCountData = new ArrayList<Long>();
            ArrayList<Long> forumActiveUsersData = new ArrayList<Long>();
            ArrayList<Long> newForumPostsData = new ArrayList<Long>();
            ArrayList<Long> userConnectionData = new ArrayList<Long>();
            ArrayList<Long> socialPostData = new ArrayList<Long>();
            ArrayList<Long> emailNotificationData = new ArrayList<Long>();
            ChartData chartData = new ChartData();
            TreeMap monthData = new TreeMap();
            for (int i = 0; i < totalDataCoulumn; ++i) {
                calendar.clear();
                calendar.setTime(fromDate);
                calendar.add(2, i);
                String month = calendar.get(1) + "-" + this.partString(calendar.getTime(), "MM") + "-" + this.partString(calendar.getTime(), "MMM") + "-" + calendar.get(1);
                monthData.put(month, new ArrayList());
            }
            for (ActivityStatisticBean bean : list) {
                List<ActivityStatisticBean> listValueOfNode;
                calendar.clear();
                calendar.setTime(bean.getCreatedDate());
                String month = calendar.get(1) + "-" + this.partString(calendar.getTime(), "MM") + "-" + this.partString(calendar.getTime(), "MMM") + "-" + calendar.get(1);
                if (monthData.containsKey(month)) {
                    listValueOfNode = (List)monthData.get(month);
                    listValueOfNode.add(bean);
                    continue;
                }
                listValueOfNode = new ArrayList();
                listValueOfNode.add(bean);
                monthData.put(month, listValueOfNode);
            }
            for (String key : monthData.keySet()) {
                List listValueOfNode = (List)monthData.get(key);
                Long monthNewUsersValue = 0L;
                Long monthLoginCountValue = 0L;
                Long monthForumActiveUsersValue = 0L;
                Long monthNewForumPostsValue = 0L;
                Long monthUserConnectionValue = 0L;
                Long monthSocialPostsValue = 0L;
                Long monthEmailNotificationValue = 0L;
                for (ActivityStatisticBean obj : listValueOfNode) {
                    monthNewUsersValue = monthNewUsersValue + obj.getNewUserToday();
                    monthLoginCountValue = monthLoginCountValue + obj.getLoginCountToday();
                    monthForumActiveUsersValue = monthForumActiveUsersValue + obj.getForumActiveUserToday();
                    monthNewForumPostsValue = monthNewForumPostsValue + obj.getForumPostToday();
                    monthUserConnectionValue = monthUserConnectionValue + obj.getUserConnectionCountToday();
                    monthSocialPostsValue = monthSocialPostsValue + obj.getSocialPostCountToday();
                    monthEmailNotificationValue = monthEmailNotificationValue + obj.getEmailNotificationCountToday();
                }
                listTitle.add(key.substring(8, key.length()));
                newUsersData.add(monthNewUsersValue);
                loginCountData.add(monthLoginCountValue);
                forumActiveUsersData.add(monthForumActiveUsersValue > 0L ? Long.valueOf(monthForumActiveUsersValue / (long)listValueOfNode.size()) : 0L);
                newForumPostsData.add(monthNewForumPostsValue);
                userConnectionData.add(monthUserConnectionValue);
                socialPostData.add(monthSocialPostsValue);
                emailNotificationData.add(monthEmailNotificationValue);
            }
            chartData.setListTitle(listTitle);
            chartData.setNewUsersData(newUsersData);
            chartData.setLoginCountData(loginCountData);
            chartData.setForumActiveUsersData(forumActiveUsersData);
            chartData.setNewForumPostsData(newForumPostsData);
            chartData.setUserConnectionData(userConnectionData);
            chartData.setSocialPostData(socialPostData);
            chartData.setEmailNotificationData(emailNotificationData);
            return chartData;
        }
        return null;
    }

    private long getTotalPlfDownloadDataFromJson(String json, Date startDate) {
        Date today = new Date();
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.setTime(today);
        cal.add(5, 1);
        Date nexDate = cal.getTime();
        cal.clear();
        if (startDate.after(nexDate)) {
            return 0L;
        }
        try {
            JSONObject jsonObj = (JSONObject)JSONValue.parseWithException((String)json);
            String startDateStr = this.partString(startDate, "yyyy-MM-dd");
            String returnStartDateStr = jsonObj.get((Object)"start_date").toString();
            if (!returnStartDateStr.substring(0, 10).equalsIgnoreCase(startDateStr)) {
                return 0L;
            }
            Long total = Long.parseLong(jsonObj.get((Object)"total") + "");
            return total;
        }
        catch (ParseException e) {
            LOG.error((Object)e.getMessage());
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage());
        }
        return 0L;
    }

    private String httpGet(String urlStr) throws IOException {
        String line;
        URL url = new URL(urlStr);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        LOG.debug((Object)("Calling API: " + conn.getURL()));
        if (conn.getResponseCode() != 200) {
            throw new IOException(conn.getResponseMessage());
        }
        BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        StringBuilder sb = new StringBuilder();
        while ((line = rd.readLine()) != null) {
            sb.append(line);
        }
        rd.close();
        conn.disconnect();
        return sb.toString();
    }

    static {
        LOG = ExoLogger.getLogger(RestActivitiesStatistic.class);
        RuntimeDelegate.setInstance((RuntimeDelegate)new RuntimeDelegateImpl());
        cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
    }

    public class CommunityStatistic {
        private long totalMember;
        private long totalPost;
        private long totalDownload;
        private long totalAddon;
        private long totalUserConnection;
        private long totalSocialPost;
        private long totalEmailNotification;

        public long getTotalUserConnection() {
            return this.totalUserConnection;
        }

        public void setTotalUserConnection(long totalUserConnection) {
            this.totalUserConnection = totalUserConnection;
        }

        public long getTotalSocialPost() {
            return this.totalSocialPost;
        }

        public void setTotalSocialPost(long totalSocialPost) {
            this.totalSocialPost = totalSocialPost;
        }

        public long getTotalEmailNotification() {
            return this.totalEmailNotification;
        }

        public void setTotalEmailNotification(long totalEmailNotification) {
            this.totalEmailNotification = totalEmailNotification;
        }

        public long getTotalMember() {
            return this.totalMember;
        }

        public void setTotalMember(long totalMember) {
            this.totalMember = totalMember;
        }

        public long getTotalPost() {
            return this.totalPost;
        }

        public void setTotalPost(long totalPost) {
            this.totalPost = totalPost;
        }

        public long getTotalDownload() {
            return this.totalDownload;
        }

        public void setTotalDownload(long totalDownload) {
            this.totalDownload = totalDownload;
        }

        public long getTotalAddon() {
            return this.totalAddon;
        }

        public void setTotalAddon(long totalAddon) {
            this.totalAddon = totalAddon;
        }
    }
}

