/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.push.filter;

import java.io.IOException;
import java.util.HashMap;
import java.util.stream.Collectors;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.web.filter.Filter;

public class AuthenticationHeaderFilter
implements Filter {
    public static final String HEADER_AUTHORIZATION = "X-Authorization";
    public static final String[] COOKIES_TO_PROPAGATE = new String[]{"JSESSIONID", "JSESSIONIDSSO", "rememberme"};

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        if (req.getRemoteUser() != null) {
            HashMap<String, String> authorizationHeaders = new HashMap<String, String>();
            Cookie[] cookies = req.getCookies();
            for (String cookieName : COOKIES_TO_PROPAGATE) {
                String cookieValue = this.getCookieValue(cookies, cookieName);
                if (cookieValue == null) continue;
                authorizationHeaders.put(cookieName, cookieValue);
            }
            if (!authorizationHeaders.isEmpty()) {
                String authorizationHeaderValue = authorizationHeaders.keySet().stream().map(key -> key + "=" + (String)authorizationHeaders.get(key)).collect(Collectors.joining(";"));
                res.addHeader(HEADER_AUTHORIZATION, authorizationHeaderValue);
            }
        }
        filterChain.doFilter((ServletRequest)req, (ServletResponse)res);
    }

    protected String getCookieValue(Cookie[] cookies, Object key) {
        for (int i = 0; i < cookies.length; ++i) {
            if (!key.equals(cookies[i].getName())) continue;
            return cookies[i].getValue();
        }
        return null;
    }
}

