/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.push.channel.template;

import java.io.Writer;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.NotificationMessageUtils;
import org.exoplatform.commons.api.notification.annotation.TemplateConfig;
import org.exoplatform.commons.api.notification.annotation.TemplateConfigs;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.plugin.NotificationPluginUtils;
import org.exoplatform.commons.api.notification.service.WebNotificationService;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.NotificationUtils;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.notification.LinkProviderUtils;
import org.exoplatform.social.notification.Utils;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;
import org.exoplatform.webui.utils.TimeConvertUtils;

@TemplateConfigs(templates={@TemplateConfig(pluginId="ActivityCommentPlugin", template="war:/push-notifications/templates/ActivityCommentPlugin.gtmpl"), @TemplateConfig(pluginId="ActivityReplyToCommentPlugin", template="war:/push-notifications/templates/ActivityReplyToCommentPlugin.gtmpl"), @TemplateConfig(pluginId="ActivityMentionPlugin", template="war:/push-notifications/templates/ActivityMentionPlugin.gtmpl"), @TemplateConfig(pluginId="LikePlugin", template="war:/push-notifications/templates/LikePlugin.gtmpl"), @TemplateConfig(pluginId="LikeCommentPlugin", template="war:/push-notifications/templates/LikeCommentPlugin.gtmpl"), @TemplateConfig(pluginId="NewUserPlugin", template="war:/push-notifications/templates/NewUserPlugin.gtmpl"), @TemplateConfig(pluginId="PostActivityPlugin", template="war:/push-notifications/templates/PostActivityPlugin.gtmpl"), @TemplateConfig(pluginId="PostActivitySpaceStreamPlugin", template="war:/push-notifications/templates/PostActivitySpaceStreamPlugin.gtmpl"), @TemplateConfig(pluginId="RelationshipReceivedRequestPlugin", template="war:/push-notifications/templates/RelationshipReceivedRequestPlugin.gtmpl"), @TemplateConfig(pluginId="RequestJoinSpacePlugin", template="war:/push-notifications/templates/RequestJoinSpacePlugin.gtmpl"), @TemplateConfig(pluginId="SpaceInvitationPlugin", template="war:/push-notifications/templates/SpaceInvitationPlugin.gtmpl")})
public class PushTemplateProvider
extends TemplateProvider {
    private static final Log LOG = ExoLogger.getLogger(PushTemplateProvider.class);
    private static final String ACCEPT_INVITATION_TO_CONNECT = "social/intranet-notification/confirmInvitationToConnect";
    private static final String REFUSE_INVITATION_TO_CONNECT = "social/intranet-notification/ignoreInvitationToConnect";
    private static final String MESSAGE_JSON_FILE_NAME = "message.json";
    private static final String VALIDATE_SPACE_REQUEST = "social/intranet-notification/validateRequestToJoinSpace";
    private static final String REFUSE_SPACE_REQUEST = "social/intranet-notification/refuseRequestToJoinSpace";
    private static final String ACCEPT_SPACE_INVITATION = "social/intranet-notification/acceptInvitationToJoinSpace";
    private static final String REFUSE_SPACE_INVITATION = "social/intranet-notification/ignoreInvitationToJoinSpace";
    private AbstractTemplateBuilder comment = new AbstractTemplateBuilder(){

        public NotificationInfo getNotificationToStore(NotificationInfo notification) {
            String activityId = notification.getValueOwnerParameter(SocialNotificationUtils.ACTIVITY_ID.getKey());
            String parameterName = SocialNotificationUtils.POSTER.getKey();
            String parameterValue = notification.getValueOwnerParameter(parameterName);
            return SocialNotificationUtils.addUserToPreviousNotification((NotificationInfo)notification, (String)parameterName, (String)activityId, (String)parameterValue);
        }

        protected MessageInfo makeMessage(NotificationContext ctx) {
            NotificationInfo notification = ctx.getNotificationInfo();
            boolean isPopupOverOnly = (Boolean)ctx.value(WebNotificationService.POPUP_OVER);
            String language = this.getLanguage(notification);
            String activityId = notification.getValueOwnerParameter(SocialNotificationUtils.ACTIVITY_ID.getKey());
            String commentId = notification.getValueOwnerParameter(SocialNotificationUtils.COMMENT_ID.getKey());
            ExoSocialActivity activity = Utils.getActivityManager().getActivity(activityId);
            ExoSocialActivity commentActivity = null;
            if (StringUtils.isNotBlank((CharSequence)commentId)) {
                commentActivity = Utils.getActivityManager().getActivity(commentId);
            }
            if (activity == null) {
                LOG.debug("Activity with id '{}' was removed but the notification with id'{}' is remaining", new Object[]{activityId, notification.getId()});
                return null;
            }
            if (activity.isComment()) {
                commentActivity = Utils.getActivityManager().getParentActivity(activity);
            }
            if (commentActivity == null) {
                LOG.debug("Comment of activity with id '{}' was removed but the notification with id'{}' is remaining", new Object[]{commentId, notification.getId()});
                return null;
            }
            if (!Utils.getActivityManager().isNotificationEnabled(commentActivity, notification.getTo())) {
                return null;
            }
            String pluginId = notification.getKey().getId();
            TemplateContext templateContext = TemplateContext.newChannelInstance((ChannelKey)PushTemplateProvider.this.getChannelKey(), (String)pluginId, (String)language);
            templateContext.put((Object)"isIntranet", (Object)"true");
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(notification.getLastModifiedDate());
            templateContext.put((Object)"READ", (Object)(Boolean.valueOf(notification.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey())) != false ? "read" : "unread"));
            templateContext.put((Object)"NOTIFICATION_ID", (Object)notification.getId());
            templateContext.put((Object)"LAST_UPDATED_TIME", (Object)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)cal.getTime(), (String)"EE, dd yyyy", (Locale)new Locale(language), (int)TimeConvertUtils.YEAR));
            templateContext.put((Object)"ACTIVITY", (Object)NotificationUtils.getNotificationActivityTitle((String)PushTemplateProvider.this.getActivityTitle(activity), (String)activity.getType()));
            templateContext.put((Object)"COMMENT", (Object)(isPopupOverOnly ? this.cutStringByMaxLength(PushTemplateProvider.this.getActivityTitle(commentActivity), 30) : PushTemplateProvider.this.getActivityTitle(commentActivity)));
            List users = SocialNotificationUtils.mergeUsers((NotificationInfo)notification, (String)SocialNotificationUtils.POSTER.getKey(), (String)activity.getId(), (String)notification.getValueOwnerParameter(SocialNotificationUtils.POSTER.getKey()));
            int nbUsers = users.size();
            if (nbUsers > 0) {
                Identity lastIdentity = Utils.getIdentityManager().getOrCreateIdentity("organization", (String)users.get(nbUsers - 1), true);
                Profile profile = lastIdentity.getProfile();
                templateContext.put((Object)"USER", (Object)Utils.addExternalFlag((Identity)lastIdentity));
                templateContext.put((Object)"AVATAR", (Object)(profile.getAvatarUrl() != null ? profile.getAvatarUrl() : "/platform-ui/skin/images/avatar/DefaultUserAvatar.png"));
                templateContext.put((Object)"PROFILE_URL", (Object)LinkProvider.getUserProfileUri((String)lastIdentity.getRemoteId()));
                templateContext.put((Object)"NB_USERS", (Object)nbUsers);
                if (nbUsers >= 2) {
                    Identity beforeLastIdentity = Utils.getIdentityManager().getOrCreateIdentity("organization", (String)users.get(nbUsers - 2), true);
                    templateContext.put((Object)"LAST_USER", (Object)Utils.addExternalFlag((Identity)beforeLastIdentity));
                    if (nbUsers > 2) {
                        templateContext.put((Object)"COUNT", (Object)(nbUsers - 2));
                    }
                }
            }
            boolean notHighLightComment = Boolean.parseBoolean(notification.getValueOwnerParameter(NotificationMessageUtils.NOT_HIGHLIGHT_COMMENT_PORPERTY.getKey()));
            String notificationLink = CommonsUtils.getCurrentDomain() + LinkProvider.getSingleActivityUrl((String)(notHighLightComment ? activity.getId() : activity.getId() + "#comment-" + commentActivity.getId()));
            templateContext.put((Object)"VIEW_FULL_DISCUSSION_ACTION_URL", (Object)notificationLink);
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            ctx.setException(templateContext.getException());
            MessageInfo messageInfo = new MessageInfo();
            return messageInfo.body(body).subject(notificationLink).end();
        }

        private String cutStringByMaxLength(String st, int maxLength) {
            if (st == null) {
                return st;
            }
            if ((st = StringEscapeUtils.unescapeHtml4((String)st)).length() <= maxLength) {
                return st;
            }
            String noHtmlSt = st.replaceAll("\\<.*?\\>", "");
            if (noHtmlSt.length() <= maxLength) {
                return noHtmlSt;
            }
            return noHtmlSt.substring(0, maxLength) + "...";
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            return false;
        }
    };
    private AbstractTemplateBuilder replyToComment = new AbstractTemplateBuilder(){

        public NotificationInfo getNotificationToStore(NotificationInfo notification) {
            String activityId = notification.getValueOwnerParameter(SocialNotificationUtils.ACTIVITY_ID.getKey());
            String parameterName = SocialNotificationUtils.POSTER.getKey();
            String parameterValue = notification.getValueOwnerParameter(parameterName);
            return SocialNotificationUtils.addUserToPreviousNotification((NotificationInfo)notification, (String)parameterName, (String)activityId, (String)parameterValue);
        }

        protected MessageInfo makeMessage(NotificationContext ctx) {
            ExoSocialActivity replyToCommentActivity;
            NotificationInfo notification = ctx.getNotificationInfo();
            boolean isPopupOverOnly = (Boolean)ctx.value(WebNotificationService.POPUP_OVER);
            String language = this.getLanguage(notification);
            String activityId = notification.getValueOwnerParameter(SocialNotificationUtils.ACTIVITY_ID.getKey());
            String commentId = notification.getValueOwnerParameter(SocialNotificationUtils.COMMENT_ID.getKey());
            String replyToCommentId = notification.getValueOwnerParameter(SocialNotificationUtils.COMMENT_REPLY_ID.getKey());
            ExoSocialActivity activity = Utils.getActivityManager().getActivity(activityId);
            ExoSocialActivity commentActivity = commentId == null ? null : Utils.getActivityManager().getActivity(commentId);
            ExoSocialActivity exoSocialActivity = replyToCommentActivity = replyToCommentId == null ? null : Utils.getActivityManager().getActivity(replyToCommentId);
            if (commentActivity != null) {
                if (commentActivity.getParentCommentId() == null) {
                    if (replyToCommentActivity == null) {
                        throw new IllegalStateException("Reply to comment ID is missing in context");
                    }
                } else {
                    replyToCommentActivity = commentActivity;
                    commentActivity = null;
                    replyToCommentId = replyToCommentActivity.getId();
                    commentId = replyToCommentActivity.getParentCommentId();
                    activityId = replyToCommentActivity.getParentId();
                    if (activity != null && activity.getId().equals(commentId)) {
                        commentActivity = activity;
                    }
                    if (activity != null && !StringUtils.equals((CharSequence)activity.getId(), (CharSequence)activityId)) {
                        activity = null;
                    }
                }
            }
            if (activity != null && activity.isComment()) {
                if (activity.getParentCommentId() == null) {
                    commentActivity = activity;
                    activity = null;
                    commentId = commentActivity.getId();
                    activityId = commentActivity.getParentId();
                } else {
                    replyToCommentActivity = activity;
                    commentActivity = null;
                    activity = null;
                    replyToCommentId = replyToCommentActivity.getId();
                    commentId = replyToCommentActivity.getParentCommentId();
                    activityId = replyToCommentActivity.getParentId();
                }
            }
            if (activity == null) {
                if (StringUtils.isBlank((CharSequence)activityId)) {
                    throw new IllegalStateException("Cannot find Activity ID in context");
                }
                activity = Utils.getActivityManager().getActivity(activityId);
                if (activity == null) {
                    LOG.warn("Cannot find Activity with id '{}', it will not be displayed in notifications", new Object[]{activityId});
                    return null;
                }
            }
            if (commentActivity == null) {
                if (StringUtils.isBlank((CharSequence)commentId)) {
                    throw new IllegalStateException("Cannot find Parent Comment ID in context");
                }
                commentActivity = Utils.getActivityManager().getActivity(commentId);
                if (commentActivity == null) {
                    LOG.warn("Cannot find Parent Comment with id '{}', it will not be displayed in notifications", new Object[]{commentId});
                    return null;
                }
            }
            if (replyToCommentActivity == null) {
                if (StringUtils.isBlank((CharSequence)replyToCommentId)) {
                    throw new IllegalStateException("Cannot find Reply Comment ID in context");
                }
                replyToCommentActivity = Utils.getActivityManager().getActivity(replyToCommentId);
                if (replyToCommentActivity == null) {
                    LOG.warn("Cannot find Reply Comment with id '{}', it will not be displayed in notifications", new Object[]{replyToCommentId});
                    return null;
                }
            }
            if (!Utils.getActivityManager().isNotificationEnabled(replyToCommentActivity, notification.getTo())) {
                return null;
            }
            notification.with(SocialNotificationUtils.ACTIVITY_ID.getKey(), activity.getId());
            notification.with(SocialNotificationUtils.COMMENT_ID.getKey(), commentActivity.getId());
            notification.with(SocialNotificationUtils.COMMENT_REPLY_ID.getKey(), replyToCommentActivity.getId());
            String pluginId = notification.getKey().getId();
            TemplateContext templateContext = TemplateContext.newChannelInstance((ChannelKey)PushTemplateProvider.this.getChannelKey(), (String)pluginId, (String)language);
            templateContext.put((Object)"isIntranet", (Object)"true");
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(notification.getLastModifiedDate());
            templateContext.put((Object)"READ", (Object)(Boolean.valueOf(notification.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey())) != false ? "read" : "unread"));
            templateContext.put((Object)"NOTIFICATION_ID", (Object)notification.getId());
            templateContext.put((Object)"LAST_UPDATED_TIME", (Object)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)cal.getTime(), (String)"EE, dd yyyy", (Locale)new Locale(language), (int)TimeConvertUtils.YEAR));
            templateContext.put((Object)"ACTIVITY", (Object)NotificationUtils.getNotificationActivityTitle((String)PushTemplateProvider.this.getActivityTitle(activity), (String)activity.getType()));
            templateContext.put((Object)"COMMENT", (Object)NotificationUtils.getNotificationActivityTitle((String)PushTemplateProvider.this.getActivityTitle(commentActivity), (String)activity.getType()));
            templateContext.put((Object)"COMMENT_REPLY", (Object)(isPopupOverOnly ? this.cutStringByMaxLength(PushTemplateProvider.this.getActivityTitle(replyToCommentActivity), 30) : PushTemplateProvider.this.getActivityTitle(replyToCommentActivity)));
            List users = SocialNotificationUtils.mergeUsers((NotificationInfo)notification, (String)SocialNotificationUtils.POSTER.getKey(), (String)activity.getId(), (String)notification.getValueOwnerParameter(SocialNotificationUtils.POSTER.getKey()));
            int nbUsers = users.size();
            if (nbUsers > 0) {
                Identity lastIdentity = Utils.getIdentityManager().getOrCreateIdentity("organization", (String)users.get(nbUsers - 1), true);
                Profile profile = lastIdentity.getProfile();
                templateContext.put((Object)"USER", (Object)Utils.addExternalFlag((Identity)lastIdentity));
                templateContext.put((Object)"AVATAR", (Object)(profile.getAvatarUrl() != null ? profile.getAvatarUrl() : "/platform-ui/skin/images/avatar/DefaultUserAvatar.png"));
                templateContext.put((Object)"PROFILE_URL", (Object)LinkProvider.getUserProfileUri((String)lastIdentity.getRemoteId()));
                templateContext.put((Object)"NB_USERS", (Object)nbUsers);
                if (nbUsers >= 2) {
                    Identity beforeLastIdentity = Utils.getIdentityManager().getOrCreateIdentity("organization", (String)users.get(nbUsers - 2), true);
                    templateContext.put((Object)"LAST_USER", (Object)Utils.addExternalFlag((Identity)beforeLastIdentity));
                    if (nbUsers > 2) {
                        templateContext.put((Object)"COUNT", (Object)(nbUsers - 2));
                    }
                }
            }
            String notificationLink = CommonsUtils.getCurrentDomain() + LinkProvider.getSingleActivityUrl((String)(activity.getId() + "#comment-" + replyToCommentActivity.getId()));
            templateContext.put((Object)"VIEW_FULL_DISCUSSION_ACTION_URL", (Object)notificationLink);
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            ctx.setException(templateContext.getException());
            MessageInfo messageInfo = new MessageInfo();
            return messageInfo.body(body).subject(notificationLink).end();
        }

        private String cutStringByMaxLength(String st, int maxLength) {
            if (st == null) {
                return st;
            }
            if ((st = StringEscapeUtils.unescapeHtml4((String)st)).length() <= maxLength) {
                return st;
            }
            String noHtmlSt = st.replaceAll("\\<.*?\\>", "");
            if (noHtmlSt.length() <= maxLength) {
                return noHtmlSt;
            }
            return noHtmlSt.substring(0, maxLength) + "...";
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            return false;
        }
    };
    private AbstractTemplateBuilder mention = new AbstractTemplateBuilder(){

        protected MessageInfo makeMessage(NotificationContext ctx) {
            String activityLink;
            NotificationInfo notification = ctx.getNotificationInfo();
            String language = this.getLanguage(notification);
            TemplateContext templateContext = TemplateContext.newChannelInstance((ChannelKey)PushTemplateProvider.this.getChannelKey(), (String)notification.getKey().getId(), (String)language);
            String activityId = notification.getValueOwnerParameter(SocialNotificationUtils.ACTIVITY_ID.getKey());
            ExoSocialActivity activity = Utils.getActivityManager().getActivity(activityId);
            if (activity == null) {
                LOG.debug("Notification related to activity with id '{}' couldn't be found. The related notification will be ignored", new Object[]{activityId});
                return null;
            }
            Identity identity = Utils.getIdentityManager().getIdentity(activity.getPosterId(), true);
            Profile profile = identity.getProfile();
            templateContext.put((Object)"isIntranet", (Object)"true");
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(notification.getLastModifiedDate());
            templateContext.put((Object)"READ", (Object)(Boolean.valueOf(notification.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey())) != false ? "read" : "unread"));
            templateContext.put((Object)"NOTIFICATION_ID", (Object)notification.getId());
            templateContext.put((Object)"LAST_UPDATED_TIME", (Object)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)cal.getTime(), (String)"EE, dd yyyy", (Locale)new Locale(language), (int)TimeConvertUtils.YEAR));
            templateContext.put((Object)"USER", (Object)Utils.addExternalFlag((Identity)identity));
            templateContext.put((Object)"AVATAR", (Object)(profile.getAvatarUrl() != null ? profile.getAvatarUrl() : "/platform-ui/skin/images/avatar/DefaultUserAvatar.png"));
            templateContext.put((Object)"PROFILE_URL", (Object)LinkProvider.getUserProfileUri((String)identity.getRemoteId()));
            String activityTitle = PushTemplateProvider.this.getActivityTitle(activity);
            if (activity.isComment()) {
                ExoSocialActivity parentActivity = Utils.getActivityManager().getParentActivity(activity);
                activityTitle = PushTemplateProvider.this.getActivityTitle(parentActivity);
                activityId = parentActivity.getId();
                activityLink = CommonsUtils.getCurrentDomain() + LinkProvider.getSingleActivityUrl((String)(activityId + "#comment-" + activity.getId()));
            } else {
                activityLink = CommonsUtils.getCurrentDomain() + LinkProvider.getSingleActivityUrl((String)activityId);
            }
            templateContext.put((Object)"VIEW_FULL_DISCUSSION_ACTION_URL", (Object)activityLink);
            templateContext.put((Object)"ACTIVITY", (Object)NotificationUtils.getNotificationActivityTitle((String)activityTitle, (String)activity.getType()));
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            ctx.setException(templateContext.getException());
            MessageInfo messageInfo = new MessageInfo();
            return messageInfo.body(body).subject(activityLink).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            return false;
        }
    };
    private AbstractTemplateBuilder like = new LikeTemplateBuilder();
    private AbstractTemplateBuilder likeComment = new LikeTemplateBuilder();
    private AbstractTemplateBuilder newUser = new AbstractTemplateBuilder(){

        protected MessageInfo makeMessage(NotificationContext ctx) {
            NotificationInfo notification = ctx.getNotificationInfo();
            String language = this.getLanguage(notification);
            TemplateContext templateContext = TemplateContext.newChannelInstance((ChannelKey)PushTemplateProvider.this.getChannelKey(), (String)notification.getKey().getId(), (String)language);
            String remoteId = notification.getValueOwnerParameter(SocialNotificationUtils.REMOTE_ID.getKey());
            Identity identity = Utils.getIdentityManager().getOrCreateIdentity("organization", remoteId, true);
            Profile userProfile = identity.getProfile();
            templateContext.put((Object)"isIntranet", (Object)"true");
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(notification.getLastModifiedDate());
            templateContext.put((Object)"READ", (Object)(Boolean.valueOf(notification.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey())) != false ? "read" : "unread"));
            templateContext.put((Object)"NOTIFICATION_ID", (Object)notification.getId());
            templateContext.put((Object)"LAST_UPDATED_TIME", (Object)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)cal.getTime(), (String)"EE, dd yyyy", (Locale)new Locale(language), (int)TimeConvertUtils.YEAR));
            templateContext.put((Object)"USER", (Object)Utils.addExternalFlag((Identity)identity));
            templateContext.put((Object)"PORTAL_NAME", (Object)NotificationPluginUtils.getBrandingPortalName());
            String profileUrl = CommonsUtils.getCurrentDomain() + LinkProvider.getUserProfileUri((String)identity.getRemoteId());
            templateContext.put((Object)"PROFILE_URL", (Object)profileUrl);
            templateContext.put((Object)"AVATAR", (Object)(userProfile.getAvatarUrl() != null ? userProfile.getAvatarUrl() : "/platform-ui/skin/images/avatar/DefaultUserAvatar.png"));
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            ctx.setException(templateContext.getException());
            MessageInfo messageInfo = new MessageInfo();
            return messageInfo.body(body).subject(profileUrl).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            return false;
        }
    };
    private AbstractTemplateBuilder postActivity = new AbstractTemplateBuilder(){

        protected MessageInfo makeMessage(NotificationContext ctx) {
            NotificationInfo notification = ctx.getNotificationInfo();
            String language = this.getLanguage(notification);
            TemplateContext templateContext = TemplateContext.newChannelInstance((ChannelKey)PushTemplateProvider.this.getChannelKey(), (String)notification.getKey().getId(), (String)language);
            String activityId = notification.getValueOwnerParameter(SocialNotificationUtils.ACTIVITY_ID.getKey());
            ExoSocialActivity activity = Utils.getActivityManager().getActivity(activityId);
            if (activity == null) {
                LOG.debug("Activity with id '{}' doesn't exist. The related notification will be ignored", new Object[]{activityId});
                return null;
            }
            if (!Utils.getActivityManager().isNotificationEnabled(activity, notification.getTo())) {
                return null;
            }
            Identity identity = Utils.getIdentityManager().getIdentity(activity.getPosterId(), true);
            Profile profile = identity.getProfile();
            templateContext.put((Object)"isIntranet", (Object)"true");
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(notification.getLastModifiedDate());
            templateContext.put((Object)"READ", (Object)(Boolean.valueOf(notification.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey())) != false ? "read" : "unread"));
            templateContext.put((Object)"NOTIFICATION_ID", (Object)notification.getId());
            templateContext.put((Object)"LAST_UPDATED_TIME", (Object)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)cal.getTime(), (String)"EE, dd yyyy", (Locale)new Locale(language), (int)TimeConvertUtils.YEAR));
            templateContext.put((Object)"AVATAR", (Object)(profile.getAvatarUrl() != null ? profile.getAvatarUrl() : "/platform-ui/skin/images/avatar/DefaultUserAvatar.png"));
            templateContext.put((Object)"ACTIVITY", (Object)NotificationUtils.getNotificationActivityTitle((String)PushTemplateProvider.this.getActivityTitle(activity), (String)activity.getType()));
            templateContext.put((Object)"USER", (Object)Utils.addExternalFlag((Identity)identity));
            templateContext.put((Object)"PROFILE_URL", (Object)LinkProvider.getUserProfileUri((String)identity.getRemoteId()));
            String activityLink = CommonsUtils.getCurrentDomain() + LinkProvider.getSingleActivityUrl((String)activity.getId());
            templateContext.put((Object)"VIEW_FULL_DISCUSSION_ACTION_URL", (Object)activityLink);
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            ctx.setException(templateContext.getException());
            MessageInfo messageInfo = new MessageInfo();
            return messageInfo.body(body).subject(activityLink).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            return false;
        }
    };
    private AbstractTemplateBuilder postActivitySpace = new AbstractTemplateBuilder(){

        protected MessageInfo makeMessage(NotificationContext ctx) {
            NotificationInfo notification = ctx.getNotificationInfo();
            String language = this.getLanguage(notification);
            TemplateContext templateContext = TemplateContext.newChannelInstance((ChannelKey)PushTemplateProvider.this.getChannelKey(), (String)notification.getKey().getId(), (String)language);
            String activityId = notification.getValueOwnerParameter(SocialNotificationUtils.ACTIVITY_ID.getKey());
            ExoSocialActivity activity = Utils.getActivityManager().getActivity(activityId);
            if (activity == null) {
                LOG.debug("Notification related to activity with id '{}' couldn't be found. The related notification will be ignored", new Object[]{activityId});
                return null;
            }
            if (!Utils.getActivityManager().isNotificationEnabled(activity, notification.getTo())) {
                return null;
            }
            Identity identity = Utils.getIdentityManager().getIdentity(activity.getPosterId(), true);
            Profile profile = identity.getProfile();
            Identity spaceIdentity = Utils.getIdentityManager().getOrCreateIdentity("space", activity.getStreamOwner(), true);
            Space space = Utils.getSpaceService().getSpaceByPrettyName(spaceIdentity.getRemoteId());
            if (space == null) {
                return null;
            }
            templateContext.put((Object)"isIntranet", (Object)"true");
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(notification.getLastModifiedDate());
            templateContext.put((Object)"READ", (Object)(Boolean.valueOf(notification.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey())) != false ? "read" : "unread"));
            templateContext.put((Object)"NOTIFICATION_ID", (Object)notification.getId());
            templateContext.put((Object)"LAST_UPDATED_TIME", (Object)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)cal.getTime(), (String)"EE, dd yyyy", (Locale)new Locale(language), (int)TimeConvertUtils.YEAR));
            templateContext.put((Object)"USER", (Object)Utils.addExternalFlag((Identity)identity));
            templateContext.put((Object)"AVATAR", (Object)(profile.getAvatarUrl() != null ? profile.getAvatarUrl() : "/platform-ui/skin/images/avatar/DefaultUserAvatar.png"));
            templateContext.put((Object)"ACTIVITY", (Object)NotificationUtils.getNotificationActivityTitle((String)PushTemplateProvider.this.getActivityTitle(activity), (String)activity.getType()));
            templateContext.put((Object)"SPACE", (Object)space.getDisplayName());
            templateContext.put((Object)"SPACE_URL", (Object)LinkProvider.getActivityUriForSpace((String)space.getPrettyName(), (String)space.getGroupId().replace("/spaces/", "")));
            templateContext.put((Object)"PROFILE_URL", (Object)LinkProvider.getUserProfileUri((String)identity.getRemoteId()));
            String activityLink = CommonsUtils.getCurrentDomain() + LinkProvider.getSingleActivityUrl((String)activity.getId());
            templateContext.put((Object)"VIEW_FULL_DISCUSSION_ACTION_URL", (Object)activityLink);
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            ctx.setException(templateContext.getException());
            MessageInfo messageInfo = new MessageInfo();
            return messageInfo.body(body).subject(activityLink).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            return false;
        }
    };
    private AbstractTemplateBuilder relationshipReceived = new AbstractTemplateBuilder(){

        protected MessageInfo makeMessage(NotificationContext ctx) {
            NotificationInfo notification = ctx.getNotificationInfo();
            String language = this.getLanguage(notification);
            TemplateContext templateContext = TemplateContext.newChannelInstance((ChannelKey)PushTemplateProvider.this.getChannelKey(), (String)notification.getKey().getId(), (String)language);
            String sender = notification.getValueOwnerParameter("sender");
            String status = notification.getValueOwnerParameter("status");
            String toUser = notification.getTo();
            Identity identity = Utils.getIdentityManager().getOrCreateIdentity("organization", sender, true);
            Profile userProfile = identity.getProfile();
            templateContext.put((Object)"isIntranet", (Object)"true");
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(notification.getLastModifiedDate());
            templateContext.put((Object)"READ", (Object)(Boolean.valueOf(notification.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey())) != false ? "read" : "unread"));
            templateContext.put((Object)"NOTIFICATION_ID", (Object)notification.getId());
            templateContext.put((Object)"STATUS", (Object)(status != null && status.equals("accepted") ? "ACCEPTED" : "PENDING"));
            templateContext.put((Object)"LAST_UPDATED_TIME", (Object)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)cal.getTime(), (String)"EE, dd yyyy", (Locale)new Locale(language), (int)TimeConvertUtils.YEAR));
            templateContext.put((Object)"USER", (Object)Utils.addExternalFlag((Identity)identity));
            String senderProfileUrl = CommonsUtils.getCurrentDomain() + LinkProvider.getUserProfileUri((String)identity.getRemoteId());
            templateContext.put((Object)"PROFILE_URL", (Object)senderProfileUrl);
            templateContext.put((Object)"AVATAR", (Object)(userProfile.getAvatarUrl() != null ? userProfile.getAvatarUrl() : "/platform-ui/skin/images/avatar/DefaultUserAvatar.png"));
            templateContext.put((Object)"ACCEPT_CONNECTION_REQUEST_ACTION_URL", (Object)LinkProviderUtils.getWebNotificationRestUrl((String)PushTemplateProvider.ACCEPT_INVITATION_TO_CONNECT, (String)sender, (String)toUser, (String)notification.getId(), (String)PushTemplateProvider.MESSAGE_JSON_FILE_NAME));
            templateContext.put((Object)"REFUSE_CONNECTION_REQUEST_ACTION_URL", (Object)LinkProviderUtils.getWebNotificationRestUrl((String)PushTemplateProvider.REFUSE_INVITATION_TO_CONNECT, (String)sender, (String)toUser, (String)notification.getId(), (String)PushTemplateProvider.MESSAGE_JSON_FILE_NAME));
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            ctx.setException(templateContext.getException());
            MessageInfo messageInfo = new MessageInfo();
            return messageInfo.body(body).subject(senderProfileUrl).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            return false;
        }
    };
    private AbstractTemplateBuilder requestJoinSpace = new AbstractTemplateBuilder(){

        protected MessageInfo makeMessage(NotificationContext ctx) {
            NotificationInfo notification = ctx.getNotificationInfo();
            String language = this.getLanguage(notification);
            TemplateContext templateContext = TemplateContext.newChannelInstance((ChannelKey)PushTemplateProvider.this.getChannelKey(), (String)notification.getKey().getId(), (String)language);
            String status = notification.getValueOwnerParameter("status");
            String spaceId = notification.getValueOwnerParameter(SocialNotificationUtils.SPACE_ID.getKey());
            Space space = Utils.getSpaceService().getSpaceById(spaceId);
            if (space == null) {
                return null;
            }
            Identity identity = Utils.getIdentityManager().getOrCreateIdentity("organization", notification.getValueOwnerParameter("request_from"), true);
            Profile userProfile = identity.getProfile();
            templateContext.put((Object)"isIntranet", (Object)"true");
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(notification.getLastModifiedDate());
            templateContext.put((Object)"READ", (Object)(Boolean.valueOf(notification.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey())) != false ? "read" : "unread"));
            templateContext.put((Object)"STATUS", (Object)(status != null && status.equals("accepted") ? "ACCEPTED" : "PENDING"));
            templateContext.put((Object)"NOTIFICATION_ID", (Object)notification.getId());
            templateContext.put((Object)"LAST_UPDATED_TIME", (Object)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)cal.getTime(), (String)"EE, dd yyyy", (Locale)new Locale(language), (int)TimeConvertUtils.YEAR));
            templateContext.put((Object)"SPACE", (Object)space.getDisplayName());
            templateContext.put((Object)"USER", (Object)Utils.addExternalFlag((Identity)identity));
            String spaceUrl = CommonsUtils.getCurrentDomain() + LinkProvider.getActivityUriForSpace((String)space.getPrettyName(), (String)space.getGroupId().replace("/spaces/", ""));
            templateContext.put((Object)"SPACE_URL", (Object)spaceUrl);
            templateContext.put((Object)"AVATAR", (Object)(userProfile.getAvatarUrl() != null ? userProfile.getAvatarUrl() : "/platform-ui/skin/images/avatar/DefaultUserAvatar.png"));
            templateContext.put((Object)"VALIDATE_SPACE_REQUEST_ACTION_URL", (Object)(LinkProviderUtils.getWebNotificationRestUrl((String)PushTemplateProvider.VALIDATE_SPACE_REQUEST, (String)space.getId(), (String)identity.getRemoteId()) + "/" + notification.getTo() + "/" + notification.getId() + "/message.json"));
            templateContext.put((Object)"REFUSE_SPACE_REQUEST_ACTION_URL", (Object)(LinkProviderUtils.getWebNotificationRestUrl((String)PushTemplateProvider.REFUSE_SPACE_REQUEST, (String)space.getId(), (String)identity.getRemoteId()) + "/" + notification.getTo() + "/" + notification.getId() + "/message.json"));
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            ctx.setException(templateContext.getException());
            MessageInfo messageInfo = new MessageInfo();
            return messageInfo.body(body).subject(spaceUrl).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            return false;
        }
    };
    private AbstractTemplateBuilder spaceInvitation = new AbstractTemplateBuilder(){

        protected MessageInfo makeMessage(NotificationContext ctx) {
            NotificationInfo notification = ctx.getNotificationInfo();
            String language = this.getLanguage(notification);
            TemplateContext templateContext = TemplateContext.newChannelInstance((ChannelKey)PushTemplateProvider.this.getChannelKey(), (String)notification.getKey().getId(), (String)language);
            String status = notification.getValueOwnerParameter("status");
            String spaceId = notification.getValueOwnerParameter(SocialNotificationUtils.SPACE_ID.getKey());
            String sender = notification.getValueOwnerParameter(SocialNotificationUtils.SENDER.getKey());
            Space space = Utils.getSpaceService().getSpaceById(spaceId);
            if (space == null) {
                return null;
            }
            templateContext.put((Object)"isIntranet", (Object)"true");
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(notification.getLastModifiedDate());
            templateContext.put((Object)"READ", (Object)(Boolean.TRUE.equals(Boolean.valueOf(notification.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey()))) ? "read" : "unread"));
            templateContext.put((Object)"STATUS", (Object)(status != null && status.equals("accepted") ? "ACCEPTED" : "PENDING"));
            templateContext.put((Object)"NOTIFICATION_ID", (Object)notification.getId());
            templateContext.put((Object)"LAST_UPDATED_TIME", (Object)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)cal.getTime(), (String)"EE, dd yyyy", (Locale)new Locale(language), (int)TimeConvertUtils.YEAR));
            templateContext.put((Object)"SPACE", (Object)space.getDisplayName());
            templateContext.put((Object)"SENDER_NAME", (Object)sender);
            String spaceUrl = CommonsUtils.getCurrentDomain() + LinkProvider.getActivityUriForSpace((String)space.getPrettyName(), (String)space.getGroupId().replace("/spaces/", ""));
            templateContext.put((Object)"SPACE_URL", (Object)spaceUrl);
            templateContext.put((Object)"SPACE_AVATAR", (Object)(space.getAvatarUrl() != null ? space.getAvatarUrl() : "/platform-ui/skin/images/avatar/DefaultSpaceAvatar.png"));
            templateContext.put((Object)"ACCEPT_SPACE_INVITATION_ACTION_URL", (Object)LinkProviderUtils.getWebNotificationRestUrl((String)PushTemplateProvider.ACCEPT_SPACE_INVITATION, (String)space.getId(), (String)notification.getTo(), (String)notification.getId(), (String)PushTemplateProvider.MESSAGE_JSON_FILE_NAME));
            templateContext.put((Object)"REFUSE_SPACE_INVITATION_ACTION_URL", (Object)LinkProviderUtils.getWebNotificationRestUrl((String)PushTemplateProvider.REFUSE_SPACE_INVITATION, (String)space.getId(), (String)notification.getTo(), (String)notification.getId(), (String)PushTemplateProvider.MESSAGE_JSON_FILE_NAME));
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            ctx.setException(templateContext.getException());
            MessageInfo messageInfo = new MessageInfo();
            return messageInfo.body(body).subject(spaceUrl).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            return false;
        }
    };

    public PushTemplateProvider(InitParams initParams) {
        super(initParams);
        this.templateBuilders.put(PluginKey.key((String)"ActivityCommentPlugin"), this.comment);
        this.templateBuilders.put(PluginKey.key((String)"ActivityReplyToCommentPlugin"), this.replyToComment);
        this.templateBuilders.put(PluginKey.key((String)"ActivityMentionPlugin"), this.mention);
        this.templateBuilders.put(PluginKey.key((String)"LikePlugin"), this.like);
        this.templateBuilders.put(PluginKey.key((String)"LikeCommentPlugin"), this.likeComment);
        this.templateBuilders.put(PluginKey.key((String)"NewUserPlugin"), this.newUser);
        this.templateBuilders.put(PluginKey.key((String)"PostActivityPlugin"), this.postActivity);
        this.templateBuilders.put(PluginKey.key((String)"PostActivitySpaceStreamPlugin"), this.postActivitySpace);
        this.templateBuilders.put(PluginKey.key((String)"RelationshipReceivedRequestPlugin"), this.relationshipReceived);
        this.templateBuilders.put(PluginKey.key((String)"RequestJoinSpacePlugin"), this.requestJoinSpace);
        this.templateBuilders.put(PluginKey.key((String)"SpaceInvitationPlugin"), this.spaceInvitation);
    }

    private String getActivityTitle(ExoSocialActivity activity) {
        return Utils.getActivityManager().getActivityTitle(activity);
    }

    public class LikeTemplateBuilder
    extends AbstractTemplateBuilder {
        public NotificationInfo getNotificationToStore(NotificationInfo notification) {
            String activityId = notification.getValueOwnerParameter(SocialNotificationUtils.ACTIVITY_ID.getKey());
            String parameterName = SocialNotificationUtils.LIKER.getKey();
            String parameterValue = notification.getValueOwnerParameter(parameterName);
            return SocialNotificationUtils.addUserToPreviousNotification((NotificationInfo)notification, (String)parameterName, (String)activityId, (String)parameterValue);
        }

        protected MessageInfo makeMessage(NotificationContext ctx) {
            String notificationLink;
            NotificationInfo notification = ctx.getNotificationInfo();
            String language = this.getLanguage(notification);
            String pluginId = notification.getKey().getId();
            TemplateContext templateContext = TemplateContext.newChannelInstance((ChannelKey)PushTemplateProvider.this.getChannelKey(), (String)pluginId, (String)language);
            String activityId = notification.getValueOwnerParameter(SocialNotificationUtils.ACTIVITY_ID.getKey());
            ExoSocialActivity activity = Utils.getActivityManager().getActivity(activityId);
            if (activity == null) {
                LOG.debug("Notification related to activity with id '{}' couldn't be found. The related notification will be ignored", new Object[]{activityId});
                return null;
            }
            templateContext.put((Object)"isIntranet", (Object)"true");
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(notification.getLastModifiedDate());
            templateContext.put((Object)"READ", (Object)(Boolean.valueOf(notification.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey())) != false ? "read" : "unread"));
            templateContext.put((Object)"NOTIFICATION_ID", (Object)notification.getId());
            templateContext.put((Object)"LAST_UPDATED_TIME", (Object)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)cal.getTime(), (String)"EE, dd yyyy", (Locale)new Locale(language), (int)TimeConvertUtils.YEAR));
            templateContext.put((Object)"ACTIVITY", (Object)NotificationUtils.getNotificationActivityTitle((String)PushTemplateProvider.this.getActivityTitle(activity), (String)activity.getType()));
            templateContext.put((Object)"VIEW_FULL_DISCUSSION_ACTION_URL", (Object)LinkProvider.getSingleActivityUrl((String)activity.getId()));
            if (activity.isComment()) {
                ExoSocialActivity activityOfComment = Utils.getActivityManager().getParentActivity(activity);
                notificationLink = CommonsUtils.getCurrentDomain() + LinkProvider.getSingleActivityUrl((String)(activityOfComment.getId() + "#comment-" + activity.getId()));
            } else {
                notificationLink = CommonsUtils.getCurrentDomain() + LinkProvider.getSingleActivityUrl((String)activity.getId());
            }
            templateContext.put((Object)"VIEW_FULL_DISCUSSION_ACTION_URL", (Object)notificationLink);
            List users = SocialNotificationUtils.mergeUsers((NotificationInfo)notification, (String)SocialNotificationUtils.LIKER.getKey(), (String)activity.getId(), (String)notification.getValueOwnerParameter(SocialNotificationUtils.LIKER.getKey()));
            int nbUsers = users.size();
            if (nbUsers > 0) {
                Identity lastIdentity = Utils.getIdentityManager().getOrCreateIdentity("organization", (String)users.get(nbUsers - 1));
                Profile profile = lastIdentity.getProfile();
                templateContext.put((Object)"USER", (Object)Utils.addExternalFlag((Identity)lastIdentity));
                templateContext.put((Object)"AVATAR", (Object)(profile.getAvatarUrl() != null ? profile.getAvatarUrl() : "/platform-ui/skin/images/avatar/DefaultUserAvatar.png"));
                templateContext.put((Object)"PROFILE_URL", (Object)LinkProvider.getUserProfileUri((String)lastIdentity.getRemoteId()));
                templateContext.put((Object)"NB_USERS", (Object)nbUsers);
                if (nbUsers >= 2) {
                    Identity beforeLastIdentity = Utils.getIdentityManager().getOrCreateIdentity("organization", (String)users.get(nbUsers - 2));
                    templateContext.put((Object)"LAST_USER", (Object)Utils.addExternalFlag((Identity)beforeLastIdentity));
                    if (nbUsers > 2) {
                        templateContext.put((Object)"COUNT", (Object)(nbUsers - 2));
                    }
                }
            }
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            ctx.setException(templateContext.getException());
            MessageInfo messageInfo = new MessageInfo();
            return messageInfo.body(body).subject(notificationLink).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            return false;
        }
    }
}

