/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.push.channel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.portal.branding.BrandingService;
import org.exoplatform.push.channel.PushChannel;
import org.exoplatform.push.domain.Device;
import org.exoplatform.push.domain.Message;
import org.exoplatform.push.exception.InvalidTokenException;
import org.exoplatform.push.service.DeviceService;
import org.exoplatform.push.service.MessagePublisher;
import org.exoplatform.push.service.fcm.FCMLegacyAPIMessagePublisher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class PushChannelTest {
    @Test
    public void shouldSendNoNotifWhenDevicesNull() throws Exception {
        MessagePublisher messagePublisher = (MessagePublisher)Mockito.mock(FCMLegacyAPIMessagePublisher.class);
        DeviceService deviceService = (DeviceService)Mockito.mock(DeviceService.class);
        BrandingService brandingService = (BrandingService)Mockito.mock(BrandingService.class);
        NotificationContext ctx = (NotificationContext)Mockito.mock(NotificationContext.class);
        NotificationInfo notificationInfo = (NotificationInfo)Mockito.mock(NotificationInfo.class);
        Mockito.when((Object)notificationInfo.getKey()).thenReturn((Object)new PluginKey("pluginId"));
        Mockito.when((Object)ctx.getNotificationInfo()).thenReturn((Object)notificationInfo);
        Mockito.when((Object)deviceService.getDevicesByUser(Mockito.anyString())).thenReturn(null);
        PushChannel pushChannel = new PushChannel(messagePublisher, deviceService, brandingService);
        pushChannel.dispatch(ctx, "john");
        ((MessagePublisher)Mockito.verify((Object)messagePublisher, (VerificationMode)Mockito.never())).send((Message)Mockito.any());
    }

    @Test
    public void shouldSendNoNotifWhenNoDevice() throws Exception {
        MessagePublisher messagePublisher = (MessagePublisher)Mockito.mock(FCMLegacyAPIMessagePublisher.class);
        DeviceService deviceService = (DeviceService)Mockito.mock(DeviceService.class);
        NotificationContext ctx = (NotificationContext)Mockito.mock(NotificationContext.class);
        BrandingService brandingService = (BrandingService)Mockito.mock(BrandingService.class);
        NotificationInfo notificationInfo = (NotificationInfo)Mockito.mock(NotificationInfo.class);
        Mockito.when((Object)notificationInfo.getKey()).thenReturn((Object)new PluginKey("pluginId"));
        Mockito.when((Object)ctx.getNotificationInfo()).thenReturn((Object)notificationInfo);
        Mockito.when((Object)deviceService.getDevicesByUser(Mockito.anyString())).thenReturn(new ArrayList());
        PushChannel pushChannel = new PushChannel(messagePublisher, deviceService, brandingService);
        pushChannel.dispatch(ctx, "john");
        ((MessagePublisher)Mockito.verify((Object)messagePublisher, (VerificationMode)Mockito.never())).send((Message)Mockito.any());
    }

    @Test
    public void shouldSendNotifWhenDevicesExist() throws Exception {
        MessagePublisher messagePublisher = (MessagePublisher)Mockito.mock(FCMLegacyAPIMessagePublisher.class);
        DeviceService deviceService = (DeviceService)Mockito.mock(DeviceService.class);
        NotificationContext ctx = (NotificationContext)Mockito.mock(NotificationContext.class);
        BrandingService brandingService = (BrandingService)Mockito.mock(BrandingService.class);
        NotificationInfo notificationInfo = (NotificationInfo)Mockito.mock(NotificationInfo.class);
        Mockito.when((Object)notificationInfo.getKey()).thenReturn((Object)new PluginKey("pluginId"));
        Mockito.when((Object)ctx.getNotificationInfo()).thenReturn((Object)notificationInfo);
        Mockito.when((Object)deviceService.getDevicesByUser(Mockito.anyString())).thenReturn(Arrays.asList(new Device(), new Device()));
        PushChannel pushChannel = new PushChannel(messagePublisher, deviceService, brandingService);
        ArgumentCaptor messageArgs = ArgumentCaptor.forClass(Message.class);
        pushChannel.dispatch(ctx, "john");
        ((MessagePublisher)Mockito.verify((Object)messagePublisher, (VerificationMode)Mockito.times((int)2))).send((Message)messageArgs.capture());
        List messages = messageArgs.getAllValues();
        Assert.assertNotNull((Object)messages);
        Assert.assertEquals((long)2L, (long)messages.size());
    }

    @Test
    public void shouldDeleteDeviceWhenTokenIsInvalid() throws Exception {
        MessagePublisher messagePublisher = (MessagePublisher)Mockito.mock(FCMLegacyAPIMessagePublisher.class);
        DeviceService deviceService = (DeviceService)Mockito.mock(DeviceService.class);
        NotificationContext ctx = (NotificationContext)Mockito.mock(NotificationContext.class);
        BrandingService brandingService = (BrandingService)Mockito.mock(BrandingService.class);
        NotificationInfo notificationInfo = (NotificationInfo)Mockito.mock(NotificationInfo.class);
        ((MessagePublisher)Mockito.doThrow((Throwable[])new Throwable[]{new InvalidTokenException()}).when((Object)messagePublisher)).send((Message)Mockito.any(Message.class));
        Mockito.when((Object)notificationInfo.getKey()).thenReturn((Object)new PluginKey("pluginId"));
        Mockito.when((Object)ctx.getNotificationInfo()).thenReturn((Object)notificationInfo);
        Device device = new Device();
        device.setToken("token1");
        Mockito.when((Object)deviceService.getDevicesByUser(Mockito.anyString())).thenReturn(Arrays.asList(device));
        PushChannel pushChannel = new PushChannel(messagePublisher, deviceService, brandingService);
        pushChannel.dispatch(ctx, "john");
        ArgumentCaptor messageArgs = ArgumentCaptor.forClass(Message.class);
        ((MessagePublisher)Mockito.verify((Object)messagePublisher, (VerificationMode)Mockito.times((int)1))).send((Message)messageArgs.capture());
        List messages = messageArgs.getAllValues();
        Assert.assertNotNull((Object)messages);
        Assert.assertEquals((long)1L, (long)messages.size());
        ArgumentCaptor tokenArgs = ArgumentCaptor.forClass(String.class);
        ((DeviceService)Mockito.verify((Object)deviceService, (VerificationMode)Mockito.times((int)1))).getDeviceByToken((String)tokenArgs.capture());
        String token = (String)tokenArgs.getValue();
        Assert.assertEquals((Object)"token1", (Object)token);
    }
}

