/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.rhmanagement.services;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.exoplatform.rhmanagement.dao.VacationRequestDAO;
import org.exoplatform.rhmanagement.dto.VacationRequestDTO;
import org.exoplatform.rhmanagement.entity.VacationRequestEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VacationRequestService {
    private final Logger LOG = LoggerFactory.getLogger(VacationRequestService.class);
    private VacationRequestDAO vacationRequestDAO = new VacationRequestDAO();

    public VacationRequestDTO save(VacationRequestDTO entity, boolean newRequest) {
        if (entity == null) {
            throw new IllegalStateException("Parameter 'entity' is null");
        }
        VacationRequestEntity vacationRequestEntity = null;
        if (newRequest) {
            entity.setCreationDate(new Date());
            vacationRequestEntity = (VacationRequestEntity)this.vacationRequestDAO.create(this.convert(entity));
        } else {
            vacationRequestEntity = (VacationRequestEntity)this.vacationRequestDAO.update(this.convert(entity));
        }
        return this.convert(vacationRequestEntity);
    }

    public void remove(VacationRequestDTO entity) {
        if (entity == null) {
            throw new IllegalStateException("Parameter 'entity' = + " + entity + " or 'entity.id' is null");
        }
        this.vacationRequestDAO.delete(this.convert(entity));
    }

    public List<VacationRequestDTO> getVacationRequests(int offset, int limit) {
        if (offset < 0) {
            throw new IllegalArgumentException("Method getVacationRequests - Parameter 'offset' must be positive");
        }
        List<VacationRequestEntity> entities = this.vacationRequestDAO.getVacationRequests(offset, limit);
        ArrayList<VacationRequestDTO> dtos = new ArrayList<VacationRequestDTO>();
        for (VacationRequestEntity entity : entities) {
            dtos.add(this.convert(entity));
        }
        return dtos;
    }

    public VacationRequestDTO getVacationRequest(long id) {
        List<VacationRequestEntity> entities = this.vacationRequestDAO.getVacationRequestbyId(id);
        if (entities.size() != 0) {
            return this.convert(entities.get(0));
        }
        return null;
    }

    public List<VacationRequestDTO> getVacationRequestsByUserId(String userId, int offset, int limit) {
        if (offset < 0) {
            throw new IllegalArgumentException("Method getVacationRequests - Parameter 'offset' must be positive");
        }
        List<VacationRequestEntity> entities = this.vacationRequestDAO.getVacationRequestsByUserId(userId, offset, limit);
        ArrayList<VacationRequestDTO> dtos = new ArrayList<VacationRequestDTO>();
        for (VacationRequestEntity entity : entities) {
            dtos.add(this.convert(entity));
        }
        return dtos;
    }

    public List<VacationRequestDTO> getVacationRequestsByUserIdAndStatus(String userId, String status, int offset, int limit) {
        if (offset < 0) {
            throw new IllegalArgumentException("Method getVacationRequests - Parameter 'offset' must be positive");
        }
        List<VacationRequestEntity> entities = this.vacationRequestDAO.getVacationRequestsByUserIdAndStatus(userId, status, offset, limit);
        ArrayList<VacationRequestDTO> dtos = new ArrayList<VacationRequestDTO>();
        for (VacationRequestEntity entity : entities) {
            dtos.add(this.convert(entity));
        }
        return dtos;
    }

    public List<VacationRequestDTO> getActiveVacationRequestsByUserId(String userId, int offset, int limit) {
        if (offset < 0) {
            throw new IllegalArgumentException("Method getVacationRequests - Parameter 'offset' must be positive");
        }
        List<VacationRequestEntity> entities = this.vacationRequestDAO.getActiveVacationRequestsByUserId(userId, offset, limit);
        ArrayList<VacationRequestDTO> dtos = new ArrayList<VacationRequestDTO>();
        for (VacationRequestEntity entity : entities) {
            dtos.add(this.convert(entity));
        }
        return dtos;
    }

    public long getVacationRequestesCount() {
        return this.vacationRequestDAO.getVacationRequestesCount();
    }

    private VacationRequestEntity convert(VacationRequestDTO dto) {
        VacationRequestEntity entity = new VacationRequestEntity();
        entity.setId(dto.getId());
        entity.setUserId(dto.getUserId());
        entity.setUserFullName(dto.getUserFullName());
        entity.setDaysNumber(dto.getDaysNumber());
        entity.setFromDate(dto.getFromDate());
        entity.setToDate(dto.getToDate());
        entity.setReason(dto.getReason());
        entity.setVacationType(dto.getVacationType());
        entity.setSubstitute(dto.getSubstitute());
        entity.setType(dto.getType());
        entity.setStatus(dto.getStatus());
        entity.setCreationDate(dto.getCreationDate());
        return entity;
    }

    private VacationRequestDTO convert(VacationRequestEntity entity) {
        VacationRequestDTO dto = new VacationRequestDTO();
        dto.setId(entity.getId());
        dto.setUserFullName(entity.getUserFullName());
        dto.setUserId(entity.getUserId());
        dto.setDaysNumber(entity.getDaysNumber());
        dto.setFromDate(entity.getFromDate());
        dto.setToDate(entity.getToDate());
        dto.setReason(entity.getReason());
        dto.setVacationType(entity.getVacationType());
        dto.setSubstitute(entity.getSubstitute());
        dto.setType(entity.getType());
        dto.setStatus(entity.getStatus());
        dto.setCreationDate(entity.getCreationDate());
        return dto;
    }
}

