/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.rhmanagement.integration.notification;

import java.util.HashSet;
import java.util.LinkedList;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.rhmanagement.dto.VacationRequestDTO;
import org.exoplatform.rhmanagement.dto.ValidatorDTO;
import org.exoplatform.rhmanagement.services.Utils;
import org.exoplatform.rhmanagement.services.VacationRequestService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.core.manager.IdentityManager;

public class RequestRepliedPlugin
extends BaseNotificationPlugin {
    public static final ArgumentLiteral<ValidatorDTO> VALIDATOR = new ArgumentLiteral(ValidatorDTO.class, "validator");
    private static final Log LOG = ExoLogger.getLogger(RequestRepliedPlugin.class);
    public static final String ID = "RequestRepliedPlugin";
    IdentityManager identityManager;

    public RequestRepliedPlugin(InitParams initParams, IdentityManager identityManager) {
        super(initParams);
        this.identityManager = identityManager;
    }

    public String getId() {
        return ID;
    }

    public boolean isValid(NotificationContext ctx) {
        return true;
    }

    protected NotificationInfo makeNotification(NotificationContext ctx) {
        ValidatorDTO obj = (ValidatorDTO)ctx.value(VALIDATOR);
        HashSet<String> receivers = new HashSet<String>();
        try {
            receivers.add(obj.getUserId());
            for (User rhManager : Utils.getRhManagers()) {
                if (receivers.contains(rhManager.getUserName())) continue;
                receivers.add(rhManager.getUserName());
            }
        }
        catch (Exception ex) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
        }
        String userId = obj.getValidatorUserId();
        StringBuilder activityId = new StringBuilder(userId);
        activityId.append("-").append(obj.getRequestId());
        VacationRequestDTO vacationRequest = ((VacationRequestService)CommonsUtils.getService(VacationRequestService.class)).getVacationRequest(obj.getRequestId());
        String vacationUrl = CommonsUtils.getCurrentDomain() + "/portal/intranet/rh-management?rid=" + obj.getRequestId();
        return NotificationInfo.instance().setFrom(userId).to(new LinkedList(receivers)).with("creator", userId).with("from", vacationRequest.getFromDate().toString()).with("to", vacationRequest.getToDate().toString()).with("userName", vacationRequest.getUserId().toString()).with("vacationUrl", vacationUrl).with("activityId", activityId.toString()).key(this.getKey()).end();
    }
}

