/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.rhmanagement.integration.notification;

import java.util.HashSet;
import java.util.LinkedList;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.rhmanagement.dto.UserRHDataDTO;
import org.exoplatform.rhmanagement.services.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;

public class VacationBalanceNotificationPlugin
extends BaseNotificationPlugin {
    public static final ArgumentLiteral<UserRHDataDTO> EMPLOYEE = new ArgumentLiteral(UserRHDataDTO.class, "employee");
    public static final ArgumentLiteral<Float> DAYS_TO_CONSUME = new ArgumentLiteral(Float.class, "daysToConsume");
    private static final Log LOG = ExoLogger.getLogger(VacationBalanceNotificationPlugin.class);
    public static final String ID = "VacationBalanceNotificationPlugin";

    public VacationBalanceNotificationPlugin(InitParams initParams) {
        super(initParams);
    }

    public String getId() {
        return ID;
    }

    public boolean isValid(NotificationContext ctx) {
        return true;
    }

    protected NotificationInfo makeNotification(NotificationContext ctx) {
        UserRHDataDTO obj = (UserRHDataDTO)ctx.value(EMPLOYEE);
        Float nDays = (Float)ctx.value(DAYS_TO_CONSUME);
        String userId = obj.getUserId();
        HashSet<String> receivers = new HashSet<String>();
        receivers.add(userId);
        for (User rh : Utils.getRhManagers()) {
            receivers.add(rh.getUserName());
        }
        StringBuilder activityId = new StringBuilder(userId);
        activityId.append("-").append(obj.getUserId());
        return NotificationInfo.instance().setFrom(userId).to(new LinkedList(receivers)).with("creator", userId).with("daysToConsume", nDays.toString()).with("activityId", activityId.toString()).key(this.getKey()).end();
    }
}

