/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.rhmanagement.dao;

import java.util.List;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.rhmanagement.entity.CommentEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommentDAO
extends GenericDAOJPAImpl<CommentEntity, String> {
    private static final Logger LOG = LoggerFactory.getLogger(CommentDAO.class);

    public List<CommentEntity> getCommentsByRequestId(long id, String commentType, int offset, int limit) {
        try {
            if (offset >= 0 && limit > 0) {
                return this.getEntityManager().createNamedQuery("commentEntity.findByRequestId", CommentEntity.class).setParameter("requestId", (Object)id).setParameter("commentType", (Object)commentType).setFirstResult(offset).setMaxResults(limit).getResultList();
            }
            return this.getEntityManager().createNamedQuery("commentEntity.findByRequestId", CommentEntity.class).setParameter("requestId", (Object)id).setParameter("commentType", (Object)commentType).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get comments with offset = '" + offset + "' and limit = '" + limit + "'.", (Throwable)e);
            throw e;
        }
    }

    public long getCommentsByRequestIdCount(long id, String commentType) {
        try {
            return (Long)this.getEntityManager().createNamedQuery("commentEntity.count", Long.class).setParameter("requesId", (Object)id).setParameter("commentType", (Object)commentType).getSingleResult();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get comments count.", (Throwable)e);
            throw e;
        }
    }
}

