/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.rhmanagement.services.listener;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.exoplatform.agenda.exception.AgendaException;
import org.exoplatform.agenda.model.Calendar;
import org.exoplatform.agenda.service.AgendaCalendarService;
import org.exoplatform.agenda.service.AgendaEventService;
import org.exoplatform.agenda.util.RestUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.rhmanagement.dto.VacationRequestDTO;
import org.exoplatform.rhmanagement.dto.ValidatorDTO;
import org.exoplatform.rhmanagement.integration.notification.RequestStatusChangedPlugin;
import org.exoplatform.rhmanagement.services.Utils;
import org.exoplatform.rhmanagement.services.ValidatorService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class UpdateRequestListener
extends Listener<Set<String>, VacationRequestDTO> {
    private static final Log LOG = ExoLogger.getLogger(UpdateRequestListener.class);
    private ExoContainer container;
    private IdentityManager identityManager;
    private AgendaEventService agendaEventService;
    private AgendaCalendarService agendaCalendarService;
    private SpaceService spaceService;

    public UpdateRequestListener(ExoContainer container, IdentityManager identityManager, SpaceService spaceService) {
        this.container = container;
        this.identityManager = identityManager;
        this.spaceService = spaceService;
    }

    public void onEvent(Event event) throws Exception, AgendaException {
        VacationRequestDTO vr = (VacationRequestDTO)event.getData();
        String currentUser = (String)event.getSource();
        HashSet<String> receivers = new HashSet<String>();
        receivers.add(vr.getUserId());
        ValidatorService validatorService = (ValidatorService)CommonsUtils.getService(ValidatorService.class);
        for (ValidatorDTO validator : validatorService.getValidatorsByRequestId(vr.getId(), 0, 0)) {
            receivers.add(validator.getValidatorUserId());
        }
        if ("validated".equals(vr.getStatus()) || "canceled".equals(vr.getStatus()) || "approved".equals(vr.getStatus())) {
            try {
                for (User rh : Utils.getRhManagers()) {
                    if (rh.getUserName().equals(currentUser)) continue;
                    receivers.add(rh.getUserName());
                }
            }
            catch (Exception e) {
                LOG.error("Error when add receivers user", new Object[]{e.getMessage(), e});
            }
        }
        NotificationContext ctx = NotificationContextImpl.cloneInstance().append(RequestStatusChangedPlugin.REQUEST, (Object)vr).append(RequestStatusChangedPlugin.CURRENT_USER, (Object)currentUser).append(RequestStatusChangedPlugin.RECEIVERS, receivers);
        ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"RequestStatusChangedPlugin"))).execute(ctx);
        long userIdentityId = RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager);
        if ("validated".equals(vr.getStatus())) {
            org.exoplatform.agenda.model.Event calendarEvent = new org.exoplatform.agenda.model.Event();
            Space space = this.spaceService.getSpaceByPrettyName("exo_employees");
            if (space != null) {
                List calendar = this.getCalendarService().getCalendars(0, 0, vr.getUserId());
                for (Calendar cal : calendar) {
                    if (!space.getDisplayName().equals(cal.getTitle())) continue;
                    calendarEvent.setCalendarId(cal.getId());
                }
            }
            calendarEvent.setSummary(vr.getUserFullName() + " " + vr.getType());
            ZonedDateTime start = ZonedDateTime.ofInstant(vr.getFromDate().toInstant(), ZoneId.systemDefault());
            ZonedDateTime end = ZonedDateTime.ofInstant(vr.getToDate().toInstant(), ZoneId.systemDefault());
            calendarEvent.setStart(start);
            calendarEvent.setEnd(end);
            org.exoplatform.agenda.model.Event event2 = this.getEventService().createEvent(calendarEvent, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, true, userIdentityId);
        }
        if ("canceled".equals(vr.getStatus())) {
            this.getEventService().deleteEventById(vr.getId(), userIdentityId);
        }
    }

    private AgendaEventService getEventService() {
        if (this.agendaEventService == null) {
            this.agendaEventService = (AgendaEventService)this.container.getComponentInstanceOfType(AgendaEventService.class);
        }
        return this.agendaEventService;
    }

    private AgendaCalendarService getCalendarService() {
        if (this.agendaCalendarService == null) {
            this.agendaCalendarService = (AgendaCalendarService)this.container.getComponentInstanceOfType(AgendaCalendarService.class);
        }
        return this.agendaCalendarService;
    }
}

