/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.rhmanagement.services;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.rhmanagement.dao.BalanceHistoryDAO;
import org.exoplatform.rhmanagement.dto.BalanceHistoryDTO;
import org.exoplatform.rhmanagement.entity.BalanceHistoryEntity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BalanceHistoryService {
    private final Logger LOG = LoggerFactory.getLogger(BalanceHistoryService.class);
    private BalanceHistoryDAO balanceHistoryDAO = new BalanceHistoryDAO();
    private IdentityManager identityManager;

    public BalanceHistoryService(IdentityManager identityManager) {
        this.identityManager = identityManager;
    }

    public BalanceHistoryDTO save(BalanceHistoryDTO entity) {
        if (entity == null) {
            throw new IllegalStateException("Parameter 'entity' is null");
        }
        BalanceHistoryEntity balanceHistoryEntity = null;
        entity.setUpdateDate(System.currentTimeMillis());
        balanceHistoryEntity = (BalanceHistoryEntity)this.balanceHistoryDAO.create(this.convert(entity));
        return this.convert(balanceHistoryEntity);
    }

    public void remove(BalanceHistoryDTO entity) {
        if (entity == null) {
            throw new IllegalStateException("Parameter 'entity' = + " + entity + " or 'entity.id' is null");
        }
        this.balanceHistoryDAO.delete(this.convert(entity));
    }

    public List<BalanceHistoryDTO> getBalanceHistoryByUserId(String id, long fromDate, long toDate, int offset, int limit) {
        if (offset < 0) {
            throw new IllegalArgumentException("Method getCommentsByRequestID - Parameter 'offset' must be positive");
        }
        Profile userProfile = this.identityManager.getOrCreateIdentity("organization", id, false).getProfile();
        List<BalanceHistoryEntity> entities = this.balanceHistoryDAO.getBalanceHistoryByUserId(id, userProfile.getFullName(), fromDate, toDate, offset, limit);
        ArrayList<BalanceHistoryDTO> dtos = new ArrayList<BalanceHistoryDTO>();
        for (BalanceHistoryEntity entity : entities) {
            Profile profile;
            if (entity.getUpdaterId() != null) {
                try {
                    profile = this.identityManager.getOrCreateIdentity("organization", entity.getUpdaterId()).getProfile();
                    entity.setUpdaterId(profile.getFullName());
                }
                catch (Exception e) {
                    this.LOG.debug("cannot get profile of {}" + entity.getUpdaterId());
                }
            }
            if (entity.getUserId() != null) {
                try {
                    profile = this.identityManager.getOrCreateIdentity("organization", entity.getUserId(), false).getProfile();
                }
                catch (Exception e) {
                    this.LOG.debug("cannot get profile of" + entity.getUserId());
                }
            }
            dtos.add(this.convert(entity));
        }
        return dtos;
    }

    public List<BalanceHistoryDTO> getBalanceHistoryByDate(long fromDate, long toDate, int offset, int limit) {
        if (offset < 0) {
            throw new IllegalArgumentException("Method getCommentsByRequestID - Parameter 'offset' must be positive");
        }
        List<BalanceHistoryEntity> entities = this.balanceHistoryDAO.getBalanceHistoryByDate(fromDate, toDate, offset, limit);
        ArrayList<BalanceHistoryDTO> dtos = new ArrayList<BalanceHistoryDTO>();
        for (BalanceHistoryEntity entity : entities) {
            Profile profile;
            if (entity.getUpdaterId() != null) {
                try {
                    profile = this.identityManager.getOrCreateIdentity("organization", entity.getUpdaterId(), false).getProfile();
                    entity.setUpdaterId(profile.getFullName());
                }
                catch (Exception e) {
                    this.LOG.error("cannot get profile of" + entity.getUpdaterId());
                }
            }
            if (entity.getUserId() != null) {
                try {
                    profile = this.identityManager.getOrCreateIdentity("organization", entity.getUserId(), false).getProfile();
                    entity.setUserId(profile.getFullName());
                }
                catch (Exception e) {
                    this.LOG.error("cannot get profile of" + entity.getUserId());
                }
            }
            dtos.add(this.convert(entity));
        }
        return dtos;
    }

    public long getBalanceHistoryByUserrIdCount(String id) {
        return this.balanceHistoryDAO.getBalanceHistoryByUserIdCount(id);
    }

    private BalanceHistoryEntity convert(BalanceHistoryDTO dto) {
        BalanceHistoryEntity entity = new BalanceHistoryEntity();
        entity.setId(dto.getId());
        entity.setUserId(dto.getUserId());
        entity.setIntialHolidaysBalance(dto.getIntialHolidaysBalance());
        entity.setIntialSickBalance(dto.getIntialSickBalance());
        entity.setHolidaysBalance(dto.getHolidaysBalance());
        entity.setSickBalance(dto.getSickBalance());
        entity.setUpdateDate(dto.getUpdateDate());
        entity.setVacationType(dto.getVacationType());
        entity.setVacationId(dto.getVacationId());
        entity.setDaysNumber(dto.getDaysNumber());
        entity.setUpdateType(dto.getUpdateType());
        entity.setUpdaterId(dto.getUpdaterId());
        return entity;
    }

    private BalanceHistoryDTO convert(BalanceHistoryEntity entity) {
        BalanceHistoryDTO dto = new BalanceHistoryDTO();
        dto.setId(entity.getId());
        dto.setUserId(entity.getUserId());
        dto.setIntialHolidaysBalance(entity.getIntialHolidaysBalance());
        dto.setIntialSickBalance(entity.getIntialSickBalance());
        dto.setHolidaysBalance(entity.getHolidaysBalance());
        dto.setSickBalance(entity.getSickBalance());
        dto.setUpdateDate(entity.getUpdateDate());
        dto.setVacationType(entity.getVacationType());
        dto.setVacationId(entity.getVacationId());
        dto.setDaysNumber(entity.getDaysNumber());
        dto.setUpdateType(entity.getUpdateType());
        dto.setUpdaterId(entity.getUpdaterId());
        return dto;
    }
}

