/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.rhmanagement.services;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.rhmanagement.dao.CommentDAO;
import org.exoplatform.rhmanagement.dto.CommentDTO;
import org.exoplatform.rhmanagement.entity.CommentEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommentService {
    private final Logger LOG = LoggerFactory.getLogger(CommentService.class);
    private CommentDAO commentDAO = new CommentDAO();

    public CommentDTO save(CommentDTO entity) {
        if (entity == null) {
            throw new IllegalStateException("Parameter 'entity' is null");
        }
        CommentEntity commentEntity = null;
        if (entity == null) {
            entity.setPostedTime(System.currentTimeMillis());
            commentEntity = (CommentEntity)this.commentDAO.create(this.convert(entity));
        } else {
            commentEntity = (CommentEntity)this.commentDAO.update(this.convert(entity));
        }
        return this.convert(commentEntity);
    }

    public void remove(CommentDTO entity) {
        if (entity == null) {
            throw new IllegalStateException("Parameter 'entity' = + " + entity + " or 'entity.id' is null");
        }
        this.commentDAO.delete(this.convert(entity));
    }

    public List<CommentDTO> getCommentsByRequestId(long id, String commentType, int offset, int limit) {
        if (offset < 0) {
            throw new IllegalArgumentException("Method getCommentsByRequestID - Parameter 'offset' must be positive");
        }
        List<CommentEntity> entities = this.commentDAO.getCommentsByRequestId(id, commentType, offset, limit);
        ArrayList<CommentDTO> dtos = new ArrayList<CommentDTO>();
        for (CommentEntity entity : entities) {
            dtos.add(this.convert(entity));
        }
        return dtos;
    }

    public long getCommentsByRequestIdCount(Long id, String commentType) {
        return this.commentDAO.getCommentsByRequestIdCount(id, commentType);
    }

    private CommentEntity convert(CommentDTO dto) {
        CommentEntity entity = new CommentEntity();
        entity.setId(dto.getId());
        entity.setPosterId(dto.getPosterId());
        entity.setPostedTime(dto.getPostedTime());
        entity.setRequestId(dto.getRequestId());
        entity.setCommentText(dto.getCommentText());
        entity.setCommentType(dto.getCommentType());
        return entity;
    }

    private CommentDTO convert(CommentEntity entity) {
        CommentDTO dto = new CommentDTO();
        dto.setId(entity.getId());
        dto.setPosterId(entity.getPosterId());
        dto.setPostedTime(entity.getPostedTime());
        dto.setRequestId(entity.getRequestId());
        dto.setCommentText(entity.getCommentText());
        dto.setCommentType(entity.getCommentType());
        return dto;
    }
}

