/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.rhmanagement.dao;

import java.util.List;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.rhmanagement.entity.VacationRequestEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VacationRequestDAO
extends GenericDAOJPAImpl<VacationRequestEntity, String> {
    private static final Logger LOG = LoggerFactory.getLogger(VacationRequestDAO.class);

    public List<VacationRequestEntity> getVacationRequests(int offset, int limit) {
        try {
            if (offset >= 0 && limit > 0) {
                return this.getEntityManager().createNamedQuery("vacatioRequestEntity.findAllOrderBy", VacationRequestEntity.class).setFirstResult(offset).setMaxResults(limit).getResultList();
            }
            return this.findAll();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get requests with offset = '" + offset + "' and limit = '" + limit + "'.", (Throwable)e);
            throw e;
        }
    }

    public long getVacationRequestesCount() {
        try {
            return (Long)this.getEntityManager().createNamedQuery("vacationRequestEntity.count", Long.class).getSingleResult();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get requests count.", (Throwable)e);
            throw e;
        }
    }

    public List<VacationRequestEntity> getVacationRequestsByUserId(String userId, int offset, int limit) {
        try {
            if (offset >= 0 && limit > 0) {
                return this.getEntityManager().createNamedQuery("vacatioRequestEntity.findByUserId", VacationRequestEntity.class).setFirstResult(offset).setMaxResults(limit).setParameter("userId", (Object)userId).getResultList();
            }
            return this.getEntityManager().createNamedQuery("vacatioRequestEntity.findByUserId", VacationRequestEntity.class).setParameter("userId", (Object)userId).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get requests with offset = '" + offset + "' and limit = '" + limit + "'.", (Throwable)e);
            throw e;
        }
    }

    public List<VacationRequestEntity> getVacationRequestsByUserIdAndStatus(String userId, String status, int offset, int limit) {
        try {
            if (offset >= 0 && limit > 0) {
                return this.getEntityManager().createNamedQuery("vacatioRequestEntity.findByUserIdAndStatus", VacationRequestEntity.class).setFirstResult(offset).setMaxResults(limit).setParameter("userId", (Object)userId).setParameter("status", (Object)status).getResultList();
            }
            return this.getEntityManager().createNamedQuery("vacatioRequestEntity.findByUserIdAndStatus", VacationRequestEntity.class).setParameter("userId", (Object)userId).setParameter("status", (Object)status).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get requests with offset = '" + offset + "' and limit = '" + limit + "'.", (Throwable)e);
            throw e;
        }
    }

    public List<VacationRequestEntity> getActiveVacationRequestsByUserId(String userId, int offset, int limit) {
        try {
            if (offset >= 0 && limit > 0) {
                return this.getEntityManager().createNamedQuery("vacatioRequestEntity.findActiveByUserId", VacationRequestEntity.class).setFirstResult(offset).setMaxResults(limit).setParameter("userId", (Object)userId).getResultList();
            }
            return this.getEntityManager().createNamedQuery("vacatioRequestEntity.findActiveByUserId", VacationRequestEntity.class).setParameter("userId", (Object)userId).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get requests with offset = '" + offset + "' and limit = '" + limit + "'.", (Throwable)e);
            throw e;
        }
    }

    public List<VacationRequestEntity> getVacationRequestbyId(long id) {
        try {
            return this.getEntityManager().createNamedQuery("vacatioRequestEntity.findById", VacationRequestEntity.class).setParameter("id", (Object)id).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get request", (Throwable)e);
            throw e;
        }
    }
}

