/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.rhmanagement.services.jobs;

import java.util.List;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.rhmanagement.dto.UserRHDataDTO;
import org.exoplatform.rhmanagement.services.UserDataService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class UpdateSickBalanceJob
implements Job {
    private static final Log LOG = ExoLogger.getLogger(UpdateSickBalanceJob.class);
    private UserDataService userDataService = (UserDataService)CommonsUtils.getService(UserDataService.class);

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        LOG.info((Object)"==================Update Sick Balance Job started==================");
        Long start = System.currentTimeMillis();
        List<UserRHDataDTO> employees = this.userDataService.getAllRhData(0, 0);
        for (UserRHDataDTO employee : employees) {
            employee.setSickdaysBalance(10.0f);
            this.userDataService.save(employee);
        }
        LOG.info((Object)("=============================== Update Sick Balance Job ended in " + String.valueOf(System.currentTimeMillis() - start) + " ms ===============================."));
    }
}

