/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.rhmanagement.services.jobs;

import java.util.List;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.rhmanagement.dto.BalanceHistoryDTO;
import org.exoplatform.rhmanagement.dto.UserRHDataDTO;
import org.exoplatform.rhmanagement.services.BalanceHistoryService;
import org.exoplatform.rhmanagement.services.UserDataService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class UpdateHolidaysBalanceJob
implements Job {
    private static final Log LOG = ExoLogger.getLogger(UpdateHolidaysBalanceJob.class);
    private UserDataService userDataService = (UserDataService)CommonsUtils.getService(UserDataService.class);
    private BalanceHistoryService balanceHistoryService = (BalanceHistoryService)CommonsUtils.getService(BalanceHistoryService.class);

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        LOG.info((Object)"==================Update Holidays Balance Job started==================");
        Long start = System.currentTimeMillis();
        List<UserRHDataDTO> employees = this.userDataService.getAllRhData(0, 0);
        for (UserRHDataDTO employee : employees) {
            float holidays = employee.getHolidaysBalance();
            employee.setHolidaysBalance(holidays + 2.0f);
            this.userDataService.save(employee);
            try {
                BalanceHistoryDTO balanceHistoryDTO = new BalanceHistoryDTO();
                balanceHistoryDTO.setUserId(employee.getUserId());
                balanceHistoryDTO.setIntialHolidaysBalance(holidays);
                balanceHistoryDTO.setIntialSickBalance(employee.getSickdaysBalance());
                balanceHistoryDTO.setHolidaysBalance(employee.getHolidaysBalance());
                balanceHistoryDTO.setSickBalance(employee.getSickdaysBalance());
                balanceHistoryDTO.setVacationType("holiday");
                balanceHistoryDTO.setDaysNumber(2.0f);
                balanceHistoryDTO.setUpdateType("monthlyHolidayUpdate");
                balanceHistoryDTO.setUpdaterId("System");
                this.balanceHistoryService.save(balanceHistoryDTO);
            }
            catch (Exception e) {
                LOG.error((Object)"Error when adding history entry", (Throwable)e);
            }
        }
        LOG.info((Object)("=============================== Update Holidays Balance Job ended in " + String.valueOf(System.currentTimeMillis() - start) + " ms ===============================."));
    }
}

