/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.rhmanagement.dao;

import java.util.List;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.rhmanagement.entity.OfficialVacationEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfficialVacationDAO
extends GenericDAOJPAImpl<OfficialVacationEntity, String> {
    private static final Logger LOG = LoggerFactory.getLogger(OfficialVacationDAO.class);

    public List<OfficialVacationEntity> getOfficialVacations(int offset, int limit) {
        try {
            if (offset >= 0 && limit > 0) {
                return this.getEntityManager().createNamedQuery("officialVacationEntity.findAll", OfficialVacationEntity.class).setFirstResult(offset).setMaxResults(limit).getResultList();
            }
            return this.getEntityManager().createNamedQuery("officialVacationEntity.findAll", OfficialVacationEntity.class).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get Official vacations with offset = '" + offset + "' and limit = '" + limit + "'.", (Throwable)e);
            throw e;
        }
    }

    public long getOfficialVacationsCount() {
        try {
            return (Long)this.getEntityManager().createNamedQuery("officialVacationEntity.count", Long.class).getSingleResult();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get Official vacations count.", (Throwable)e);
            throw e;
        }
    }

    public OfficialVacationEntity getOfficialVacationById(long id) {
        try {
            return (OfficialVacationEntity)this.getEntityManager().createNamedQuery("officialVacationEntity.findOfficialVacationbyId", OfficialVacationEntity.class).setParameter("id", (Object)id).getSingleResult();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get Official vacation ", (Throwable)e);
            throw e;
        }
    }
}

