/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.rhmanagement.services;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.rhmanagement.dao.ValidatorDAO;
import org.exoplatform.rhmanagement.dto.ValidatorDTO;
import org.exoplatform.rhmanagement.entity.ValidatorEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidatorService {
    private final Logger LOG = LoggerFactory.getLogger(ValidatorService.class);
    private ValidatorDAO validatorDAO = new ValidatorDAO();

    public ValidatorDTO save(ValidatorDTO entity) {
        if (entity == null) {
            throw new IllegalStateException("Parameter 'entity' is null");
        }
        ValidatorEntity commentEntity = null;
        commentEntity = entity == null ? (ValidatorEntity)this.validatorDAO.create(this.convert(entity)) : (ValidatorEntity)this.validatorDAO.update(this.convert(entity));
        return this.convert(commentEntity);
    }

    public void remove(ValidatorDTO entity) {
        if (entity == null) {
            throw new IllegalStateException("Parameter 'entity' = + " + entity + " or 'entity.id' is null");
        }
        this.validatorDAO.delete(this.convert(entity));
    }

    public List<ValidatorDTO> getValidatorsByRequestId(long id, int offset, int limit) {
        if (offset < 0) {
            throw new IllegalArgumentException("Method getCommentsByRequestID - Parameter 'offset' must be positive");
        }
        List<ValidatorEntity> entities = this.validatorDAO.getValidatorsByRequestId(id, offset, limit);
        ArrayList<ValidatorDTO> dtos = new ArrayList<ValidatorDTO>();
        for (ValidatorEntity entity : entities) {
            dtos.add(this.convert(entity));
        }
        return dtos;
    }

    public long getValidatorsByRequestIdCount(Long id) {
        return this.validatorDAO.getValidatorsByRequestIdCount(id);
    }

    public List<ValidatorDTO> getValidatorsByValidatorUserId(String userId, int offset, int limit) {
        if (offset < 0) {
            throw new IllegalArgumentException("Method getCommentsByRequestID - Parameter 'offset' must be positive");
        }
        List<ValidatorEntity> entities = this.validatorDAO.getValidatorsByValidatorUserId(userId, offset, limit);
        ArrayList<ValidatorDTO> dtos = new ArrayList<ValidatorDTO>();
        for (ValidatorEntity entity : entities) {
            dtos.add(this.convert(entity));
        }
        return dtos;
    }

    public List<ValidatorDTO> getValidatorsByValidatorUserIdandRequestId(String userId, long requestId) {
        List<ValidatorEntity> entities = this.validatorDAO.getValidatorsByValidatorUserIdandRequestId(userId, requestId);
        ArrayList<ValidatorDTO> dtos = new ArrayList<ValidatorDTO>();
        for (ValidatorEntity entity : entities) {
            dtos.add(this.convert(entity));
        }
        return dtos;
    }

    private ValidatorEntity convert(ValidatorDTO dto) {
        ValidatorEntity entity = new ValidatorEntity();
        entity.setId(dto.getId());
        entity.setUserId(dto.getUserId());
        entity.setValidatorUserId(dto.getValidatorUserId());
        entity.setRequestId(dto.getRequestId());
        entity.setValidatorMail(dto.getValidatorMail());
        entity.setReply(dto.getReply());
        return entity;
    }

    private ValidatorDTO convert(ValidatorEntity entity) {
        ValidatorDTO dto = new ValidatorDTO();
        dto.setId(entity.getId());
        dto.setUserId(entity.getUserId());
        dto.setValidatorUserId(entity.getValidatorUserId());
        dto.setRequestId(entity.getRequestId());
        dto.setValidatorMail(entity.getValidatorMail());
        dto.setReply(entity.getReply());
        return dto;
    }
}

