/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.rhmanagement.integration.notification;

import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.NotificationMessageUtils;
import org.exoplatform.commons.api.notification.annotation.TemplateConfig;
import org.exoplatform.commons.api.notification.annotation.TemplateConfigs;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.HTMLEntityEncoder;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.rhmanagement.integration.notification.MailTemplateProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.notification.LinkProviderUtils;
import org.exoplatform.webui.utils.TimeConvertUtils;

@TemplateConfigs(templates={@TemplateConfig(pluginId="RequestRepliedPlugin", template="war:/notification/rh-requests/templates/web/RequestReplyPlugin.gtmpl"), @TemplateConfig(pluginId="RequestStatusChangedPlugin", template="war:/notification/rh-requests/templates/web/UpdateRequestPlugin.gtmpl"), @TemplateConfig(pluginId="RequestCreatedPlugin", template="war:/notification/rh-requests/templates/web/CreateRequestPlugin.gtmpl"), @TemplateConfig(pluginId="HRBirthdayNotificationPlugin", template="war:/notification/rh-requests/templates/web/HRBirthdayNotificationPlugin.gtmpl"), @TemplateConfig(pluginId="HRContractAnniversaryNotificationPlugin", template="war:/notification/rh-requests/templates/web/HRContractAnniversaryNotificationPlugin.gtmpl"), @TemplateConfig(pluginId="RequestCommentedPlugin", template="war:/notification/rh-requests/templates/web/RequestCommentedPlugin.gtmpl"), @TemplateConfig(pluginId="VacationBalanceNotificationPlugin", template="war:/notification/rh-requests/templates/web/VacationBalanceNotificationPlugin.gtmpl")})
public class WebTemplateProvider
extends TemplateProvider {
    protected DateFormat formatter = new SimpleDateFormat("E MMM dd HH:mm:ss Z yyyy");
    protected static Log log = ExoLogger.getLogger(MailTemplateProvider.class);

    public WebTemplateProvider(InitParams initParams) {
        super(initParams);
        this.templateBuilders.put(PluginKey.key((String)"RequestRepliedPlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"RequestStatusChangedPlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"RequestCreatedPlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"HRBirthdayNotificationPlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"HRContractAnniversaryNotificationPlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"RequestCommentedPlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"VacationBalanceNotificationPlugin"), new TemplateBuilder());
    }

    private class TemplateBuilder
    extends AbstractTemplateBuilder {
        private TemplateBuilder() {
        }

        protected MessageInfo makeMessage(NotificationContext ctx) {
            String daysToConsume;
            NotificationInfo notification = ctx.getNotificationInfo();
            String pluginId = notification.getKey().getId();
            String language = this.getLanguage(notification);
            TemplateContext templateContext = TemplateContext.newChannelInstance((ChannelKey)WebTemplateProvider.this.getChannelKey(), (String)pluginId, (String)language);
            String creator = notification.getValueOwnerParameter("creator");
            String vacationUrl = notification.getValueOwnerParameter("vacationUrl");
            String userName = notification.getValueOwnerParameter("userName");
            HTMLEntityEncoder encoder = HTMLEntityEncoder.getInstance();
            IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
            Identity identity = identityManager.getOrCreateIdentity("organization", creator, true);
            Profile profile = identity.getProfile();
            templateContext.put((Object)"USER", (Object)encoder.encode(profile.getFullName().toString()));
            templateContext.put((Object)"AVATAR", (Object)(profile.getAvatarUrl() != null ? profile.getAvatarUrl() : "/platform-ui/skin/images/avatar/DefaultUserAvatar.png"));
            templateContext.put((Object)"PROFILE_URL", (Object)LinkProviderUtils.getRedirectUrl((String)"user", (String)identity.getRemoteId()));
            if (vacationUrl != null) {
                templateContext.put((Object)"VACATION_URL", (Object)vacationUrl);
            }
            if (userName != null) {
                Identity id = identityManager.getOrCreateIdentity("organization", userName, false);
                templateContext.put((Object)"USER_NAME", (Object)id.getProfile().getFullName());
            }
            if ((daysToConsume = notification.getValueOwnerParameter("daysToConsume")) != null) {
                templateContext.put((Object)"DAYS_TO_CONSUME", (Object)daysToConsume);
            }
            templateContext.put((Object)"READ", (Object)(Boolean.valueOf(notification.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey())) != false ? "read" : "unread"));
            templateContext.put((Object)"NOTIFICATION_ID", (Object)notification.getId());
            Calendar lastModified = Calendar.getInstance();
            lastModified.setTimeInMillis(notification.getLastModifiedDate());
            templateContext.put((Object)"LAST_UPDATED_TIME", (Object)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)lastModified.getTime(), (String)"EE, dd yyyy", (Locale)new Locale(language), (int)TimeConvertUtils.YEAR));
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            ctx.setException(templateContext.getException());
            MessageInfo messageInfo = new MessageInfo();
            return messageInfo.body(body).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            return false;
        }
    }
}

