/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.rhmanagement.portlet.rhAdministration;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.inject.Inject;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import juzu.HttpMethod;
import juzu.MimeType;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.View;
import juzu.impl.common.JSON;
import juzu.plugin.jackson.Jackson;
import juzu.template.Template;
import org.apache.commons.fileupload.FileItem;
import org.exoplatform.commons.juzu.ajax.Ajax;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.rhmanagement.dto.CommentDTO;
import org.exoplatform.rhmanagement.dto.EmployeesDTO;
import org.exoplatform.rhmanagement.dto.UserRHDataDTO;
import org.exoplatform.rhmanagement.dto.VacationRequestDTO;
import org.exoplatform.rhmanagement.dto.ValidatorDTO;
import org.exoplatform.rhmanagement.services.CommentService;
import org.exoplatform.rhmanagement.services.UserDataService;
import org.exoplatform.rhmanagement.services.Utils;
import org.exoplatform.rhmanagement.services.VacationRequestService;
import org.exoplatform.rhmanagement.services.ValidatorService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;

public class RhAdministrationController {
    private static Log LOG = ExoLogger.getLogger(RhAdministrationController.class);
    private String bundleString;
    ResourceBundle bundle;
    private final String APPROVED = "approved";
    private final String VALIDATED = "validated";
    private final String CANCELED = "canceled";
    @Inject
    UserDataService userDataService;
    @Inject
    CommentService commentService;
    @Inject
    ValidatorService validatorService;
    @Inject
    VacationRequestService vacationRequestService;
    @Inject
    IdentityManager identityManager;
    @Inject
    OrganizationService orgService;
    @Inject
    RepositoryService repositoryService;
    @Inject
    ListenerService listenerService;
    @Inject
    @Path(value="index.gtmpl")
    Template indexTmpl;
    private final String currentUser = ConversationState.getCurrent().getIdentity().getUserId();

    @View
    public Response.Content index() {
        return this.indexTmpl.ok();
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public List<EmployeesDTO> getAllUsersRhData() {
        try {
            return this.userDataService.getAllUsersRhData(0, 100);
        }
        catch (Throwable e) {
            LOG.error((Object)e);
            return null;
        }
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public UserRHDataDTO saveUserRHData(@Jackson EmployeesDTO user) throws Exception {
        try {
            return this.userDataService.save(user.getHrData());
        }
        catch (Exception e) {
            LOG.error((Object)"Error when updating userData", (Throwable)e);
            throw e;
        }
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public Response deleteUserRHData(@Jackson EmployeesDTO user) throws Exception {
        try {
            this.userDataService.remove(user.getHrData());
            Utils.deleteFile((String)("Application Data/hrmanagement/employees/emp_" + user.getUserId()));
            return Response.ok();
        }
        catch (Exception e) {
            LOG.error((Object)"Error when updating userData", (Throwable)e);
            return Response.error((String)"");
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public List<VacationRequestDTO> getVacationRequestsbyUserId(String userId) {
        try {
            return this.vacationRequestService.getVacationRequestsByUserId(userId, 0, 100);
        }
        catch (Throwable e) {
            LOG.error((Object)e);
            return null;
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public EmployeesDTO getUser(String userId) {
        try {
            UserHandler uh = this.orgService.getUserHandler();
            if (uh.findUserByName(userId) == null) {
                return null;
            }
            Profile profile = this.identityManager.getOrCreateIdentity("organization", userId, false).getProfile();
            EmployeesDTO employee = new EmployeesDTO();
            employee.setName(profile.getFullName());
            employee.setUserId(userId);
            employee.setEmail(profile.getEmail());
            employee.setGender(profile.getGender());
            employee.setJobTitle(profile.getPosition());
            employee.setAvatar(profile.getAvatarUrl());
            UserRHDataDTO userRHDataDTO = this.userDataService.getUserRHDataByUserId(userId);
            if (userRHDataDTO == null) {
                userRHDataDTO = new UserRHDataDTO();
                userRHDataDTO.setUserId(userId);
            }
            employee.setHrData(userRHDataDTO);
            return employee;
        }
        catch (Throwable e) {
            LOG.error((Object)e);
            return null;
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public List<VacationRequestDTO> getAllVacationRequests() {
        try {
            return this.vacationRequestService.getVacationRequests(0, 100);
        }
        catch (Throwable e) {
            LOG.error((Object)e);
            return null;
        }
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public UserRHDataDTO validateRequest(@Jackson VacationRequestDTO obj) {
        UserRHDataDTO userRHDataDTO = null;
        if (!obj.getStatus().equals("validated")) {
            float nbDays;
            obj.setStatus("validated");
            obj = this.vacationRequestService.save(obj, false);
            userRHDataDTO = this.userDataService.getUserRHDataByUserId(obj.getUserId());
            if (obj.getType().equals("holiday")) {
                float holidays = userRHDataDTO.getHolidaysBalance();
                nbDays = obj.getDaysNumber();
                userRHDataDTO.setHolidaysBalance(holidays - nbDays);
                this.userDataService.save(userRHDataDTO);
            }
            if (obj.getType().equals("sick")) {
                float sickdays = userRHDataDTO.getSickdaysBalance();
                nbDays = obj.getDaysNumber();
                userRHDataDTO.setSickdaysBalance(sickdays - nbDays);
                this.userDataService.save(userRHDataDTO);
            }
            CommentDTO comment = new CommentDTO();
            comment.setRequestId(obj.getId());
            comment.setCommentText("requestValidated");
            comment.setPosterId(this.currentUser);
            comment.setCommentType("history");
            this.commentService.save(comment);
            try {
                this.listenerService.broadcast("exo.hrmanagement.requestUpadate", (Object)this.currentUser, (Object)obj);
            }
            catch (Exception e) {
                LOG.error((Object)"Cannot broadcast update request event");
            }
        }
        return userRHDataDTO;
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public UserRHDataDTO cancelRequest(@Jackson VacationRequestDTO obj) {
        UserRHDataDTO userRHDataDTO = null;
        if (!obj.getStatus().equals("canceled")) {
            if (obj.getStatus().equals("validated")) {
                userRHDataDTO = this.userDataService.getUserRHDataByUserId(obj.getUserId());
                if (obj.getType().equals("holiday")) {
                    float holidays = userRHDataDTO.getHolidaysBalance();
                    float nbDays = obj.getDaysNumber();
                    userRHDataDTO.setHolidaysBalance(holidays + nbDays);
                    this.userDataService.save(userRHDataDTO);
                }
                if (obj.getType().equals("sick")) {
                    userRHDataDTO.setSickdaysBalance(userRHDataDTO.getSickdaysBalance() + obj.getDaysNumber());
                    this.userDataService.save(userRHDataDTO);
                }
            }
            obj.setStatus("canceled");
            obj = this.vacationRequestService.save(obj, false);
            CommentDTO comment = new CommentDTO();
            comment.setRequestId(obj.getId());
            comment.setCommentText("requestCanceled");
            comment.setPosterId(this.currentUser);
            comment.setCommentType("history");
            this.commentService.save(comment);
            try {
                this.listenerService.broadcast("exo.hrmanagement.requestUpadate", (Object)this.currentUser, (Object)obj);
            }
            catch (Exception e) {
                LOG.error((Object)"Cannot broadcast update request event");
            }
        }
        return userRHDataDTO;
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getBundle() {
        try {
            if (!PropertyManager.isDevelopping() && this.bundleString != null && this.getResourceBundle().getLocale().equals(PortalRequestContext.getCurrentInstance().getLocale())) {
                return Response.ok((CharSequence)this.bundleString);
            }
            this.bundle = this.getResourceBundle(PortalRequestContext.getCurrentInstance().getLocale());
            JSON data = new JSON();
            Enumeration<String> enumeration = this.getResourceBundle().getKeys();
            while (enumeration.hasMoreElements()) {
                String key = enumeration.nextElement();
                try {
                    data.set(key.replaceAll("(.*)\\.", ""), this.getResourceBundle().getObject(key));
                }
                catch (MissingResourceException missingResourceException) {}
            }
            this.bundleString = data.toString();
            return Response.ok((CharSequence)this.bundleString);
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting categories", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getContext() {
        try {
            JSON data = new JSON();
            data.set("currentUser", (Object)this.currentUser);
            Profile profile = this.identityManager.getOrCreateIdentity("organization", this.currentUser, false).getProfile();
            if (profile.getAvatarUrl() != null) {
                data.set("currentUserAvatar", (Object)profile.getAvatarUrl());
            } else {
                data.set("currentUserAvatar", (Object)"/eXoSkin/skin/images/system/UserAvtDefault.png");
            }
            data.set("currentUserName", (Object)profile.getFullName());
            return Response.ok((CharSequence)data.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    private ResourceBundle getResourceBundle(Locale locale) {
        this.bundle = ResourceBundle.getBundle("locale.portlet.rh-management", locale, this.getClass().getClassLoader());
        return this.bundle;
    }

    private ResourceBundle getResourceBundle() {
        if (this.bundle == null) {
            this.bundle = this.getResourceBundle(PortalRequestContext.getCurrentInstance().getLocale());
        }
        return this.bundle;
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response uploadFile(String userId, FileItem file) throws IOException {
        if (file != null) {
            Utils.saveFile((FileItem)file, (String)"employees", (String)("emp_" + userId));
            return Response.ok();
        }
        return Response.notFound();
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response deleteFile(String userId, String fileName) throws IOException {
        Utils.deleteFile((String)("Application Data/hrmanagement/employees/emp_" + userId + "/" + fileName));
        return Response.ok();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public Response getEmployeeAttachements(@Jackson EmployeesDTO obj) {
        ArrayList<JSON> atts = new ArrayList<JSON>();
        try (SessionProvider sessionProvider = SessionProvider.createSystemProvider();){
            Session session = sessionProvider.getSession("collaboration", this.repositoryService.getCurrentRepository());
            Node rootNode = session.getRootNode();
            String userId = obj.getUserId();
            if (rootNode.hasNode("Application Data/hrmanagement/employees/emp_" + userId)) {
                Node requestsFolder = rootNode.getNode("Application Data/hrmanagement/employees/emp_" + userId);
                NodeIterator iter = requestsFolder.getNodes();
                while (iter.hasNext()) {
                    Node node = (Node)iter.next();
                    JSON attachment = new JSON();
                    attachment.set("name", (Object)node.getName());
                    attachment.set("url", (Object)("/rest/jcr/repository/collaboration/Application Data/hrmanagement/employees/emp_" + userId + "/" + node.getName()));
                    atts.add(attachment);
                }
                Response.Content content = Response.ok((CharSequence)((Object)atts).toString());
                return content;
            }
            Response.Status status = Response.ok();
            return status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public Response getRequestAttachements(@Jackson VacationRequestDTO obj) {
        ArrayList<JSON> atts = new ArrayList<JSON>();
        try (SessionProvider sessionProvider = SessionProvider.createSystemProvider();){
            Session session = sessionProvider.getSession("collaboration", this.repositoryService.getCurrentRepository());
            Node rootNode = session.getRootNode();
            long requestId = obj.getId();
            if (rootNode.hasNode("Application Data/hrmanagement/requests/req_" + requestId)) {
                Node requestsFolder = rootNode.getNode("Application Data/hrmanagement/requests/req_" + requestId);
                NodeIterator iter = requestsFolder.getNodes();
                while (iter.hasNext()) {
                    Node node = (Node)iter.next();
                    JSON attachment = new JSON();
                    attachment.set("name", (Object)node.getName());
                    attachment.set("url", (Object)("/rest/jcr/repository/collaboration/Application Data/hrmanagement/requests/req_" + requestId + "/" + node.getName()));
                    atts.add(attachment);
                }
                Response.Content content = Response.ok((CharSequence)((Object)atts).toString());
                return content;
            }
            Response.Status status = Response.ok();
            return status;
        }
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public void saveComment(@Jackson CommentDTO obj) {
        obj.setPosterId(this.currentUser);
        obj.setCommentType("comment");
        this.commentService.save(obj);
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public List<CommentDTO> getComments(@Jackson VacationRequestDTO obj) {
        try {
            List comments = this.commentService.getCommentsByRequestId(obj.getId(), "comment", 0, 100);
            for (CommentDTO comment : comments) {
                Profile profile = this.identityManager.getOrCreateIdentity("organization", comment.getPosterId(), false).getProfile();
                comment.setPosterName(profile.getFullName());
                if (profile.getAvatarUrl() != null) {
                    comment.setPosterAvatar(profile.getAvatarUrl());
                    continue;
                }
                comment.setPosterAvatar("/eXoSkin/skin/images/system/UserAvtDefault.png");
            }
            return comments;
        }
        catch (Throwable e) {
            LOG.error((Object)e);
            return null;
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public List<CommentDTO> getHistory(@Jackson VacationRequestDTO obj) {
        try {
            List comments = this.commentService.getCommentsByRequestId(obj.getId(), "history", 0, 100);
            for (CommentDTO comment : comments) {
                Profile profile = this.identityManager.getOrCreateIdentity("organization", comment.getPosterId(), false).getProfile();
                comment.setPosterName(profile.getFullName());
                if (profile.getAvatarUrl() != null) {
                    comment.setPosterAvatar(profile.getAvatarUrl());
                    continue;
                }
                comment.setPosterAvatar("/eXoSkin/skin/images/system/UserAvtDefault.png");
            }
            return comments;
        }
        catch (Throwable e) {
            LOG.error((Object)e);
            return null;
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public List<ValidatorDTO> getValidatorsByRequestID(@Jackson VacationRequestDTO obj) {
        ArrayList<ValidatorDTO> validators = new ArrayList<ValidatorDTO>();
        try {
            for (ValidatorDTO validator : this.validatorService.getValidatorsByRequestId(obj.getId(), 0, 0)) {
                validator.setValidatorName(this.identityManager.getOrCreateIdentity("organization", validator.getValidatorUserId(), false).getProfile().getFullName());
                validators.add(validator);
            }
            return validators;
        }
        catch (Throwable e) {
            LOG.error((Object)e);
            return null;
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public List<EmployeesDTO> getSubstitutesByRequestID(@Jackson VacationRequestDTO obj) {
        try {
            ArrayList<EmployeesDTO> userDTOs = new ArrayList<EmployeesDTO>();
            for (String userId : obj.getSubstitute().split(",")) {
                Identity id = this.identityManager.getOrCreateIdentity("organization", userId, false);
                if (id == null) continue;
                EmployeesDTO employeesDTO = new EmployeesDTO();
                employeesDTO.setUserId(userId);
                employeesDTO.setName(id.getProfile().getFullName());
                userDTOs.add(employeesDTO);
            }
            return userDTOs;
        }
        catch (Throwable e) {
            LOG.error((Object)e);
            return null;
        }
    }
}

