/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.rhmanagement.portlet.rhManagement;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.inject.Inject;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import juzu.HttpMethod;
import juzu.MimeType;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.SessionScoped;
import juzu.View;
import juzu.impl.common.JSON;
import juzu.plugin.jackson.Jackson;
import juzu.template.Template;
import org.apache.commons.fileupload.FileItem;
import org.exoplatform.calendar.model.Event;
import org.exoplatform.calendar.model.query.CalendarQuery;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.ExtendedCalendarService;
import org.exoplatform.commons.juzu.ajax.Ajax;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.rhmanagement.dto.CommentDTO;
import org.exoplatform.rhmanagement.dto.ContextDTO;
import org.exoplatform.rhmanagement.dto.EmployeesDTO;
import org.exoplatform.rhmanagement.dto.UserRHDataDTO;
import org.exoplatform.rhmanagement.dto.VacationRequestDTO;
import org.exoplatform.rhmanagement.dto.VacationRequestWithManagersDTO;
import org.exoplatform.rhmanagement.dto.ValidatorDTO;
import org.exoplatform.rhmanagement.services.CommentService;
import org.exoplatform.rhmanagement.services.ConventionalVacationService;
import org.exoplatform.rhmanagement.services.OfficialVacationService;
import org.exoplatform.rhmanagement.services.UserDataService;
import org.exoplatform.rhmanagement.services.Utils;
import org.exoplatform.rhmanagement.services.VacationRequestService;
import org.exoplatform.rhmanagement.services.ValidatorService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.json.JSONArray;
import org.json.JSONObject;

@SessionScoped
public class RHRequestManagementController {
    private static Log log = ExoLogger.getLogger(RHRequestManagementController.class);
    ResourceBundle bundle;
    @Inject
    VacationRequestService vacationRequestService;
    @Inject
    ValidatorService validatorService;
    @Inject
    CommentService commentService;
    @Inject
    IdentityManager identityManager;
    @Inject
    ActivityManager activityManager;
    @Inject
    SpaceService spaceService;
    @Inject
    UserDataService userDataService;
    @Inject
    ExtendedCalendarService xCalendarService;
    @Inject
    CalendarService calendarService;
    @Inject
    RepositoryService repositoryService;
    @Inject
    ListenerService listenerService;
    @Inject
    ConventionalVacationService conventionalVacationService;
    @Inject
    OfficialVacationService officialVacationService;
    @Inject
    @Path(value="index.gtmpl")
    Template indexTmpl;
    private String bundleString;
    private final String currentUser = ConversationState.getCurrent().getIdentity().getUserId();

    @View
    public Response.Content index() {
        return this.indexTmpl.ok();
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public List<VacationRequestDTO> getVacationRequests() {
        try {
            return this.vacationRequestService.getVacationRequests(0, 100);
        }
        catch (Throwable e) {
            log.error((Object)e);
            return null;
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getUserCalendars() {
        JSONArray cals = new JSONArray();
        try {
            CalendarQuery query = new CalendarQuery();
            query.setIdentity(ConversationState.getCurrent().getIdentity());
            List lCal = this.xCalendarService.getCalendarHandler().findCalendars(query);
            lCal.sort((cal1, cal2) -> cal1.getName().compareTo(cal2.getName()));
            for (org.exoplatform.calendar.model.Calendar cal : lCal) {
                JSONObject data = new JSONObject();
                data.put("calId", (Object)cal.getId());
                data.put("calName", (Object)cal.getName());
                cals.put((Object)data);
            }
            return Response.ok((CharSequence)cals.toString());
        }
        catch (Throwable e) {
            log.error((Object)"error while getting cals", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public List<VacationRequestDTO> getVacationRequestsOfCurrentUser(String status) {
        try {
            if (status != null) {
                if (status.equals("all")) {
                    return this.vacationRequestService.getVacationRequestsByUserId(this.currentUser, 0, 100);
                }
                return this.vacationRequestService.getVacationRequestsByUserIdAndStatus(this.currentUser, status, 0, 100);
            }
            return this.vacationRequestService.getActiveVacationRequestsByUserId(this.currentUser, 0, 100);
        }
        catch (Throwable e) {
            log.error((Object)e);
            return null;
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public List<VacationRequestDTO> getVacationRequestsForCurrentValidator(String status) {
        try {
            if (status != null) {
                if (status.equals("all")) {
                    return this.vacationRequestService.getVacationRequestsByValidator(this.currentUser, 0, 100);
                }
                return this.vacationRequestService.getVacationRequestsByValidatorAndStatus(this.currentUser, status, 0, 100);
            }
            return this.vacationRequestService.getActiveVacationRequestsByValidator(this.currentUser, 0, 100);
        }
        catch (Throwable e) {
            log.error((Object)e);
            return null;
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public VacationRequestDTO getVacationRequest(Long id) {
        try {
            VacationRequestDTO vr = this.vacationRequestService.getVacationRequest(id.longValue());
            if (Utils.canView((VacationRequestDTO)vr, (String)this.currentUser).booleanValue()) {
                return vr;
            }
            return null;
        }
        catch (Throwable e) {
            log.error((Object)e);
            return null;
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public List<CommentDTO> getComments(@Jackson VacationRequestDTO obj) {
        try {
            List comments = this.commentService.getCommentsByRequestId(obj.getId(), "comment", 0, 100);
            for (CommentDTO comment : comments) {
                Profile profile = this.identityManager.getOrCreateIdentity("organization", comment.getPosterId(), false).getProfile();
                comment.setPosterName(profile.getFullName());
                if (profile.getAvatarUrl() != null) {
                    comment.setPosterAvatar(profile.getAvatarUrl());
                    continue;
                }
                comment.setPosterAvatar("/eXoSkin/skin/images/system/UserAvtDefault.png");
            }
            return comments;
        }
        catch (Throwable e) {
            log.error((Object)e);
            return null;
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public EmployeesDTO getVrOwnerData(@Jackson VacationRequestDTO obj) {
        try {
            Identity id = this.identityManager.getOrCreateIdentity("organization", obj.getUserId(), false);
            Profile profile = id.getProfile();
            EmployeesDTO employeesDTO = new EmployeesDTO();
            employeesDTO.setId(obj.getId());
            employeesDTO.setUserId(obj.getUserId());
            employeesDTO.setName(profile.getFullName());
            employeesDTO.setEmail(profile.getEmail());
            employeesDTO.setJobTitle(profile.getPosition());
            employeesDTO.setGender(profile.getGender());
            if (profile.getAvatarUrl() != null) {
                employeesDTO.setAvatar(profile.getAvatarUrl());
            } else {
                employeesDTO.setAvatar("/eXoSkin/skin/images/system/UserAvtDefault.png");
            }
            employeesDTO.setHrData(this.userDataService.getUserRHDataByUserId(obj.getUserId()));
            return employeesDTO;
        }
        catch (Throwable e) {
            log.error((Object)e);
            return null;
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public List<CommentDTO> getHistory(@Jackson VacationRequestDTO obj) {
        try {
            List comments = this.commentService.getCommentsByRequestId(obj.getId(), "history", 0, 100);
            for (CommentDTO comment : comments) {
                Profile profile = this.identityManager.getOrCreateIdentity("organization", comment.getPosterId(), false).getProfile();
                comment.setPosterName(profile.getFullName());
                if (profile.getAvatarUrl() != null) {
                    comment.setPosterAvatar(profile.getAvatarUrl());
                    continue;
                }
                comment.setPosterAvatar("/eXoSkin/skin/images/system/UserAvtDefault.png");
            }
            return comments;
        }
        catch (Throwable e) {
            log.error((Object)e);
            return null;
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public List<ValidatorDTO> getValidatorsByRequestID(@Jackson VacationRequestDTO obj) {
        ArrayList<ValidatorDTO> validators = new ArrayList<ValidatorDTO>();
        try {
            for (ValidatorDTO validator : this.validatorService.getValidatorsByRequestId(obj.getId(), 0, 0)) {
                validator.setValidatorName(this.identityManager.getOrCreateIdentity("organization", validator.getValidatorUserId(), false).getProfile().getFullName());
                validators.add(validator);
            }
            return validators;
        }
        catch (Throwable e) {
            log.error((Object)e);
            return null;
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public List<EmployeesDTO> getSubstitutesByRequestID(@Jackson VacationRequestDTO obj) {
        try {
            ArrayList<EmployeesDTO> userDTOs = new ArrayList<EmployeesDTO>();
            for (String userId : obj.getSubstitute().split(",")) {
                Identity id = this.identityManager.getOrCreateIdentity("organization", userId, false);
                EmployeesDTO employeesDTO = new EmployeesDTO();
                if (id == null) continue;
                employeesDTO.setUserId(userId);
                employeesDTO.setName(id.getProfile().getFullName());
                userDTOs.add(employeesDTO);
            }
            return userDTOs;
        }
        catch (Throwable e) {
            log.error((Object)e);
            return null;
        }
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public List<VacationRequestDTO> saveVacationRequest(@Jackson VacationRequestWithManagersDTO obj) {
        VacationRequestDTO vr = obj.getVacationRequestDTO();
        vr.setUserId(this.currentUser);
        vr.setUserFullName(this.identityManager.getOrCreateIdentity("organization", this.currentUser, false).getProfile().getFullName());
        vr.setStatus("pending");
        String substitutes = "";
        for (String substitute : obj.getSubstitutes()) {
            substitutes = substitutes.concat(substitute + ",");
        }
        vr.setSubstitute(substitutes);
        if (vr.getType() == null) {
            vr.setType("holiday");
        }
        if ("leave".equals(vr.getType())) {
            vr.setToDate(vr.getFromDate());
        }
        if ("conventional".equals(vr.getType())) {
            if (obj.getcVacation().getWorkingDays() == null || obj.getcVacation().getWorkingDays().booleanValue()) {
                vr.setToDate(Utils.getTodate((Date)vr.getFromDate(), (int)((int)vr.getDaysNumber())));
            } else {
                java.util.Calendar date = java.util.Calendar.getInstance();
                date.setTime(vr.getFromDate());
                date.add(5, (int)vr.getDaysNumber());
                vr.setToDate(date.getTime());
            }
            vr.setReason(obj.getcVacation().getLabel());
        }
        vr = this.vacationRequestService.save(vr, true);
        obj.setVacationRequestDTO(vr);
        for (String manager : obj.getManagers()) {
            ValidatorDTO val_ = new ValidatorDTO();
            val_.setRequestId(vr.getId());
            val_.setValidatorUserId(manager);
            val_.setUserId(this.currentUser);
            val_.setReply("pending");
            this.validatorService.save(val_);
        }
        if (obj.getEXoCalendarId() != "") {
            this.shareCalendar_(vr, obj.getEXoCalendarId());
        }
        CommentDTO comment = new CommentDTO();
        comment.setRequestId(vr.getId());
        comment.setCommentText("requestCreated");
        comment.setPosterId(this.currentUser);
        comment.setCommentType("history");
        this.commentService.save(comment);
        try {
            this.listenerService.broadcast("exo.hrmanagement.requestCreation", (Object)"", (Object)obj);
        }
        catch (Exception e) {
            log.error((Object)"Cannot broadcast request creation event");
        }
        return this.getVacationRequestsOfCurrentUser(null);
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public void saveComment(@Jackson CommentDTO obj) {
        obj.setPosterId(this.currentUser);
        obj.setCommentType("comment");
        this.commentService.save(obj);
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public void saveValiadator(@Jackson ValidatorDTO obj) {
        this.validatorService.save(obj);
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public void shareCalendar(@Jackson VacationRequestWithManagersDTO obj) {
        this.shareCalendar_(obj.getVacationRequestDTO(), obj.getEXoCalendarId());
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public List<VacationRequestDTO> deleteRequest(@Jackson VacationRequestDTO obj) {
        for (ValidatorDTO validator : this.validatorService.getValidatorsByRequestId(obj.getId(), 0, 0)) {
            this.validatorService.remove(validator);
        }
        for (CommentDTO comment : this.commentService.getCommentsByRequestId(obj.getId(), "comment", 0, 0)) {
            this.commentService.remove(comment);
        }
        for (CommentDTO comment : this.commentService.getCommentsByRequestId(obj.getId(), "history", 0, 0)) {
            this.commentService.remove(comment);
        }
        this.vacationRequestService.remove(obj);
        return this.getVacationRequestsOfCurrentUser(null);
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public VacationRequestDTO declineRequest(@Jackson VacationRequestDTO obj) {
        for (ValidatorDTO validator : this.validatorService.getValidatorsByValidatorUserIdandRequestId(this.currentUser, obj.getId())) {
            validator.setReply("declined");
            this.validatorService.save(validator);
            try {
                this.listenerService.broadcast("exo.hrmanagement.requestReply", (Object)"", (Object)validator);
            }
            catch (Exception e) {
                log.error((Object)"Cannot broadcast request reply event");
            }
        }
        obj.setStatus("declined");
        this.vacationRequestService.save(obj, false);
        try {
            this.listenerService.broadcast("exo.hrmanagement.requestUpadate", (Object)this.currentUser, (Object)obj);
        }
        catch (Exception e) {
            log.error((Object)"Cannot broadcast request reply event");
        }
        return obj;
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public VacationRequestDTO approveRequest(@Jackson VacationRequestDTO obj) {
        CommentDTO comment;
        Boolean validated = true;
        Boolean declined = false;
        for (ValidatorDTO validator : this.validatorService.getValidatorsByRequestId(obj.getId(), 0, 0)) {
            if (validator.getValidatorUserId().equals(this.currentUser)) {
                validator.setReply("approved");
                this.validatorService.save(validator);
                try {
                    this.listenerService.broadcast("exo.hrmanagement.requestReply", (Object)"", (Object)validator);
                }
                catch (Exception e) {
                    log.error((Object)"Cannot broadcast request reply event");
                }
                continue;
            }
            if (validator.getReply().equals("declined")) {
                declined = true;
            }
            if (!validator.getReply().equals("pending")) continue;
            validated = false;
        }
        if (declined.booleanValue()) {
            obj.setStatus("declined");
            this.vacationRequestService.save(obj, false);
            comment = new CommentDTO();
            comment.setRequestId(obj.getId());
            comment.setCommentText("requestDeclined");
            comment.setPosterId(this.currentUser);
            comment.setCommentType("history");
            this.commentService.save(comment);
            try {
                this.listenerService.broadcast("exo.hrmanagement.requestUpadate", (Object)this.currentUser, (Object)obj);
            }
            catch (Exception e) {
                log.error((Object)"Cannot broadcast update request event");
            }
        } else if (validated.booleanValue()) {
            obj.setStatus("approved");
            this.vacationRequestService.save(obj, false);
            comment = new CommentDTO();
            comment.setRequestId(obj.getId());
            comment.setCommentText("requestApproved");
            comment.setPosterId(this.currentUser);
            comment.setCommentType("history");
            this.commentService.save(comment);
            try {
                this.listenerService.broadcast("exo.hrmanagement.requestUpadate", (Object)this.currentUser, (Object)obj);
            }
            catch (Exception e) {
                log.error((Object)"Cannot broadcast update request event");
            }
        }
        return obj;
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getBundle() {
        try {
            if (!PropertyManager.isDevelopping() && this.bundleString != null && this.getResourceBundle().getLocale().equals(PortalRequestContext.getCurrentInstance().getLocale())) {
                return Response.ok((CharSequence)this.bundleString);
            }
            this.bundle = this.getResourceBundle(PortalRequestContext.getCurrentInstance().getLocale());
            JSON data = new JSON();
            Enumeration<String> enumeration = this.getResourceBundle().getKeys();
            while (enumeration.hasMoreElements()) {
                String key = enumeration.nextElement();
                try {
                    data.set(key.replaceAll("(.*)\\.", ""), this.getResourceBundle().getObject(key));
                }
                catch (MissingResourceException missingResourceException) {}
            }
            TimeZone userTimeZone = Utils.getUserTimezone((String)this.currentUser);
            data.set("userTimeZone", (Object)userTimeZone.toString());
            data.set("offset", (Object)userTimeZone.getOffset(new Date().getTime()));
            int offset = userTimeZone.getOffset(new Date().getTime()) / 3600000;
            String timeZone = (offset < 0 ? "-" : "") + String.format("%02d", Math.abs(offset)) + "00";
            data.set("timeZone", (Object)timeZone);
            data.set("currentUser", (Object)this.currentUser);
            this.bundleString = data.toString();
            return Response.ok((CharSequence)this.bundleString);
        }
        catch (Throwable e) {
            log.error((Object)"error while getting bundele", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getContext() {
        try {
            JSON data = new JSON();
            data.set("currentUser", (Object)this.currentUser);
            Profile profile = this.identityManager.getOrCreateIdentity("organization", this.currentUser, false).getProfile();
            if (profile.getAvatarUrl() != null) {
                data.set("currentUserAvatar", (Object)profile.getAvatarUrl());
            } else {
                data.set("currentUserAvatar", (Object)"/eXoSkin/skin/images/system/UserAvtDefault.png");
            }
            data.set("currentUserName", (Object)profile.getFullName());
            String employeesSpace = System.getProperty("exo.hrmanagement.employees.space");
            if (employeesSpace == null) {
                employeesSpace = "exo_employees";
            }
            data.set("employeesSpace", (Object)employeesSpace);
            UserRHDataDTO userRHDataDTO = this.userDataService.getUserRHDataByUserId(this.currentUser);
            if (userRHDataDTO != null) {
                data.set("sickBalance", (Object)Float.valueOf(userRHDataDTO.getSickdaysBalance()));
                data.set("holidaysBalance", (Object)Float.valueOf(userRHDataDTO.getHolidaysBalance()));
                data.set("hrId", (Object)userRHDataDTO.getHrId());
                data.set("insuranceId", (Object)userRHDataDTO.getInsuranceId());
                data.set("socialSecNumber", (Object)userRHDataDTO.getSocialSecNumber());
            }
            return Response.ok((CharSequence)data.toString());
        }
        catch (Throwable e) {
            log.error((Object)"error while getting bundele", e);
            return Response.status((int)500);
        }
    }

    private ResourceBundle getResourceBundle(Locale locale) {
        this.bundle = ResourceBundle.getBundle("locale.portlet.rh-management", locale, this.getClass().getClassLoader());
        return this.bundle;
    }

    private ResourceBundle getResourceBundle() {
        if (this.bundle == null) {
            this.bundle = this.getResourceBundle(PortalRequestContext.getCurrentInstance().getLocale());
        }
        return this.bundle;
    }

    private void shareCalendar_(VacationRequestDTO obj, String calId) {
        try {
            Calendar cal = this.calendarService.getCalendarById(calId);
            if (cal != null) {
                Event calendarEvent = new Event();
                calendarEvent.setId(calId + "_" + this.currentUser + "_" + obj.getId());
                calendarEvent.setEventCategoryId("defaultEventCategoryIdHoliday");
                calendarEvent.setEventCategoryName("defaultEventCategoryNameHoliday");
                calendarEvent.setSummary(obj.getUserFullName() + " Off");
                calendarEvent.setFromDateTime(obj.getFromDate());
                calendarEvent.setToDateTime(obj.getToDate());
                calendarEvent.setEventType(Event.TYPE_EVENT);
                calendarEvent.setParticipant(new String[]{this.currentUser});
                calendarEvent.setParticipantStatus(new String[]{this.currentUser + ":"});
                calendarEvent.setCalendarId(calId);
                this.xCalendarService.getEventHandler().saveEvent(calendarEvent);
            }
        }
        catch (Exception e) {
            log.error((Object)"Exception while create user event", (Throwable)e);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response uploadFile(Long requestId, FileItem file) throws IOException {
        if (file != null) {
            Utils.saveFile((FileItem)file, (String)"requests", (String)("req_" + requestId));
            CommentDTO comment = new CommentDTO();
            comment.setRequestId(requestId.longValue());
            comment.setCommentText("attachementAdded");
            comment.setPosterId(this.currentUser);
            comment.setCommentType("history");
            this.commentService.save(comment);
            return Response.ok();
        }
        return Response.notFound();
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response deleteFile(Long requestId, String fileName) throws IOException {
        Utils.deleteFile((String)("Application Data/hrmanagement/requests/req_" + requestId + "/" + fileName));
        CommentDTO comment = new CommentDTO();
        comment.setRequestId(requestId.longValue());
        comment.setCommentText("attachementDeleted");
        comment.setPosterId(this.currentUser);
        comment.setCommentType("history");
        this.commentService.save(comment);
        return Response.ok();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public Response getRequestAttachements(@Jackson VacationRequestDTO obj) {
        ArrayList<JSON> atts = new ArrayList<JSON>();
        try (SessionProvider sessionProvider = SessionProvider.createSystemProvider();){
            Session session = sessionProvider.getSession("collaboration", this.repositoryService.getCurrentRepository());
            Node rootNode = session.getRootNode();
            long requestId = obj.getId();
            if (rootNode.hasNode("Application Data/hrmanagement/requests/req_" + requestId)) {
                Node requestsFolder = rootNode.getNode("Application Data/hrmanagement/requests/req_" + requestId);
                NodeIterator iter = requestsFolder.getNodes();
                while (iter.hasNext()) {
                    Node node = (Node)iter.next();
                    JSON attachment = new JSON();
                    attachment.set("name", (Object)node.getName());
                    attachment.set("url", (Object)("/rest/jcr/repository/collaboration/Application Data/hrmanagement/requests/req_" + requestId + "/" + node.getName()));
                    atts.add(attachment);
                }
                Response.Content content = Response.ok((CharSequence)((Object)atts).toString());
                return content;
            }
            Response.Status status = Response.ok();
            return status;
        }
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public ContextDTO getData() {
        return this.getData(null);
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public ContextDTO getData(Long rid) {
        ContextDTO data = new ContextDTO();
        data.setCurrentUser(this.currentUser);
        Profile profile = this.identityManager.getOrCreateIdentity("organization", this.currentUser, false).getProfile();
        if (profile.getAvatarUrl() != null) {
            data.setCurrentUserAvatar(profile.getAvatarUrl());
        } else {
            data.setCurrentUserAvatar("/eXoSkin/skin/images/system/UserAvtDefault.png");
        }
        data.setCurrentUserName(profile.getFullName());
        String employeesSpace = System.getProperty("exo.hrmanagement.employees.space");
        if (employeesSpace == null) {
            employeesSpace = "exo_employees";
        }
        data.setEmployeesSpace(employeesSpace);
        UserRHDataDTO userRHDataDTO = this.userDataService.getUserRHDataByUserId(this.currentUser);
        if (userRHDataDTO != null) {
            data.setSickBalance(userRHDataDTO.getSickdaysBalance());
            data.setHolidaysBalance(userRHDataDTO.getHolidaysBalance());
            data.setHrId(userRHDataDTO.getHrId());
            data.setInsuranceId(userRHDataDTO.getInsuranceId());
            data.setSocialSecNumber(userRHDataDTO.getSocialSecNumber());
        }
        data.setMyVacationRequests(this.vacationRequestService.getActiveVacationRequestsByUserId(this.currentUser, 0, 100));
        data.setVacationRequestsToValidate(this.vacationRequestService.getActiveVacationRequestsByValidator(this.currentUser, 0, 100));
        if (rid != null) {
            data.setVacationRequestsToShow(this.getVacationRequest(rid));
        }
        data.setConventionalVacations(this.conventionalVacationService.getConventionalVacations(0, 0));
        data.setOfficialDays(this.officialVacationService.getOfficialVacationDays());
        return data;
    }
}

