/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.rhmanagement.portlet.rhAdministration;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.inject.Inject;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import juzu.HttpMethod;
import juzu.MimeType;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.View;
import juzu.impl.common.JSON;
import juzu.plugin.jackson.Jackson;
import juzu.template.Template;
import org.apache.commons.fileupload.FileItem;
import org.exoplatform.commons.juzu.ajax.Ajax;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.rhmanagement.dto.BalanceHistoryDTO;
import org.exoplatform.rhmanagement.dto.CommentDTO;
import org.exoplatform.rhmanagement.dto.ConventionalVacationDTO;
import org.exoplatform.rhmanagement.dto.EmployeesDTO;
import org.exoplatform.rhmanagement.dto.OfficialVacationDTO;
import org.exoplatform.rhmanagement.dto.UserRHDataDTO;
import org.exoplatform.rhmanagement.dto.VacationRequestDTO;
import org.exoplatform.rhmanagement.dto.VacationRequestsPageDTO;
import org.exoplatform.rhmanagement.dto.ValidatorDTO;
import org.exoplatform.rhmanagement.services.BalanceHistoryService;
import org.exoplatform.rhmanagement.services.CommentService;
import org.exoplatform.rhmanagement.services.ConventionalVacationService;
import org.exoplatform.rhmanagement.services.OfficialVacationService;
import org.exoplatform.rhmanagement.services.UserDataService;
import org.exoplatform.rhmanagement.services.Utils;
import org.exoplatform.rhmanagement.services.VacationRequestService;
import org.exoplatform.rhmanagement.services.ValidatorService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;

public class RhAdministrationController {
    private static Log LOG = ExoLogger.getLogger(RhAdministrationController.class);
    private String bundleString;
    ResourceBundle bundle;
    private final String APPROVED = "approved";
    private final String VALIDATED = "validated";
    private final String CANCELED = "canceled";
    @Inject
    UserDataService userDataService;
    @Inject
    CommentService commentService;
    @Inject
    ValidatorService validatorService;
    @Inject
    VacationRequestService vacationRequestService;
    @Inject
    IdentityManager identityManager;
    @Inject
    OrganizationService orgService;
    @Inject
    RepositoryService repositoryService;
    @Inject
    ListenerService listenerService;
    @Inject
    BalanceHistoryService balanceHistoryService;
    @Inject
    ConventionalVacationService conventionalVacationService;
    @Inject
    OfficialVacationService officialVacationService;
    @Inject
    @Path(value="index.gtmpl")
    Template indexTmpl;
    private final String currentUser = ConversationState.getCurrent().getIdentity().getUserId();

    @View
    public Response.Content index() {
        return this.indexTmpl.ok();
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public List<EmployeesDTO> getAllUsersRhData(String emfilter) {
        try {
            List uds = null;
            uds = emfilter.equals("active") ? this.userDataService.getUsersRhDataByStatus(true, 0, 0) : (emfilter.equals("former") ? this.userDataService.getUsersRhDataByStatus(false, 0, 0) : this.userDataService.getAllUsersRhData(0, 0));
            for (EmployeesDTO ud : uds) {
                ud.setExpanded(Boolean.valueOf(false));
            }
            return uds;
        }
        catch (Throwable e) {
            LOG.error((Object)e);
            return null;
        }
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public UserRHDataDTO saveUserRHData(@Jackson EmployeesDTO user) throws Exception {
        try {
            BalanceHistoryDTO balanceHistoryDTO;
            UserRHDataDTO userRHDataDTO = this.userDataService.getUserRHDataByUserId(user.getUserId());
            float oldHolidayBalance = 0.0f;
            float oldSickBalance = 0.0f;
            if (userRHDataDTO != null) {
                oldHolidayBalance = userRHDataDTO.getHolidaysBalance();
                oldSickBalance = userRHDataDTO.getSickdaysBalance();
            }
            float newHolidayBalance = user.getHrData().getHolidaysBalance();
            float newSickBalance = user.getHrData().getSickdaysBalance();
            if (oldHolidayBalance != newHolidayBalance) {
                try {
                    balanceHistoryDTO = new BalanceHistoryDTO();
                    balanceHistoryDTO.setUserId(user.getUserId());
                    balanceHistoryDTO.setIntialHolidaysBalance(oldHolidayBalance);
                    balanceHistoryDTO.setIntialSickBalance(oldSickBalance);
                    balanceHistoryDTO.setHolidaysBalance(newHolidayBalance);
                    balanceHistoryDTO.setSickBalance(oldSickBalance);
                    balanceHistoryDTO.setVacationType("holiday");
                    balanceHistoryDTO.setVacationId(-1L);
                    balanceHistoryDTO.setDaysNumber(newHolidayBalance - oldHolidayBalance);
                    balanceHistoryDTO.setUpdateType("holidaysManualUpdate");
                    balanceHistoryDTO.setUpdaterId(this.currentUser);
                    this.balanceHistoryService.save(balanceHistoryDTO);
                }
                catch (Exception e) {
                    LOG.error((Object)"Error when adding history entry", (Throwable)e);
                }
            }
            if (oldSickBalance != newSickBalance) {
                try {
                    balanceHistoryDTO = new BalanceHistoryDTO();
                    balanceHistoryDTO.setUserId(user.getUserId());
                    balanceHistoryDTO.setIntialHolidaysBalance(oldHolidayBalance);
                    balanceHistoryDTO.setIntialSickBalance(oldSickBalance);
                    balanceHistoryDTO.setHolidaysBalance(oldHolidayBalance);
                    balanceHistoryDTO.setSickBalance(newSickBalance);
                    balanceHistoryDTO.setVacationType("sick");
                    balanceHistoryDTO.setVacationId(-1L);
                    balanceHistoryDTO.setDaysNumber(newSickBalance - oldSickBalance);
                    balanceHistoryDTO.setUpdateType("sicksManualUpdate");
                    balanceHistoryDTO.setUpdaterId(this.currentUser);
                    this.balanceHistoryService.save(balanceHistoryDTO);
                }
                catch (Exception e) {
                    LOG.error((Object)"Error when adding history entry", (Throwable)e);
                }
            }
            return this.userDataService.save(user.getHrData());
        }
        catch (Exception e) {
            LOG.error((Object)"Error when updating userData", (Throwable)e);
            throw e;
        }
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public Response deleteUserRHData(@Jackson EmployeesDTO user) throws Exception {
        try {
            this.userDataService.remove(user.getHrData());
            Utils.deleteFile((String)("Application Data/hrmanagement/employees/emp_" + user.getUserId()));
            return Response.ok();
        }
        catch (Exception e) {
            LOG.error((Object)"Error when updating userData", (Throwable)e);
            return Response.error((String)"");
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public List<VacationRequestDTO> getVacationRequestsbyUserId(String userId, String vrFilter) {
        try {
            if (vrFilter != null && vrFilter.equals("active")) {
                return this.vacationRequestService.getActiveVacationRequestsByUserId(userId, 0, 100);
            }
            return this.vacationRequestService.getVacationRequestsByUserId(userId, 0, 100);
        }
        catch (Throwable e) {
            LOG.error((Object)e);
            return null;
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public List<BalanceHistoryDTO> getBalanceHistoryByUserId(String userId, Long from, Long to) {
        try {
            if (userId.equals("")) {
                return this.balanceHistoryService.getBalanceHistoryByDate(from.longValue(), to.longValue(), 0, 0);
            }
            return this.balanceHistoryService.getBalanceHistoryByUserId(userId, from.longValue(), to.longValue(), 0, 0);
        }
        catch (Throwable e) {
            LOG.error((Object)e);
            return null;
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public EmployeesDTO getUser(String userId) {
        try {
            UserHandler uh = this.orgService.getUserHandler();
            if (uh.findUserByName(userId) == null) {
                return null;
            }
            Profile profile = this.identityManager.getOrCreateIdentity("organization", userId, false).getProfile();
            EmployeesDTO employee = new EmployeesDTO();
            employee.setName(profile.getFullName());
            employee.setUserId(userId);
            employee.setEmail(profile.getEmail());
            employee.setGender(profile.getGender());
            employee.setJobTitle(profile.getPosition());
            employee.setAvatar(profile.getAvatarUrl());
            UserRHDataDTO userRHDataDTO = this.userDataService.getUserRHDataByUserId(userId);
            if (userRHDataDTO == null) {
                userRHDataDTO = new UserRHDataDTO();
                userRHDataDTO.setUserId(userId);
            }
            employee.setHrData(userRHDataDTO);
            return employee;
        }
        catch (Throwable e) {
            LOG.error((Object)e);
            return null;
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public VacationRequestsPageDTO getVacationRequests(String vrFilter, int offset, int limit) {
        try {
            VacationRequestsPageDTO vacationRequestsPageDTO = new VacationRequestsPageDTO();
            if (vrFilter != null && vrFilter.equals("active")) {
                vacationRequestsPageDTO.setVacationRequests(this.vacationRequestService.getActivVacationRequests(offset, limit));
                vacationRequestsPageDTO.setSize(this.vacationRequestService.getActiveVacationRequestsCount());
                return vacationRequestsPageDTO;
            }
            vacationRequestsPageDTO.setVacationRequests(this.vacationRequestService.getVacationRequests(offset, limit));
            vacationRequestsPageDTO.setSize(this.vacationRequestService.getVacationRequestesCount());
            return vacationRequestsPageDTO;
        }
        catch (Throwable e) {
            LOG.error((Object)e);
            return null;
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public List<VacationRequestDTO> getActivVacationRequests() {
        try {
            List vrs = this.vacationRequestService.getActivVacationRequests(0, 100);
            for (VacationRequestDTO vr : vrs) {
                vr.setExpanded(Boolean.valueOf(false));
            }
            return vrs;
        }
        catch (Throwable e) {
            LOG.error((Object)e);
            return null;
        }
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public UserRHDataDTO validateRequest(@Jackson VacationRequestDTO obj) {
        UserRHDataDTO userRHDataDTO = null;
        if (!obj.getStatus().equals("validated")) {
            float nbDays;
            obj.setStatus("validated");
            obj = this.vacationRequestService.save(obj, false);
            userRHDataDTO = this.userDataService.getUserRHDataByUserId(obj.getUserId());
            if (obj.getType().equals("holiday")) {
                float holidays = userRHDataDTO.getHolidaysBalance();
                nbDays = obj.getDaysNumber();
                userRHDataDTO.setHolidaysBalance(holidays - nbDays);
                this.userDataService.save(userRHDataDTO);
                Utils.addBalanceHistoryEntry((VacationRequestDTO)obj, (UserRHDataDTO)userRHDataDTO, (float)holidays, (float)userRHDataDTO.getSickdaysBalance(), (String)"holidayValidated", (String)this.currentUser);
            }
            if (obj.getType().equals("sick")) {
                float sickdays = userRHDataDTO.getSickdaysBalance();
                nbDays = obj.getDaysNumber();
                userRHDataDTO.setSickdaysBalance(sickdays - nbDays);
                this.userDataService.save(userRHDataDTO);
                Utils.addBalanceHistoryEntry((VacationRequestDTO)obj, (UserRHDataDTO)userRHDataDTO, (float)userRHDataDTO.getHolidaysBalance(), (float)sickdays, (String)"sickValidated", (String)this.currentUser);
            }
            CommentDTO comment = new CommentDTO();
            comment.setRequestId(obj.getId());
            comment.setCommentText("requestValidated");
            comment.setPosterId(this.currentUser);
            comment.setCommentType("history");
            this.commentService.save(comment);
            try {
                this.listenerService.broadcast("exo.hrmanagement.requestUpadate", (Object)this.currentUser, (Object)obj);
            }
            catch (Exception e) {
                LOG.error((Object)"Cannot broadcast update request event");
            }
        }
        return userRHDataDTO;
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public UserRHDataDTO cancelRequest(@Jackson VacationRequestDTO obj) {
        UserRHDataDTO userRHDataDTO = null;
        if (!obj.getStatus().equals("canceled")) {
            if (obj.getStatus().equals("validated")) {
                float nbDays;
                userRHDataDTO = this.userDataService.getUserRHDataByUserId(obj.getUserId());
                if (obj.getType().equals("holiday")) {
                    float holidays = userRHDataDTO.getHolidaysBalance();
                    nbDays = obj.getDaysNumber();
                    userRHDataDTO.setHolidaysBalance(holidays + nbDays);
                    this.userDataService.save(userRHDataDTO);
                    Utils.addBalanceHistoryEntry((VacationRequestDTO)obj, (UserRHDataDTO)userRHDataDTO, (float)holidays, (float)userRHDataDTO.getSickdaysBalance(), (String)"holidayCanceled", (String)this.currentUser);
                }
                if (obj.getType().equals("sick")) {
                    float sickdays = userRHDataDTO.getSickdaysBalance();
                    nbDays = obj.getDaysNumber();
                    userRHDataDTO.setSickdaysBalance(sickdays + nbDays);
                    this.userDataService.save(userRHDataDTO);
                    Utils.addBalanceHistoryEntry((VacationRequestDTO)obj, (UserRHDataDTO)userRHDataDTO, (float)userRHDataDTO.getHolidaysBalance(), (float)sickdays, (String)"sickCanceled", (String)this.currentUser);
                }
            }
            obj.setStatus("canceled");
            obj = this.vacationRequestService.save(obj, false);
            CommentDTO comment = new CommentDTO();
            comment.setRequestId(obj.getId());
            comment.setCommentText("requestCanceled");
            comment.setPosterId(this.currentUser);
            comment.setCommentType("history");
            this.commentService.save(comment);
            try {
                this.listenerService.broadcast("exo.hrmanagement.requestUpadate", (Object)this.currentUser, (Object)obj);
            }
            catch (Exception e) {
                LOG.error((Object)"Cannot broadcast update request event");
            }
        }
        return userRHDataDTO;
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getBundle() {
        try {
            if (!PropertyManager.isDevelopping() && this.bundleString != null && this.getResourceBundle().getLocale().equals(PortalRequestContext.getCurrentInstance().getLocale())) {
                return Response.ok((CharSequence)this.bundleString);
            }
            this.bundle = this.getResourceBundle(PortalRequestContext.getCurrentInstance().getLocale());
            JSON data = new JSON();
            Enumeration<String> enumeration = this.getResourceBundle().getKeys();
            while (enumeration.hasMoreElements()) {
                String key = enumeration.nextElement();
                try {
                    data.set(key.replaceAll("(.*)\\.", ""), this.getResourceBundle().getObject(key));
                }
                catch (MissingResourceException missingResourceException) {}
            }
            TimeZone userTimeZone = Utils.getUserTimezone((String)this.currentUser);
            data.set("userTimeZone", (Object)userTimeZone.toString());
            data.set("offset", (Object)userTimeZone.getOffset(new Date().getTime()));
            int offset = userTimeZone.getOffset(new Date().getTime()) / 3600000;
            String timeZone = (offset < 0 ? "-" : "") + String.format("%02d", Math.abs(offset)) + "00";
            data.set("timeZone", (Object)timeZone);
            data.set("currentUser", (Object)this.currentUser);
            this.bundleString = data.toString();
            return Response.ok((CharSequence)this.bundleString);
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting categories", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getContext() {
        try {
            JSON data = new JSON();
            data.set("currentUser", (Object)this.currentUser);
            Profile profile = this.identityManager.getOrCreateIdentity("organization", this.currentUser, false).getProfile();
            if (profile.getAvatarUrl() != null) {
                data.set("currentUserAvatar", (Object)profile.getAvatarUrl());
            } else {
                data.set("currentUserAvatar", (Object)"/eXoSkin/skin/images/system/UserAvtDefault.png");
            }
            data.set("currentUserName", (Object)profile.getFullName());
            data.set("vRCount", (Object)this.vacationRequestService.getVacationRequestesCount());
            return Response.ok((CharSequence)data.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    private ResourceBundle getResourceBundle(Locale locale) {
        this.bundle = ResourceBundle.getBundle("locale.portlet.rh-management", locale, this.getClass().getClassLoader());
        return this.bundle;
    }

    private ResourceBundle getResourceBundle() {
        if (this.bundle == null) {
            this.bundle = this.getResourceBundle(PortalRequestContext.getCurrentInstance().getLocale());
        }
        return this.bundle;
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response uploadFile(String userId, FileItem file) throws IOException {
        if (file != null) {
            Utils.saveFile((FileItem)file, (String)"employees", (String)("emp_" + userId));
            return Response.ok();
        }
        return Response.notFound();
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response deleteFile(String userId, String fileName) throws IOException {
        Utils.deleteFile((String)("Application Data/hrmanagement/employees/emp_" + userId + "/" + fileName));
        return Response.ok();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public Response getEmployeeAttachements(@Jackson EmployeesDTO obj) {
        ArrayList<JSON> atts = new ArrayList<JSON>();
        try (SessionProvider sessionProvider = SessionProvider.createSystemProvider();){
            Session session = sessionProvider.getSession("collaboration", this.repositoryService.getCurrentRepository());
            Node rootNode = session.getRootNode();
            String userId = obj.getUserId();
            if (rootNode.hasNode("Application Data/hrmanagement/employees/emp_" + userId)) {
                Node requestsFolder = rootNode.getNode("Application Data/hrmanagement/employees/emp_" + userId);
                NodeIterator iter = requestsFolder.getNodes();
                while (iter.hasNext()) {
                    Node node = (Node)iter.next();
                    JSON attachment = new JSON();
                    attachment.set("name", (Object)node.getName());
                    attachment.set("url", (Object)("/rest/jcr/repository/collaboration/Application Data/hrmanagement/employees/emp_" + userId + "/" + node.getName()));
                    atts.add(attachment);
                }
                Response.Content content = Response.ok((CharSequence)((Object)atts).toString());
                return content;
            }
            Response.Status status = Response.ok();
            return status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public Response getRequestAttachements(@Jackson VacationRequestDTO obj) {
        ArrayList<JSON> atts = new ArrayList<JSON>();
        try (SessionProvider sessionProvider = SessionProvider.createSystemProvider();){
            Session session = sessionProvider.getSession("collaboration", this.repositoryService.getCurrentRepository());
            Node rootNode = session.getRootNode();
            long requestId = obj.getId();
            if (rootNode.hasNode("Application Data/hrmanagement/requests/req_" + requestId)) {
                Node requestsFolder = rootNode.getNode("Application Data/hrmanagement/requests/req_" + requestId);
                NodeIterator iter = requestsFolder.getNodes();
                while (iter.hasNext()) {
                    Node node = (Node)iter.next();
                    JSON attachment = new JSON();
                    attachment.set("name", (Object)node.getName());
                    attachment.set("url", (Object)("/rest/jcr/repository/collaboration/Application Data/hrmanagement/requests/req_" + requestId + "/" + node.getName()));
                    atts.add(attachment);
                }
                Response.Content content = Response.ok((CharSequence)((Object)atts).toString());
                return content;
            }
            Response.Status status = Response.ok();
            return status;
        }
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public void saveComment(@Jackson CommentDTO obj) {
        obj.setPosterId(this.currentUser);
        obj.setCommentType("comment");
        this.commentService.save(obj);
        try {
            this.listenerService.broadcast("exo.hrmanagement.requestComment", (Object)this.currentUser, (Object)obj);
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot broadcast comment request event");
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public List<CommentDTO> getComments(@Jackson VacationRequestDTO obj) {
        try {
            List comments = this.commentService.getCommentsByRequestId(obj.getId(), "comment", 0, 100);
            for (CommentDTO comment : comments) {
                Profile profile = this.identityManager.getOrCreateIdentity("organization", comment.getPosterId(), false).getProfile();
                comment.setPosterName(profile.getFullName());
                if (profile.getAvatarUrl() != null) {
                    comment.setPosterAvatar(profile.getAvatarUrl());
                    continue;
                }
                comment.setPosterAvatar("/eXoSkin/skin/images/system/UserAvtDefault.png");
            }
            return comments;
        }
        catch (Throwable e) {
            LOG.error((Object)e);
            return null;
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public List<CommentDTO> getHistory(@Jackson VacationRequestDTO obj) {
        try {
            List comments = this.commentService.getCommentsByRequestId(obj.getId(), "history", 0, 100);
            for (CommentDTO comment : comments) {
                Profile profile = this.identityManager.getOrCreateIdentity("organization", comment.getPosterId(), false).getProfile();
                comment.setPosterName(profile.getFullName());
                if (profile.getAvatarUrl() != null) {
                    comment.setPosterAvatar(profile.getAvatarUrl());
                    continue;
                }
                comment.setPosterAvatar("/eXoSkin/skin/images/system/UserAvtDefault.png");
            }
            return comments;
        }
        catch (Throwable e) {
            LOG.error((Object)e);
            return null;
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public List<ValidatorDTO> getValidatorsByRequestID(@Jackson VacationRequestDTO obj) {
        ArrayList<ValidatorDTO> validators = new ArrayList<ValidatorDTO>();
        try {
            for (ValidatorDTO validator : this.validatorService.getValidatorsByRequestId(obj.getId(), 0, 0)) {
                validator.setValidatorName(this.identityManager.getOrCreateIdentity("organization", validator.getValidatorUserId(), false).getProfile().getFullName());
                validators.add(validator);
            }
            return validators;
        }
        catch (Throwable e) {
            LOG.error((Object)e);
            return null;
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public List<EmployeesDTO> getSubstitutesByRequestID(@Jackson VacationRequestDTO obj) {
        try {
            ArrayList<EmployeesDTO> userDTOs = new ArrayList<EmployeesDTO>();
            for (String userId : obj.getSubstitute().split(",")) {
                Identity id = this.identityManager.getOrCreateIdentity("organization", userId, false);
                if (id == null) continue;
                EmployeesDTO employeesDTO = new EmployeesDTO();
                employeesDTO.setUserId(userId);
                employeesDTO.setName(id.getProfile().getFullName());
                userDTOs.add(employeesDTO);
            }
            return userDTOs;
        }
        catch (Throwable e) {
            LOG.error((Object)e);
            return null;
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public VacationRequestDTO getVacationRequest(Long id) {
        try {
            VacationRequestDTO vr = this.vacationRequestService.getVacationRequest(id.longValue());
            if (Utils.canView((VacationRequestDTO)vr, (String)this.currentUser).booleanValue()) {
                return vr;
            }
            return null;
        }
        catch (Throwable e) {
            LOG.error((Object)e);
            return null;
        }
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public void saveVacationRequest(@Jackson VacationRequestDTO obj) {
        if (obj.getStatus().equals("validated")) {
            float newNbDays;
            float oldNbDays;
            UserRHDataDTO userRHDataDTO = this.userDataService.getUserRHDataByUserId(obj.getUserId());
            VacationRequestDTO oldVr = this.vacationRequestService.getVacationRequest(obj.getId());
            if (obj.getType().equals("holiday") && oldVr.getDaysNumber() != obj.getDaysNumber()) {
                float holidays = userRHDataDTO.getHolidaysBalance();
                oldNbDays = oldVr.getDaysNumber();
                newNbDays = obj.getDaysNumber();
                userRHDataDTO.setHolidaysBalance(holidays + (oldNbDays - newNbDays));
                this.userDataService.save(userRHDataDTO);
                Utils.addBalanceHistoryEntry((VacationRequestDTO)obj, (UserRHDataDTO)userRHDataDTO, (float)holidays, (float)userRHDataDTO.getSickdaysBalance(), (String)"holidayUpdated", (String)this.currentUser);
            }
            if (obj.getType().equals("sick") && oldVr.getDaysNumber() != obj.getDaysNumber()) {
                float sickDays = userRHDataDTO.getSickdaysBalance();
                oldNbDays = oldVr.getDaysNumber();
                newNbDays = obj.getDaysNumber();
                userRHDataDTO.setSickdaysBalance(sickDays + (oldNbDays - newNbDays));
                this.userDataService.save(userRHDataDTO);
                Utils.addBalanceHistoryEntry((VacationRequestDTO)obj, (UserRHDataDTO)userRHDataDTO, (float)userRHDataDTO.getHolidaysBalance(), (float)sickDays, (String)"sickDaysUpdated", (String)this.currentUser);
            }
        }
        this.vacationRequestService.save(obj, false);
        CommentDTO comment = new CommentDTO();
        comment.setRequestId(obj.getId());
        comment.setCommentText("requestDaysUpdated");
        comment.setPosterId(this.currentUser);
        comment.setCommentType("history");
        this.commentService.save(comment);
        try {
            this.listenerService.broadcast("exo.hrmanagement.requestUpdated", (Object)"", (Object)obj);
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot broadcast request creation event");
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public ConventionalVacationDTO getConventionalVacationsById(Long id) {
        try {
            return this.conventionalVacationService.getConventionalVacationsById(id.longValue());
        }
        catch (Throwable e) {
            LOG.error((Object)e);
            return null;
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public List<ConventionalVacationDTO> getConventionalVacations() {
        try {
            return this.conventionalVacationService.getConventionalVacations(0, 0);
        }
        catch (Throwable e) {
            LOG.error((Object)e);
            return null;
        }
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public void saveConventionalVacation(@Jackson ConventionalVacationDTO obj) {
        this.conventionalVacationService.save(obj, true);
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public void updateConventionalVacation(@Jackson ConventionalVacationDTO obj) {
        this.conventionalVacationService.save(obj, false);
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public Response deleteConventionalVacation(@Jackson ConventionalVacationDTO obj) throws Exception {
        try {
            this.conventionalVacationService.remove(obj);
            return Response.ok();
        }
        catch (Exception e) {
            LOG.error((Object)"Error when updating Conventional Vacation", (Throwable)e);
            return Response.error((String)"");
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public OfficialVacationDTO getOfficialVacationsById(Long id) {
        try {
            return this.officialVacationService.getOfficialVacationsById(id.longValue());
        }
        catch (Throwable e) {
            LOG.error((Object)e);
            return null;
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public List<OfficialVacationDTO> getOfficialVacations() {
        try {
            return this.officialVacationService.getOfficialVacations(0, 0);
        }
        catch (Throwable e) {
            LOG.error((Object)e);
            return null;
        }
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public void saveOfficialVacation(@Jackson OfficialVacationDTO obj) {
        Calendar c = Calendar.getInstance();
        c.setTime(obj.getBeginDate());
        c.add(5, obj.getDaysNumber() - 1);
        obj.setEndDate(c.getTime());
        this.officialVacationService.save(obj, true);
        this.upadteNumberOfDays(obj.getBeginDate());
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public void updateOfficialVacation(@Jackson OfficialVacationDTO obj) {
        Calendar c = Calendar.getInstance();
        c.setTime(obj.getBeginDate());
        c.add(5, obj.getDaysNumber());
        obj.setEndDate(c.getTime());
        this.officialVacationService.save(obj, false);
        this.upadteNumberOfDays(obj.getBeginDate());
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public Response deleteOfficialVacation(@Jackson OfficialVacationDTO obj) throws Exception {
        try {
            this.officialVacationService.remove(obj);
            this.upadteNumberOfDays(obj.getBeginDate());
            return Response.ok();
        }
        catch (Exception e) {
            LOG.error((Object)"Error when updating Conventional Vacation", (Throwable)e);
            return Response.error((String)"");
        }
    }

    public void upadteNumberOfDays(Date date) {
        List vRequests = this.vacationRequestService.getVacationRequestByDate(date);
        List oVacation = this.officialVacationService.getOfficialVacationDays();
        for (VacationRequestDTO vr : vRequests) {
            if ("conventional".equals(vr.getType()) || "leave".equals(vr.getType())) continue;
            float nb = Utils.calculateNumberOfDays((List)oVacation, (Date)vr.getFromDate(), (Date)vr.getToDate());
            if (vr.getDaysNumber() == nb) continue;
            vr.setDaysNumber(nb);
            this.saveVacationRequest(vr);
            LOG.info((Object)("Number of days of the request " + vr.getId() + " is updated"));
        }
    }
}

