/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.rhmanagement.portlet.rhAdministrationSettings;

import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.inject.Inject;
import juzu.HttpMethod;
import juzu.MimeType;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.View;
import juzu.impl.common.JSON;
import juzu.plugin.jackson.Jackson;
import juzu.template.Template;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.juzu.ajax.Ajax;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.rhmanagement.dto.ConventionalVacationDTO;
import org.exoplatform.rhmanagement.dto.OfficialVacationDTO;
import org.exoplatform.rhmanagement.dto.SettingsDTO;
import org.exoplatform.rhmanagement.dto.VacationRequestDTO;
import org.exoplatform.rhmanagement.services.ConventionalVacationService;
import org.exoplatform.rhmanagement.services.OfficialVacationService;
import org.exoplatform.rhmanagement.services.Utils;
import org.exoplatform.rhmanagement.services.VacationRequestService;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;

public class RhAdministrationSettingsController {
    private static Log LOG = ExoLogger.getLogger(RhAdministrationSettingsController.class);
    private String bundleString;
    ResourceBundle bundle;
    private final String RH_MANAGER = "lastAccess";
    @Inject
    VacationRequestService vacationRequestService;
    @Inject
    ConventionalVacationService conventionalVacationService;
    @Inject
    OfficialVacationService officialVacationService;
    @Inject
    SettingService settingService;
    @Inject
    ListenerService listenerService;
    @Inject
    @Path(value="index.gtmpl")
    Template indexTmpl;
    private final String currentUser = ConversationState.getCurrent().getIdentity().getUserId();

    @View
    public Response.Content index() {
        return this.indexTmpl.ok();
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getBundle() {
        try {
            if (!PropertyManager.isDevelopping() && this.bundleString != null && this.getResourceBundle().getLocale().equals(PortalRequestContext.getCurrentInstance().getLocale())) {
                return Response.ok((CharSequence)this.bundleString);
            }
            this.bundle = this.getResourceBundle(PortalRequestContext.getCurrentInstance().getLocale());
            JSON data = new JSON();
            Enumeration<String> enumeration = this.getResourceBundle().getKeys();
            while (enumeration.hasMoreElements()) {
                String key = enumeration.nextElement();
                try {
                    data.set(key.replaceAll("(.*)\\.", ""), this.getResourceBundle().getObject(key));
                }
                catch (MissingResourceException missingResourceException) {}
            }
            TimeZone userTimeZone = Utils.getUserTimezone((String)this.currentUser);
            data.set("userTimeZone", (Object)userTimeZone.toString());
            data.set("offset", (Object)userTimeZone.getOffset(new Date().getTime()));
            int offset = userTimeZone.getOffset(new Date().getTime()) / 3600000;
            String timeZone = (offset < 0 ? "-" : "") + String.format("%02d", Math.abs(offset)) + "00";
            data.set("timeZone", (Object)timeZone);
            data.set("currentUser", (Object)this.currentUser);
            this.bundleString = data.toString();
            return Response.ok((CharSequence)this.bundleString);
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting categories", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getContext() {
        try {
            JSON data = new JSON();
            data.set("currentUser", (Object)this.currentUser);
            String rhManager = "";
            if (this.settingService.get(Context.GLOBAL, Scope.GLOBAL, "lastAccess") != null) {
                rhManager = this.settingService.get(Context.GLOBAL, Scope.GLOBAL, "lastAccess").getValue().toString();
            }
            data.set("rhManager", (Object)rhManager);
            return Response.ok((CharSequence)data.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public void saveSettings(@Jackson SettingsDTO obj) {
        this.settingService.set(Context.GLOBAL, Scope.GLOBAL, "lastAccess", SettingValue.create((String)obj.getRhManager()));
    }

    private ResourceBundle getResourceBundle(Locale locale) {
        this.bundle = ResourceBundle.getBundle("locale.portlet.rh-management", locale, this.getClass().getClassLoader());
        return this.bundle;
    }

    private ResourceBundle getResourceBundle() {
        if (this.bundle == null) {
            this.bundle = this.getResourceBundle(PortalRequestContext.getCurrentInstance().getLocale());
        }
        return this.bundle;
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public ConventionalVacationDTO getConventionalVacationsById(Long id) {
        try {
            return this.conventionalVacationService.getConventionalVacationsById(id.longValue());
        }
        catch (Throwable e) {
            LOG.error((Object)e);
            return null;
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public List<ConventionalVacationDTO> getConventionalVacations() {
        try {
            return this.conventionalVacationService.getConventionalVacations(0, 0);
        }
        catch (Throwable e) {
            LOG.error((Object)e);
            return null;
        }
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public void saveConventionalVacation(@Jackson ConventionalVacationDTO obj) {
        this.conventionalVacationService.save(obj, true);
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public void updateConventionalVacation(@Jackson ConventionalVacationDTO obj) {
        this.conventionalVacationService.save(obj, false);
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public Response deleteConventionalVacation(@Jackson ConventionalVacationDTO obj) throws Exception {
        try {
            this.conventionalVacationService.remove(obj);
            return Response.ok();
        }
        catch (Exception e) {
            LOG.error((Object)"Error when updating Conventional Vacation", (Throwable)e);
            return Response.error((String)"");
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public OfficialVacationDTO getOfficialVacationsById(Long id) {
        try {
            return this.officialVacationService.getOfficialVacationsById(id.longValue());
        }
        catch (Throwable e) {
            LOG.error((Object)e);
            return null;
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public List<OfficialVacationDTO> getOfficialVacations() {
        try {
            return this.officialVacationService.getOfficialVacations(0, 0);
        }
        catch (Throwable e) {
            LOG.error((Object)e);
            return null;
        }
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public void saveOfficialVacation(@Jackson OfficialVacationDTO obj) {
        Calendar c = Calendar.getInstance();
        c.setTime(obj.getBeginDate());
        c.add(5, obj.getDaysNumber() - 1);
        obj.setEndDate(c.getTime());
        this.officialVacationService.save(obj, true);
        this.upadteNumberOfDays(obj.getBeginDate());
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public void updateOfficialVacation(@Jackson OfficialVacationDTO obj) {
        Calendar c = Calendar.getInstance();
        c.setTime(obj.getBeginDate());
        c.add(5, obj.getDaysNumber());
        obj.setEndDate(c.getTime());
        this.officialVacationService.save(obj, false);
        this.upadteNumberOfDays(obj.getBeginDate());
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public Response deleteOfficialVacation(@Jackson OfficialVacationDTO obj) throws Exception {
        try {
            this.officialVacationService.remove(obj);
            this.upadteNumberOfDays(obj.getBeginDate());
            return Response.ok();
        }
        catch (Exception e) {
            LOG.error((Object)"Error when updating Conventional Vacation", (Throwable)e);
            return Response.error((String)"");
        }
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public void saveVacationRequest(@Jackson VacationRequestDTO obj) {
        this.vacationRequestService.save(obj, true);
        try {
            this.listenerService.broadcast("exo.hrmanagement.requestCreated", (Object)"", (Object)obj);
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot broadcast request creation event");
        }
    }

    public void upadteNumberOfDays(Date date) {
        List vRequests = this.vacationRequestService.getVacationRequestByDate(date);
        List oVacation = this.officialVacationService.getOfficialVacationDays();
        for (VacationRequestDTO vr : vRequests) {
            if ("conventional".equals(vr.getType()) || "leave".equals(vr.getType())) continue;
            float nb = Utils.calculateNumberOfDays((List)oVacation, (Date)vr.getFromDate(), (Date)vr.getToDate());
            if (vr.getDaysNumber() == nb) continue;
            vr.setDaysNumber(nb);
            this.saveVacationRequest(vr);
            LOG.info((Object)("Number of days of the request " + vr.getId() + " is updated"));
        }
    }
}

