/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.rhmanagement.portlet.rhAdministrationMenu;

import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.inject.Inject;
import juzu.MimeType;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.View;
import juzu.impl.common.JSON;
import juzu.plugin.jackson.Jackson;
import juzu.template.Template;
import org.exoplatform.commons.juzu.ajax.Ajax;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class RhAdministrationMenuController {
    private static Log LOG = ExoLogger.getLogger(RhAdministrationMenuController.class);
    private String bundleString;
    ResourceBundle bundle;
    @Inject
    @Path(value="index.gtmpl")
    Template indexTmpl;

    @View
    public Response.Content index() {
        return this.indexTmpl.ok();
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getBundle() {
        try {
            if (!PropertyManager.isDevelopping() && this.bundleString != null && this.getResourceBundle().getLocale().equals(PortalRequestContext.getCurrentInstance().getLocale())) {
                return Response.ok((CharSequence)this.bundleString);
            }
            this.bundle = this.getResourceBundle(PortalRequestContext.getCurrentInstance().getLocale());
            JSON data = new JSON();
            Enumeration<String> enumeration = this.getResourceBundle().getKeys();
            while (enumeration.hasMoreElements()) {
                String key = enumeration.nextElement();
                try {
                    data.set(key.replaceAll("(.*)\\.", ""), this.getResourceBundle().getObject(key));
                }
                catch (MissingResourceException missingResourceException) {}
            }
            this.bundleString = data.toString();
            return Response.ok((CharSequence)this.bundleString).withHeader("Cache-Control", new String[]{"max-age=864000"});
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting categories", e);
            return Response.status((int)500);
        }
    }

    private ResourceBundle getResourceBundle(Locale locale) {
        this.bundle = ResourceBundle.getBundle("locale.portlet.rh-management", locale, this.getClass().getClassLoader());
        return this.bundle;
    }

    private ResourceBundle getResourceBundle() {
        if (this.bundle == null) {
            this.bundle = this.getResourceBundle(PortalRequestContext.getCurrentInstance().getLocale());
        }
        return this.bundle;
    }
}

