/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.rhmanagement.portlet.rhUserInfo;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.inject.Inject;
import juzu.HttpMethod;
import juzu.MimeType;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.SessionScoped;
import juzu.View;
import juzu.impl.common.JSON;
import juzu.plugin.jackson.Jackson;
import juzu.template.Template;
import org.exoplatform.commons.juzu.ajax.Ajax;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.rhmanagement.dto.ContextDTO;
import org.exoplatform.rhmanagement.dto.UserRHDataDTO;
import org.exoplatform.rhmanagement.services.ConventionalVacationService;
import org.exoplatform.rhmanagement.services.OfficialVacationService;
import org.exoplatform.rhmanagement.services.UserDataService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.json.JSONArray;
import org.json.JSONObject;

@SessionScoped
public class RHUserInfoController {
    private static Log log = ExoLogger.getLogger(RHUserInfoController.class);
    ResourceBundle bundle;
    @Inject
    IdentityManager identityManager;
    @Inject
    UserDataService userDataService;
    @Inject
    ConventionalVacationService conventionalVacationService;
    @Inject
    OfficialVacationService officialVacationService;
    @Inject
    @Path(value="index.gtmpl")
    Template indexTmpl;
    private String bundleString;
    private final String currentUser = ConversationState.getCurrent().getIdentity().getUserId();

    @View
    public Response.Content index() {
        return this.indexTmpl.ok();
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public ContextDTO getData() {
        ContextDTO data = new ContextDTO();
        data.setCurrentUser(this.currentUser);
        Profile profile = this.identityManager.getOrCreateIdentity("organization", this.currentUser, false).getProfile();
        if (profile.getAvatarUrl() != null) {
            data.setCurrentUserAvatar(profile.getAvatarUrl());
        } else {
            data.setCurrentUserAvatar("/eXoSkin/skin/images/system/UserAvtDefault.png");
        }
        data.setCurrentUserName(profile.getFullName());
        UserRHDataDTO userRHDataDTO = this.userDataService.getUserRHDataByUserId(this.currentUser);
        if (userRHDataDTO != null) {
            data.setSickBalance(userRHDataDTO.getSickdaysBalance());
            data.setHolidaysBalance(userRHDataDTO.getHolidaysBalance());
            data.setHrId(userRHDataDTO.getHrId());
            data.setInsuranceId(userRHDataDTO.getInsuranceId());
            data.setSocialSecNumber(userRHDataDTO.getSocialSecNumber());
        }
        data.setConventionalVacations(this.conventionalVacationService.getConventionalVacations(0, 0));
        data.setOfficialDays(this.officialVacationService.getOfficialVacationDays());
        data.setOfficialVacations(this.officialVacationService.getOfficialVacations(0, 0));
        return data;
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getFunctionalOrganization(String userId) {
        try {
            Profile profile;
            JSONArray orgf = new JSONArray();
            UserRHDataDTO currentUserData = this.userDataService.getUserRHDataByUserId(userId);
            JSONObject current = new JSONObject();
            Identity id = null;
            try {
                id = this.identityManager.getOrCreateIdentity("organization", userId, false);
                if (id != null) {
                    profile = id.getProfile();
                    current.put("userId", (Object)userId);
                    current.put("fullName", (Object)profile.getFullName());
                    current.put("manager", (Object)(currentUserData != null ? currentUserData.getFunctionalManager() : ""));
                    current.put("job", (Object)profile.getPosition());
                    if (profile.getAvatarUrl() != null) {
                        current.put("avatar", (Object)profile.getAvatarUrl());
                    } else {
                        current.put("avatar", (Object)"/eXoSkin/skin/images/system/UserAvtDefault.png");
                    }
                    orgf.put((Object)current);
                }
            }
            catch (Exception e) {
                log.warn((Object)("cannot get user " + currentUserData.getUserId() + " informations"));
            }
            if (currentUserData != null && currentUserData.getFunctionalManager() != null) {
                try {
                    id = this.identityManager.getOrCreateIdentity("organization", currentUserData.getFunctionalManager(), false);
                    if (id != null) {
                        profile = id.getProfile();
                        JSONObject manager = new JSONObject();
                        manager.put("userId", (Object)currentUserData.getFunctionalManager());
                        manager.put("fullName", (Object)profile.getFullName());
                        manager.put("manager", (Object)"");
                        manager.put("job", (Object)profile.getPosition());
                        if (profile.getAvatarUrl() != null) {
                            manager.put("avatar", (Object)profile.getAvatarUrl());
                        } else {
                            manager.put("avatar", (Object)"/eXoSkin/skin/images/system/UserAvtDefault.png");
                        }
                        orgf.put((Object)manager);
                    }
                }
                catch (Exception e) {
                    log.warn((Object)("cannot get user " + currentUserData.getFunctionalManager() + " informations"));
                }
            }
            List fsubsList = new ArrayList();
            if ((fsubsList = this.userDataService.createFSubordonatesDetailedList(userId, fsubsList)).size() > 0) {
                for (UserRHDataDTO sub : fsubsList) {
                    try {
                        id = this.identityManager.getOrCreateIdentity("organization", sub.getUserId(), false);
                        if (id == null) continue;
                        Profile profile2 = id.getProfile();
                        JSONObject data = new JSONObject();
                        data.put("userId", (Object)sub.getUserId());
                        data.put("fullName", (Object)profile2.getFullName());
                        data.put("manager", (Object)sub.getFunctionalManager());
                        data.put("job", (Object)profile2.getPosition());
                        if (profile2.getAvatarUrl() != null) {
                            data.put("avatar", (Object)profile2.getAvatarUrl());
                        } else {
                            data.put("avatar", (Object)"/eXoSkin/skin/images/system/UserAvtDefault.png");
                        }
                        orgf.put((Object)data);
                    }
                    catch (Exception e) {
                        log.warn((Object)("cannot get user " + sub.getUserId() + " informations"));
                    }
                }
            }
            return Response.ok((CharSequence)orgf.toString());
        }
        catch (Throwable e) {
            log.error((Object)"error while getting chart", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getHierarchicalOrganization(String userId) {
        try {
            Profile profile;
            JSONArray orgh = new JSONArray();
            UserRHDataDTO currentUserData = this.userDataService.getUserRHDataByUserId(userId);
            JSONObject current = new JSONObject();
            Identity id = null;
            try {
                id = this.identityManager.getOrCreateIdentity("organization", userId, false);
                if (id != null) {
                    profile = id.getProfile();
                    current.put("userId", (Object)userId);
                    current.put("fullName", (Object)profile.getFullName());
                    current.put("manager", (Object)(currentUserData != null ? currentUserData.getHierarchicalManager() : ""));
                    current.put("job", (Object)profile.getPosition());
                    if (profile.getAvatarUrl() != null) {
                        current.put("avatar", (Object)profile.getAvatarUrl());
                    } else {
                        current.put("avatar", (Object)"/eXoSkin/skin/images/system/UserAvtDefault.png");
                    }
                    orgh.put((Object)current);
                }
            }
            catch (Exception e) {
                log.warn((Object)("cannot get user " + currentUserData.getUserId() + " informations"));
            }
            if (currentUserData != null && currentUserData.getHierarchicalManager() != null) {
                try {
                    id = this.identityManager.getOrCreateIdentity("organization", currentUserData.getHierarchicalManager(), false);
                    if (id != null) {
                        profile = id.getProfile();
                        JSONObject manager = new JSONObject();
                        manager.put("userId", (Object)currentUserData.getHierarchicalManager());
                        manager.put("fullName", (Object)profile.getFullName());
                        manager.put("manager", (Object)"");
                        manager.put("job", (Object)profile.getPosition());
                        if (profile.getAvatarUrl() != null) {
                            manager.put("avatar", (Object)profile.getAvatarUrl());
                        } else {
                            manager.put("avatar", (Object)"/eXoSkin/skin/images/system/UserAvtDefault.png");
                        }
                        orgh.put((Object)manager);
                    }
                }
                catch (Exception e) {
                    log.warn((Object)("cannot get user " + currentUserData.getHierarchicalManager() + " informations"));
                }
            }
            List hsubsList = new ArrayList();
            if ((hsubsList = this.userDataService.createHSubordonatesDetailedList(userId, hsubsList)).size() > 0) {
                for (UserRHDataDTO sub : hsubsList) {
                    try {
                        id = this.identityManager.getOrCreateIdentity("organization", sub.getUserId(), false);
                        if (id == null) continue;
                        Profile profile2 = id.getProfile();
                        JSONObject data = new JSONObject();
                        data.put("userId", (Object)sub.getUserId());
                        data.put("fullName", (Object)profile2.getFullName());
                        data.put("manager", (Object)sub.getHierarchicalManager());
                        data.put("job", (Object)profile2.getPosition());
                        if (profile2.getAvatarUrl() != null) {
                            data.put("avatar", (Object)profile2.getAvatarUrl());
                        } else {
                            data.put("avatar", (Object)"/eXoSkin/skin/images/system/UserAvtDefault.png");
                        }
                        orgh.put((Object)data);
                    }
                    catch (Exception e) {
                        log.warn((Object)("cannot get user " + sub.getUserId() + " informations"));
                    }
                }
            }
            return Response.ok((CharSequence)orgh.toString());
        }
        catch (Throwable e) {
            log.error((Object)"error while getting chart", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getBundle() {
        try {
            if (!PropertyManager.isDevelopping() && this.bundleString != null && this.getResourceBundle().getLocale().equals(PortalRequestContext.getCurrentInstance().getLocale())) {
                return Response.ok((CharSequence)this.bundleString);
            }
            this.bundle = this.getResourceBundle(PortalRequestContext.getCurrentInstance().getLocale());
            JSON data = new JSON();
            Enumeration<String> enumeration = this.getResourceBundle().getKeys();
            while (enumeration.hasMoreElements()) {
                String key = enumeration.nextElement();
                try {
                    data.set(key.replaceAll("(.*)\\.", ""), this.getResourceBundle().getObject(key));
                }
                catch (MissingResourceException missingResourceException) {}
            }
            this.bundleString = data.toString();
            return Response.ok((CharSequence)this.bundleString);
        }
        catch (Throwable e) {
            log.error((Object)"error while getting bundele", e);
            return Response.status((int)500);
        }
    }

    private ResourceBundle getResourceBundle(Locale locale) {
        this.bundle = ResourceBundle.getBundle("locale.portlet.rh-management", locale, this.getClass().getClassLoader());
        return this.bundle;
    }

    private ResourceBundle getResourceBundle() {
        if (this.bundle == null) {
            this.bundle = this.getResourceBundle(PortalRequestContext.getCurrentInstance().getLocale());
        }
        return this.bundle;
    }
}

