/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.reporting.web.handler.internal;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sirona.configuration.ioc.IoCs;
import org.apache.sirona.reporting.web.handler.TemplateHelper;
import org.apache.sirona.reporting.web.handler.internal.Invoker;
import org.apache.sirona.reporting.web.plugin.api.Regex;

public class EndpointInfo {
    private final Map<Pattern, Invoker> invokers = new HashMap<Pattern, Invoker>();

    public Map<Pattern, Invoker> getInvokers() {
        return this.invokers;
    }

    public static EndpointInfo build(Class<?> endpointClass, String id, String rootMapping) {
        EndpointInfo info = new EndpointInfo();
        Object instance = IoCs.newInstance(endpointClass);
        for (Method method : endpointClass.getMethods()) {
            Regex regex;
            if (method.getDeclaringClass() == Object.class || (regex = method.getAnnotation(Regex.class)) == null) continue;
            Pattern pattern = Pattern.compile(rootMapping + regex.value());
            Invoker invoker = new Invoker(instance, method, id);
            int partIdx = 1;
            for (Class<?> clazz : method.getParameterTypes()) {
                if (HttpServletRequest.class.equals(clazz)) {
                    invoker.addRequestParameter();
                    continue;
                }
                if (HttpServletResponse.class.equals(clazz)) {
                    invoker.addResponseParameter();
                    continue;
                }
                if (TemplateHelper.class.equals(clazz)) {
                    invoker.addTemplateHelper(id);
                    continue;
                }
                invoker.addSegmentParameter(clazz, partIdx);
                ++partIdx;
            }
            info.invokers.put(pattern, invoker);
        }
        return info;
    }
}

