/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.reporting.web.plugin.jta;

import org.apache.sirona.Role;
import org.apache.sirona.counters.Unit;
import org.apache.sirona.reporting.web.plugin.api.Regex;
import org.apache.sirona.reporting.web.plugin.api.Template;
import org.apache.sirona.reporting.web.plugin.api.graph.Graphs;

public class JTAEndpoints {
    private static final Role COMMITED = new Role("jta-commited", Unit.UNARY);
    private static final Role ROLLBACKED = new Role("jta-rollbacked", Unit.UNARY);
    private static final Role ACTIVE = new Role("jta-active", Unit.UNARY);

    @Regex
    public Template home() {
        return new Template("jta/jta.vm");
    }

    @Regex(value="/Commits/([0-9]*)/([0-9]*)")
    public String commit(long start, long end) {
        return Graphs.generateReport((String)"Commits", (Role)COMMITED, (long)start, (long)end);
    }

    @Regex(value="/Rollbacks/([0-9]*)/([0-9]*)")
    public String rollback(long start, long end) {
        return Graphs.generateReport((String)"Rollbacks", (Role)ROLLBACKED, (long)start, (long)end);
    }

    @Regex(value="/Actives/([0-9]*)/([0-9]*)")
    public String active(long start, long end) {
        return Graphs.generateReport((String)"Actives", (Role)ACTIVE, (long)start, (long)end);
    }
}

