/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.proxy.provider.remoting;

import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.ServiceFactory;
import org.apache.commons.proxy.ObjectProvider;
import org.apache.commons.proxy.exception.ObjectProviderException;

public class JaxRpcProvider
implements ObjectProvider {
    private Class serviceInterface;
    private String wsdlUrl;
    private String serviceNamespaceUri;
    private String serviceLocalPart;
    private String servicePrefix;
    private String portNamespaceUri;
    private String portLocalPart;
    private String portPrefix;

    public JaxRpcProvider() {
    }

    public JaxRpcProvider(Class serviceInterface) {
        this.serviceInterface = serviceInterface;
    }

    public Object getObject() {
        try {
            Service service = this.wsdlUrl == null ? ServiceFactory.newInstance().createService(this.getServiceQName()) : ServiceFactory.newInstance().createService(new URL(this.wsdlUrl), this.getServiceQName());
            QName portQName = this.getPortQName();
            return portQName == null ? service.getPort(this.serviceInterface) : service.getPort(portQName, this.serviceInterface);
        }
        catch (ServiceException e) {
            throw new ObjectProviderException("Unable to create JAX-RPC service proxy.", e);
        }
        catch (MalformedURLException e) {
            throw new ObjectProviderException("Invalid URL given.", e);
        }
    }

    public void setPortLocalPart(String portLocalPart) {
        this.portLocalPart = portLocalPart;
    }

    public void setPortNamespaceUri(String portNamespaceUri) {
        this.portNamespaceUri = portNamespaceUri;
    }

    public void setPortPrefix(String portPrefix) {
        this.portPrefix = portPrefix;
    }

    public void setServiceInterface(Class serviceInterface) {
        this.serviceInterface = serviceInterface;
    }

    public void setServiceLocalPart(String serviceLocalPart) {
        this.serviceLocalPart = serviceLocalPart;
    }

    public void setServiceNamespaceUri(String serviceNamespaceUri) {
        this.serviceNamespaceUri = serviceNamespaceUri;
    }

    public void setServicePrefix(String servicePrefix) {
        this.servicePrefix = servicePrefix;
    }

    public void setWsdlUrl(String wsdlUrl) {
        this.wsdlUrl = wsdlUrl;
    }

    private QName getPortQName() {
        return this.getQName(this.portNamespaceUri, this.portLocalPart, this.portPrefix);
    }

    private QName getQName(String namespaceUri, String localPart, String prefix) {
        if (namespaceUri != null && localPart != null && prefix != null) {
            return new QName(namespaceUri, localPart, prefix);
        }
        if (namespaceUri != null && localPart != null) {
            return new QName(namespaceUri, localPart);
        }
        if (localPart != null) {
            return new QName(localPart);
        }
        return null;
    }

    private QName getServiceQName() {
        return this.getQName(this.serviceNamespaceUri, this.serviceLocalPart, this.servicePrefix);
    }
}

