/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.status;

import java.util.Date;
import org.apache.sirona.status.Status;
import org.apache.sirona.status.ValidationResult;

public class NodeStatus {
    private final ValidationResult[] results;
    private final Date date;
    private final Status status;

    public NodeStatus(ValidationResult[] results, Date date) {
        this.results = results;
        this.date = date;
        this.status = this.computeStatus();
    }

    public Date getDate() {
        if (this.date == null) {
            return new Date(0L);
        }
        return this.date;
    }

    public ValidationResult[] getResults() {
        return this.results;
    }

    public Status getStatus() {
        return this.status;
    }

    protected Status computeStatus() {
        Status lowest = Status.OK;
        for (ValidationResult result : this.results) {
            if (Status.KO.equals((Object)result.getStatus())) {
                return Status.KO;
            }
            if (!Status.DEGRADED.equals((Object)result.getStatus())) continue;
            lowest = Status.DEGRADED;
        }
        return lowest;
    }
}

