/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.counters;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.ObjectName;
import org.apache.sirona.counters.Counter;
import org.apache.sirona.counters.OptimizedStatistics;
import org.apache.sirona.counters.Unit;
import org.apache.sirona.store.counter.CounterDataStore;

public class DefaultCounter
implements Counter {
    private final AtomicInteger concurrency = new AtomicInteger(0);
    private final Counter.Key key;
    private final CounterDataStore dataStore;
    private volatile int maxConcurrency = 0;
    protected final OptimizedStatistics statistics;
    protected final ReadWriteLock lock = new ReentrantReadWriteLock();
    private ObjectName jmx = null;

    public DefaultCounter(Counter.Key key, CounterDataStore store) {
        this(key, store, new OptimizedStatistics());
    }

    public DefaultCounter(Counter.Key key, CounterDataStore store, OptimizedStatistics statistics) {
        this.key = key;
        this.dataStore = store;
        this.statistics = statistics;
    }

    public void addInternal(double delta) {
        this.statistics.addValue(delta);
    }

    @Override
    public void updateConcurrency(int concurrency) {
        if (concurrency > this.maxConcurrency) {
            this.maxConcurrency = concurrency;
        }
    }

    @Override
    public int getMaxConcurrency() {
        return this.maxConcurrency;
    }

    @Override
    public AtomicInteger currentConcurrency() {
        return this.concurrency;
    }

    @Override
    public Counter.Key getKey() {
        return this.key;
    }

    @Override
    public void reset() {
        this.statistics.clear();
        this.concurrency.set(0);
    }

    @Override
    public void add(double delta) {
        this.dataStore.addToCounter(this, delta);
    }

    @Override
    public void add(double delta, Unit deltaUnit) {
        this.add(this.key.getRole().getUnit().convert(delta, deltaUnit));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getMax() {
        Lock rl = this.lock.readLock();
        rl.lock();
        try {
            double d = this.statistics.getMax();
            return d;
        }
        finally {
            rl.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getMin() {
        Lock rl = this.lock.readLock();
        rl.lock();
        try {
            double d = this.statistics.getMin();
            return d;
        }
        finally {
            rl.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getSum() {
        Lock rl = this.lock.readLock();
        rl.lock();
        try {
            double d = this.statistics.getSum();
            return d;
        }
        finally {
            rl.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getStandardDeviation() {
        Lock rl = this.lock.readLock();
        rl.lock();
        try {
            double d = this.statistics.getStandardDeviation();
            return d;
        }
        finally {
            rl.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getVariance() {
        Lock rl = this.lock.readLock();
        rl.lock();
        try {
            double d = this.statistics.getVariance();
            return d;
        }
        finally {
            rl.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getMean() {
        Lock rl = this.lock.readLock();
        rl.lock();
        try {
            double d = this.statistics.getMean();
            return d;
        }
        finally {
            rl.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getSecondMoment() {
        Lock rl = this.lock.readLock();
        rl.lock();
        try {
            double d = this.statistics.getSecondMoment();
            return d;
        }
        finally {
            rl.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getHits() {
        Lock rl = this.lock.readLock();
        rl.lock();
        try {
            long l = this.statistics.getN();
            return l;
        }
        finally {
            rl.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OptimizedStatistics getStatistics() {
        Lock rl = this.lock.readLock();
        rl.lock();
        try {
            OptimizedStatistics optimizedStatistics = this.statistics.copy();
            return optimizedStatistics;
        }
        finally {
            rl.unlock();
        }
    }

    public ReadWriteLock getLock() {
        return this.lock;
    }

    public void setJmx(ObjectName jmx) {
        this.jmx = jmx;
    }

    public ObjectName getJmx() {
        return this.jmx;
    }

    public String toString() {
        return "DefaultCounter{concurrency=" + this.concurrency + ", key=" + this.key + ", dataStore=" + this.dataStore + ", maxConcurrency=" + this.maxConcurrency + ", statistics=" + this.statistics + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!Counter.class.isInstance(o)) {
            return false;
        }
        Counter that = (Counter)Counter.class.cast(o);
        return this.key.equals(that.getKey());
    }

    public int hashCode() {
        return this.key.hashCode();
    }
}

