/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.web.servlet;

import java.io.IOException;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sirona.Role;
import org.apache.sirona.SironaException;
import org.apache.sirona.aop.AbstractPerformanceInterceptor;
import org.apache.sirona.web.discovery.GaugeDiscoveryListener;
import org.apache.sirona.web.servlet.StatusGauge;

public class SironaFilter
extends AbstractPerformanceInterceptor<Invocation>
implements Filter {
    public static final String MONITOR_STATUS = "org.apache.sirona.web.monitored-status";
    public static final String IGNORED_URLS = "org.apache.sirona.web.ignored-urls";
    private String[] ignored = new String[0];
    private Map<Integer, StatusGauge> statusGauges = null;

    public void init(FilterConfig filterConfig) throws ServletException {
        String monStatus;
        String ignoredUrls = filterConfig.getInitParameter(IGNORED_URLS);
        if (ignoredUrls != null) {
            this.ignored = ignoredUrls.split(",");
        }
        if (((monStatus = filterConfig.getInitParameter(MONITOR_STATUS)) == null || "true".equalsIgnoreCase(monStatus)) && filterConfig.getServletContext().getAttribute("status-gauges") == null) {
            throw new SironaException("To monitor status activate " + GaugeDiscoveryListener.class.getName());
        }
        this.statusGauges = (Map)filterConfig.getServletContext().getAttribute("status-gauges");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (HttpServletRequest.class.isInstance(request)) {
            HttpServletRequest httpRequest = (HttpServletRequest)HttpServletRequest.class.cast(request);
            String uri = SironaFilter.getRequestedUri(httpRequest);
            for (String ignorable : this.ignored) {
                if (!uri.startsWith(ignorable)) continue;
                chain.doFilter(request, response);
                return;
            }
            HttpServletResponse httpResponse = (HttpServletResponse)HttpServletResponse.class.cast(response);
            try {
                this.doInvoke(new Invocation(httpRequest, httpResponse, chain));
            }
            catch (Throwable throwable) {
                if (IOException.class.isInstance(throwable)) {
                    throw (IOException)IOException.class.cast(throwable);
                }
                if (ServletException.class.isInstance(throwable)) {
                    throw (ServletException)ServletException.class.cast(throwable);
                }
                throw new IOException(throwable);
            }
            finally {
                int status;
                StatusGauge statusGauge;
                if (this.statusGauges != null && (statusGauge = this.statusGauges.get(status = httpResponse.getStatus())) != null) {
                    statusGauge.incr();
                }
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    protected Object proceed(Invocation invocation) throws Throwable {
        invocation.proceed();
        return null;
    }

    protected String getCounterName(Invocation invocation) {
        return invocation.request.getRequestURI();
    }

    protected Role getRole() {
        return Role.WEB;
    }

    public void destroy() {
    }

    protected static String getRequestedUri(HttpServletRequest request) {
        String uri = request.getRequestURI();
        String context = request.getContextPath();
        if (uri.length() <= context.length()) {
            return uri;
        }
        return uri.substring(context.length());
    }

    protected static class Invocation {
        protected final HttpServletRequest request;
        protected final HttpServletResponse response;
        protected final FilterChain chain;

        public Invocation(HttpServletRequest request, HttpServletResponse response, FilterChain chain) {
            this.request = request;
            this.response = response;
            this.chain = chain;
        }

        public void proceed() throws IOException, ServletException {
            this.chain.doFilter((ServletRequest)this.request, (ServletResponse)this.response);
        }
    }
}

