/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.proxy.interceptor;

import org.apache.commons.proxy.Interceptor;
import org.apache.commons.proxy.ObjectProvider;
import org.apache.commons.proxy.ProxyFactory;
import org.apache.commons.proxy.ProxyUtils;

public class InterceptorChain {
    private final Interceptor[] interceptors;

    public InterceptorChain(Interceptor[] interceptors) {
        this.interceptors = interceptors;
    }

    private Object createProxy(ProxyFactory proxyFactory, ClassLoader classLoader, Object terminus, Class[] proxyClasses) {
        Object currentTarget = terminus;
        for (int i = this.interceptors.length - 1; i >= 0; --i) {
            currentTarget = proxyFactory.createInterceptorProxy(classLoader, currentTarget, this.interceptors[i], proxyClasses);
        }
        return currentTarget;
    }

    public ObjectProvider createProxyProvider(ProxyFactory proxyFactory, Object terminus) {
        return this.createProxyProvider(proxyFactory, terminus, null);
    }

    public ObjectProvider createProxyProvider(ProxyFactory proxyFactory, Object terminus, Class[] proxyClasses) {
        return this.createProxyProvider(proxyFactory, Thread.currentThread().getContextClassLoader(), terminus, proxyClasses);
    }

    public ObjectProvider createProxyProvider(ProxyFactory proxyFactory, ClassLoader classLoader, Object terminus, Class[] proxyClasses) {
        if (proxyClasses == null || proxyClasses.length == 0) {
            proxyClasses = ProxyUtils.getAllInterfaces(terminus.getClass());
        }
        return new ProxyObjectProvider(proxyFactory, classLoader, terminus, proxyClasses);
    }

    private class ProxyObjectProvider
    implements ObjectProvider {
        private final ClassLoader classLoader;
        private final Class[] proxyClasses;
        private final Object terminus;
        private final ProxyFactory proxyFactory;

        public ProxyObjectProvider(ProxyFactory proxyFactory, ClassLoader classLoader, Object terminus, Class[] proxyClasses) {
            this.classLoader = classLoader;
            this.proxyClasses = proxyClasses;
            this.terminus = terminus;
            this.proxyFactory = proxyFactory;
        }

        public Object getObject() {
            return InterceptorChain.this.createProxy(this.proxyFactory, this.classLoader, this.terminus, this.proxyClasses);
        }
    }
}

