/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.reporting.web.plugin.report.format;

import java.util.Collection;
import java.util.Map;
import org.apache.sirona.configuration.Configuration;
import org.apache.sirona.counters.Unit;
import org.apache.sirona.reporting.web.plugin.api.MapBuilder;
import org.apache.sirona.reporting.web.plugin.api.Template;
import org.apache.sirona.reporting.web.plugin.report.format.Format;
import org.apache.sirona.reporting.web.plugin.report.format.MapFormat;

public class CSVFormat
extends MapFormat
implements Format {
    private static final String SEPARATOR = Configuration.getProperty((String)"org.apache.sirona.csv.separator", (String)";");
    public static final String HEADER = "Counter" + SEPARATOR + "Role" + SEPARATOR + CSVFormat.toCsv(ATTRIBUTES_ORDERED_LIST);

    @Override
    public Template render(Map<String, ?> params) {
        Unit timeUnit = CSVFormat.timeUnit(params);
        return new Template("/templates/report/report-csv.vm", new MapBuilder().set((Object)"headers", (Object)HEADER).set((Object)"separator", (Object)SEPARATOR).set((Object)"lines", CSVFormat.snapshot(timeUnit, CSVFormat.format(params, null))).build(), false);
    }

    @Override
    public String type() {
        return "text/plain";
    }

    private static String toCsv(Collection<String> line) {
        StringBuilder builder = new StringBuilder();
        for (String s : line) {
            if ("Counter".equals(s) || "Role".equals(s)) continue;
            builder.append(s).append(SEPARATOR);
        }
        String str = builder.toString();
        return str.substring(0, str.length() - 1) + '\n';
    }
}

