/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.reporting.web.plugin.api.graph;

import java.awt.Color;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.sirona.Role;
import org.apache.sirona.configuration.Configuration;
import org.apache.sirona.configuration.ioc.IoCs;
import org.apache.sirona.repositories.Repository;
import org.apache.sirona.store.gauge.CollectorGaugeDataStore;
import org.apache.sirona.store.gauge.GaugeValuesRequest;
import org.apache.sirona.util.Environment;

public class Graphs {
    public static final String DEFAULT_COLOR = "#317eac";
    private static final int MAX_POINTS = Configuration.getInteger((String)"org.apache.sirona.reporting.graph.max-points", (int)200) - 1;
    private static final Random RANDOM = new Random(System.currentTimeMillis());
    private static final int MAX_COLOR = 256;
    private static final Collection<String> COLORS = new CopyOnWriteArrayList<String>(new String[]{Graphs.generateColor(), Graphs.generateColor(), Graphs.generateColor(), Graphs.generateColor(), Graphs.generateColor()});

    public static String toJson(String label, String color, SortedMap<Long, Double> data) {
        return "{\"label\":\"" + label + "\",\"color\":\"" + color + "\",\"data\": " + Graphs.toJson(data) + "}";
    }

    public static String toJson(SortedMap<Long, Double> data) {
        StringBuilder builder = new StringBuilder().append("[");
        Iterator<Map.Entry<Long, Double>> iterator = data.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, Double> entry = iterator.next();
            builder.append("[").append(entry.getKey()).append(", ").append(entry.getValue()).append("]");
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        return builder.append("]").toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String generateColor() {
        int blue;
        int green;
        int red;
        Random random = RANDOM;
        synchronized (random) {
            red = RANDOM.nextInt(256);
            green = RANDOM.nextInt(256);
            blue = RANDOM.nextInt(256);
        }
        Color color = new Color(red, green, blue);
        String hexString = Integer.toHexString(color.getRGB());
        return "#" + hexString.substring(2, hexString.length());
    }

    public static String generateReport(String label, Role role, long start, long end) {
        if (!Environment.isCollector()) {
            SortedMap gaugeValues = Repository.INSTANCE.getGaugeValues(start, end, role);
            return "[" + Graphs.toJson(label, DEFAULT_COLOR, Graphs.aggregate(gaugeValues)) + "]";
        }
        CollectorGaugeDataStore gaugeStore = (CollectorGaugeDataStore)IoCs.findOrCreateInstance(CollectorGaugeDataStore.class);
        Iterator markers = gaugeStore.markers().iterator();
        StringBuilder builder = new StringBuilder("[");
        Iterator<String> colors = COLORS.iterator();
        while (markers.hasNext()) {
            String color;
            String marker = (String)markers.next();
            if (colors.hasNext()) {
                color = colors.next();
            } else {
                color = Graphs.generateColor();
                COLORS.add(color);
            }
            SortedMap gaugeValues = gaugeStore.getGaugeValues(new GaugeValuesRequest(start, end, role), marker);
            builder.append(Graphs.toJson(label + " (" + marker + ")", color, Graphs.aggregate(gaugeValues)));
            if (!markers.hasNext()) continue;
            builder.append(",");
        }
        return builder.append("]").toString();
    }

    private static SortedMap<Long, Double> aggregate(SortedMap<Long, Double> gaugeValues) {
        if (gaugeValues.size() < MAX_POINTS || !TreeMap.class.isInstance(gaugeValues)) {
            return gaugeValues;
        }
        long min = gaugeValues.keySet().iterator().next();
        long max = ((Number)Number.class.cast(((TreeMap)TreeMap.class.cast(gaugeValues)).lastKey())).longValue();
        long step = (long)((double)(max - min) * 1.0 / (double)MAX_POINTS);
        TreeMap<Long, Double> aggregation = new TreeMap<Long, Double>();
        double currentValue = 0.0;
        long switchValue = min + step;
        long number = 0L;
        for (Map.Entry<Long, Double> entry : gaugeValues.entrySet()) {
            long key = entry.getKey();
            double value = entry.getValue();
            if (value == Double.NaN) {
                value = 0.0;
            }
            if (key < switchValue) {
                currentValue += value;
                ++number;
                continue;
            }
            aggregation.put(switchValue, currentValue / (double)Math.max(1L, number));
            switchValue += step;
            number = 0L;
            currentValue = value;
        }
        aggregation.put(switchValue, currentValue / (double)Math.max(1L, number));
        return aggregation;
    }

    private Graphs() {
    }
}

