/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webconferencing.skype;

import org.exoplatform.container.configuration.ConfigurationException;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.core.profile.settings.IMType;
import org.exoplatform.social.core.profile.settings.UserProfileSettingsService;
import org.exoplatform.webconferencing.CallProvider;
import org.exoplatform.webconferencing.UserInfo;

public class SkypeProvider
extends CallProvider {
    public static final String SKYPE_SCHEMA = "skype";
    public static final String SKYPE_TYPE = "skype";
    public static final String SKYPE_APPNAME = "eXoURISkype";
    public static final String SKYPE_TITLE = "Skype";
    private static final String VERSION = "eXoURISkype/1.0.0";

    public SkypeProvider(InitParams params) throws ConfigurationException {
        this(null, params);
    }

    public SkypeProvider(UserProfileSettingsService profileSettings, InitParams params) throws ConfigurationException {
        super(params);
        if (profileSettings != null) {
            profileSettings.addIMType(new IMType("skype", SKYPE_TITLE));
        }
    }

    public SettingsBuilder settings() {
        return new SettingsBuilder();
    }

    public UserInfo.IMInfo getIMInfo(String imId) {
        return new SkypeIMInfo(imId);
    }

    public String getVersion() {
        return VERSION;
    }

    public String getType() {
        return "skype";
    }

    public String[] getSupportedTypes() {
        return new String[]{this.getType()};
    }

    public String getTitle() {
        return SKYPE_TITLE;
    }

    public class SkypeIMInfo
    extends UserInfo.IMInfo {
        protected SkypeIMInfo(String id) {
            this("skype", id);
        }

        protected SkypeIMInfo(String type, String id) {
            super(type, id);
        }

        public String getSchema() {
            return "skype";
        }

        public boolean isBusiness() {
            return false;
        }
    }

    public class SettingsBuilder {
        protected String redirectURI;

        public SettingsBuilder redirectURI(String redirectURI) {
            this.redirectURI = redirectURI;
            return this;
        }

        public SkypeSettings build() {
            return new SkypeSettings(this.redirectURI);
        }
    }

    public class SkypeSettings
    extends CallProvider.Settings {
        protected final String redirectUri;

        protected SkypeSettings(String redirectUri) {
            super((CallProvider)SkypeProvider.this);
            this.redirectUri = redirectUri;
        }

        public String getRedirectUri() {
            return this.redirectUri;
        }
    }
}

