/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.smartactivitystream;

import java.io.Serializable;
import java.security.PrivilegedAction;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.persistence.PersistenceException;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.BaseContainerLifecyclePlugin;
import org.exoplatform.container.ContainerLifecyclePlugin;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.cache.CacheListener;
import org.exoplatform.services.cache.CacheListenerContext;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ObjectCacheInfo;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.smartactivitystream.ActivityFocusTracker;
import org.exoplatform.smartactivitystream.SmartActivityException;
import org.exoplatform.smartactivitystream.stats.dao.ActivityFocusDAO;
import org.exoplatform.smartactivitystream.stats.domain.ActivityFocusEntity;
import org.picocontainer.Startable;

public class SmartActivityService
implements Startable {
    private static final Log LOG = ExoLogger.getLogger(SmartActivityService.class);
    public static final String TRACKER_CACHE_NAME = "smartactivity.TrackerCache".intern();
    public static final int TRACKER_CACHE_PERIOD = 120000;
    private final ExoCache<String, ActivityFocusTracker> trackerCache;
    private final ActivityFocusDAO focusStorage;
    private final Timer focusSaver = new Timer();
    private final AtomicBoolean focusSaverStarted = new AtomicBoolean(false);
    private final boolean enableTrackers;

    public SmartActivityService(ActivityFocusDAO focusStorage, CacheService cacheService, InitParams params) {
        String enableTrackers;
        this.focusStorage = focusStorage;
        this.trackerCache = cacheService.getCacheInstance(TRACKER_CACHE_NAME);
        PropertiesParam param = params.getPropertiesParam("smartactivity-configuration");
        this.enableTrackers = param != null ? ((enableTrackers = (String)param.getProperties().get((Object)"enable-trackers")) != null ? Boolean.parseBoolean(enableTrackers.trim()) : true) : false;
    }

    public void submitActivityFocus(ActivityFocusEntity focus) throws SmartActivityException {
        String fkey = this.focusKey(focus);
        ActivityFocusTracker tracker = (ActivityFocusTracker)this.trackerCache.get((Serializable)((Object)fkey));
        if (tracker != null) {
            this.agregateFocus(tracker, focus);
            this.trackerCache.put((Serializable)((Object)fkey), (Object)tracker);
        } else {
            this.trackerCache.put((Serializable)((Object)fkey), (Object)new ActivityFocusTracker(focus));
        }
    }

    public boolean isTrackersEnabled() {
        return this.enableTrackers;
    }

    public void start() {
        final ExoContainer container = ExoContainerContext.getCurrentContainer();
        TimerTask saveTask = new TimerTask(){

            @Override
            public void run() {
                SmartActivityService.this.saveReadyCacheInContainerContext(container, true);
            }
        };
        this.focusSaver.schedule(saveTask, 240000L, 120000L);
        this.focusSaverStarted.set(true);
        SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

                            @Override
                            public Void run() {
                                SmartActivityService.this.stopTracker(container);
                                return null;
                            }
                        });
                    }
                });
                return null;
            }
        });
        container.addContainerLifecylePlugin((ContainerLifecyclePlugin)new BaseContainerLifecyclePlugin(){

            public void stopContainer(ExoContainer container) {
                SmartActivityService.this.stopTracker(container);
            }
        });
        this.trackerCache.addCacheListener((CacheListener)new CacheListener<String, ActivityFocusTracker>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onExpire(CacheListenerContext context, String key, ActivityFocusTracker tracker) throws Exception {
                if (!tracker.isLocked()) {
                    try {
                        tracker.lock();
                        SmartActivityService.this.saveActivityFocus(tracker.getEntity());
                    }
                    finally {
                        tracker.unlock();
                    }
                }
            }

            public void onRemove(CacheListenerContext context, String key, ActivityFocusTracker obj) throws Exception {
            }

            public void onPut(CacheListenerContext context, String key, ActivityFocusTracker obj) throws Exception {
            }

            public void onGet(CacheListenerContext context, String key, ActivityFocusTracker obj) throws Exception {
            }

            public void onClearCache(CacheListenerContext context) throws Exception {
            }
        });
    }

    public void stop() {
    }

    protected String focusKey(ActivityFocusEntity focus) {
        return focus.getUserId() + focus.getActivityId();
    }

    protected void agregateFocus(ActivityFocusTracker tracker, ActivityFocusEntity add) {
        ActivityFocusEntity tracked = tracker.getEntity();
        if (add.getStopTime() > tracked.getStopTime()) {
            tracked.setStopTime(add.getStopTime());
        }
        tracked.setTotalShown(this.sum(tracked.getTotalShown(), add.getTotalShown()));
        tracked.setContentShown(this.sum(tracked.getContentShown(), add.getContentShown()));
        tracked.setConvoShown(this.sum(tracked.getConvoShown(), add.getConvoShown()));
        tracked.setContentHits(this.sum(tracked.getContentHits(), add.getContentHits()));
        tracked.setConvoHits(this.sum(tracked.getConvoHits(), add.getConvoHits()));
        tracked.setAppHits(this.sum(tracked.getAppHits(), add.getAppHits()));
        tracked.setProfileHits(this.sum(tracked.getProfileHits(), add.getProfileHits()));
        tracked.setLinkHits(this.sum(tracked.getLinkHits(), add.getLinkHits()));
    }

    protected Long sum(Long existing, Long add) {
        if (existing == null) {
            return add;
        }
        if (add == null) {
            return existing;
        }
        return existing + add;
    }

    @ExoTransactional
    protected void saveActivityFocus(ActivityFocusEntity focus) throws SmartActivityException {
        block5: {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(">> saveActivityFocus: " + focus));
            }
            try {
                ActivityFocusEntity tracked = (ActivityFocusEntity)this.focusStorage.find(focus.getId());
                if (tracked == null) {
                    this.focusStorage.create(focus);
                    LOG.debug((Object)("<< saveActivityFocus => created: " + focus));
                    break block5;
                }
                if (tracked.getTrackerVersion().equals(focus.getTrackerVersion())) {
                    this.focusStorage.update(focus);
                    LOG.debug((Object)("<< saveActivityFocus => updated: " + focus));
                    break block5;
                }
                LOG.warn((Object)("Cannot update activity focus of different tracker versions: " + tracked.getTrackerVersion() + " vs " + focus.getTrackerVersion()));
                throw new SmartActivityException("Cannot update activity focus of different tracker versions");
            }
            catch (PersistenceException e) {
                LOG.error("Failed to save activity focus {}:{}", new Object[]{focus.getUserId(), focus.getActivityId(), e});
                throw new SmartActivityException("Failed to save activity focus", e);
            }
        }
    }

    @ExoTransactional
    protected void saveTrackerCache(final boolean readyOnly) throws Exception {
        this.trackerCache.select((CachedObjectSelector)new CachedObjectSelector<String, ActivityFocusTracker>(){

            public boolean select(String key, ObjectCacheInfo<? extends ActivityFocusTracker> ocinfo) {
                if (readyOnly) {
                    ActivityFocusTracker ft = (ActivityFocusTracker)ocinfo.get();
                    return ft != null ? ft.isReady() && !ft.isLocked() : false;
                }
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSelect(ExoCache<? extends String, ? extends ActivityFocusTracker> cache, String key, ObjectCacheInfo<? extends ActivityFocusTracker> ocinfo) throws Exception {
                ActivityFocusTracker ft = (ActivityFocusTracker)ocinfo.get();
                if (ft != null) {
                    boolean cacheUnlocked = true;
                    try {
                        ft.lock();
                        cache.put((Serializable)((Object)key), (Object)ft);
                        SmartActivityService.this.saveActivityFocus(ft.getEntity());
                        cache.remove((Serializable)((Object)key));
                        cacheUnlocked = false;
                    }
                    finally {
                        ft.unlock();
                        if (cacheUnlocked) {
                            cache.put((Serializable)((Object)key), (Object)ft);
                        }
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveReadyCacheInContainerContext(ExoContainer exoContainer, boolean readyOnly) {
        if (exoContainer != null) {
            try {
                RequestLifeCycle.begin((ExoContainer)exoContainer);
                this.saveTrackerCache(readyOnly);
            }
            catch (Exception e) {
                LOG.error((Object)"Error saving trackers", (Throwable)e);
            }
            finally {
                RequestLifeCycle.end();
            }
        } else {
            LOG.warn((Object)("Container not found " + exoContainer + " for saving trackers"));
        }
    }

    private void stopTracker(ExoContainer container) {
        if (this.focusSaverStarted.getAndSet(false)) {
            this.focusSaver.cancel();
            this.saveReadyCacheInContainerContext(container, false);
        }
    }
}

