/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.smartactivitystream.relevancy.rest;

import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.smartactivitystream.relevancy.ActivityRelevancyService;
import org.exoplatform.smartactivitystream.relevancy.domain.RelevanceEntity;
import org.exoplatform.smartactivitystream.relevancy.domain.RelevanceId;

@Path(value="/smartactivity")
@Produces(value={"application/json"})
public class RESTActivityRelevancyService
implements ResourceContainer {
    protected static final Log LOG = ExoLogger.getLogger(RESTActivityRelevancyService.class);
    protected final ActivityRelevancyService activityRelevancyService;

    public RESTActivityRelevancyService(ActivityRelevancyService activityRelevancyService) {
        this.activityRelevancyService = activityRelevancyService;
    }

    @POST
    @RolesAllowed(value={"users"})
    @Consumes(value={"application/json"})
    @Path(value="/relevancy")
    public void saveRelevance(RelevanceEntity relevanceEntity) {
        this.activityRelevancyService.saveRelevance(relevanceEntity);
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/relevancy/{userId}/{activityId}")
    public Response getRelevance(@PathParam(value="userId") String userId, @PathParam(value="activityId") String activityId) {
        RelevanceEntity relevanceEntity = this.activityRelevancyService.findById(new RelevanceId(userId, activityId));
        if (relevanceEntity == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok().entity((Object)relevanceEntity).build();
    }
}

