/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.smartactivitystream.stats;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.exoplatform.smartactivitystream.stats.domain.ActivityFocusEntity;

public class ActivityFocusTracker
implements Externalizable {
    public static final int BATCH_LIFETIME = 1200000;
    private ActivityFocusEntity entity;
    private long initTime;
    private boolean locked = false;
    private int hashCode;

    public ActivityFocusTracker() {
    }

    ActivityFocusTracker(ActivityFocusEntity entity) {
        this.entity = entity;
        this.initTime = System.currentTimeMillis();
    }

    ActivityFocusEntity getEntity() {
        return this.entity;
    }

    Long getInitTime() {
        return this.initTime;
    }

    boolean isReady() {
        return this.initTime > 0L ? System.currentTimeMillis() - this.initTime > 1200000L : false;
    }

    boolean isLocked() {
        return this.locked;
    }

    boolean lock() {
        boolean prevState = this.locked;
        this.locked = true;
        return prevState;
    }

    boolean unlock() {
        boolean prevState = this.locked;
        this.locked = false;
        return prevState;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.initTime);
        out.writeBoolean(this.locked);
        out.writeObject(this.entity);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.initTime = in.readLong();
        this.locked = in.readBoolean();
        this.entity = (ActivityFocusEntity)in.readObject();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.entity == null ? 0 : this.entity.hashCode());
            result = 31 * result + (int)(this.initTime ^ this.initTime >>> 32);
            this.hashCode = 31 * result + (this.locked ? 1231 : 1237);
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && ActivityFocusTracker.class.isAssignableFrom(obj.getClass())) {
            ActivityFocusTracker other = (ActivityFocusTracker)ActivityFocusTracker.class.cast(obj);
            if (this.entity == null ? other.entity != null : !this.entity.equals(other.entity)) {
                return false;
            }
            if (this.initTime != other.initTime) {
                return false;
            }
            return this.locked == other.locked;
        }
        return false;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.getClass().getSimpleName());
        s.append('-');
        s.append(this.initTime);
        if (this.locked) {
            s.append("(locked)");
        }
        s.append('[');
        s.append(this.entity.toString());
        s.append(']');
        return s.toString();
    }
}

