/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.smartactivitystream.relevancy.domain;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.Transient;
import org.exoplatform.commons.api.persistence.ExoEntity;

@Entity(name="SmartActivityRelevancyStats")
@ExoEntity
@NamedNativeQueries(value={@NamedNativeQuery(name="SmartActivityRelevancyStats.findStats", query="SELECT user_id, (SELECT COUNT(*) FROM ST_ACTIVITY_RELEVANCY WHERE user_id = r.user_id AND IS_RELEVANT = 1 AND update_date > :afterDate) AS relevant_count, (SELECT COUNT(*) FROM ST_ACTIVITY_RELEVANCY WHERE user_id = r.user_id AND IS_RELEVANT = 0 AND update_date > :afterDate) AS irrelevant_count, (SELECT COUNT(*) FROM ST_ACTIVITY_RELEVANCY WHERE user_id = r.user_id AND IS_RELEVANT IS NULL AND update_date > :afterDate) AS neutral_count, MAX(r.update_date) AS last_date FROM ST_ACTIVITY_RELEVANCY r WHERE r.update_date > :afterDate GROUP BY r.user_id", resultClass=RelevanceStatsEntity.class)})
public class RelevanceStatsEntity {
    @Transient
    protected final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @Id
    @Column(name="user_id")
    protected String userId;
    @Column(name="relevant_count")
    protected Long relevantCount;
    @Column(name="irrelevant_count")
    protected Long irrelevantCount;
    @Column(name="neutral_count")
    protected Long neutralCount;
    @Column(name="last_date")
    protected Date lastDate;

    public String getUserId() {
        return this.userId;
    }

    public Long getTotalCount() {
        return this.getRelevantCount() + this.getIrrelevantCount() + this.getNeutralCount();
    }

    public Long getRelevantCount() {
        return this.relevantCount;
    }

    public Long getIrrelevantCount() {
        return this.irrelevantCount;
    }

    public Long getNeutralCount() {
        return this.neutralCount;
    }

    public String getUpdateDate() {
        return this.dateFormat.format(this.lastDate);
    }

    public String toString() {
        return "RelevanceStatsEntity [userId=" + this.userId + ", lastDate=" + this.lastDate + "]";
    }
}

