/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.smartactivitystream.stats;

import java.io.Serializable;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.persistence.PersistenceException;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.BaseContainerLifecyclePlugin;
import org.exoplatform.container.ContainerLifecyclePlugin;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.cache.CacheListener;
import org.exoplatform.services.cache.CacheListenerContext;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ObjectCacheInfo;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.smartactivitystream.stats.ActivityFocusTracker;
import org.exoplatform.smartactivitystream.stats.ActivityStatsException;
import org.exoplatform.smartactivitystream.stats.dao.ActivityFocusDAO;
import org.exoplatform.smartactivitystream.stats.domain.ActivityFocusEntity;
import org.exoplatform.smartactivitystream.stats.domain.FocusId;
import org.picocontainer.Startable;

public class ActivityStatsService
implements Startable {
    private static final Log LOG = ExoLogger.getLogger(ActivityStatsService.class);
    public static final String TRACKER_CACHE_NAME = "smartactivity.TrackerCache".intern();
    public static final int TRACKER_CACHE_PERIOD = 120000;
    private final ExoCache<String, ActivityFocusTracker> trackerCache;
    private final ActivityFocusDAO focusStorage;
    private final Timer focusSaver = new Timer();
    private final AtomicBoolean focusSaverStarted = new AtomicBoolean(false);
    private final boolean enableTrackers;

    public ActivityStatsService(ActivityFocusDAO focusStorage, CacheService cacheService, InitParams params) {
        String enableTrackers;
        this.focusStorage = focusStorage;
        this.trackerCache = cacheService.getCacheInstance(TRACKER_CACHE_NAME);
        PropertiesParam param = params.getPropertiesParam("smartactivity-configuration");
        this.enableTrackers = param != null ? ((enableTrackers = (String)param.getProperties().get((Object)"enable-trackers")) != null ? Boolean.parseBoolean(enableTrackers.trim()) : true) : false;
    }

    public void submitActivityFocus(ActivityFocusEntity focus) throws ActivityStatsException {
        String fkey = this.focusKey(focus);
        ActivityFocusTracker tracker = (ActivityFocusTracker)this.trackerCache.get((Serializable)((Object)fkey));
        if (tracker != null) {
            this.agregateFocus(tracker.getEntity(), focus);
            this.trackerCache.put((Serializable)((Object)fkey), (Object)tracker);
        } else {
            this.trackerCache.put((Serializable)((Object)fkey), (Object)new ActivityFocusTracker(focus));
        }
    }

    public void saveTrackers() {
        this.saveCacheInContainerContext(ExoContainerContext.getCurrentContainer(), false);
    }

    public boolean isTrackersEnabled() {
        return this.enableTrackers;
    }

    public void start() {
        final ExoContainer container = ExoContainerContext.getCurrentContainer();
        TimerTask saveTask = new TimerTask(){

            @Override
            public void run() {
                ActivityStatsService.this.saveCacheInContainerContext(container, true);
            }
        };
        this.focusSaver.schedule(saveTask, 240000L, 120000L);
        this.focusSaverStarted.set(true);
        SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

                            @Override
                            public Void run() {
                                ActivityStatsService.this.stopTracker(container);
                                return null;
                            }
                        });
                    }
                });
                return null;
            }
        });
        container.addContainerLifecylePlugin((ContainerLifecyclePlugin)new BaseContainerLifecyclePlugin(){

            public void stopContainer(ExoContainer container) {
                ActivityStatsService.this.stopTracker(container);
            }
        });
        this.trackerCache.addCacheListener((CacheListener)new CacheListener<String, ActivityFocusTracker>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onExpire(CacheListenerContext context, String key, ActivityFocusTracker tracker) throws Exception {
                if (!tracker.isLocked()) {
                    try {
                        tracker.lock();
                        ActivityStatsService.this.saveActivityFocus(tracker.getEntity());
                    }
                    finally {
                        tracker.unlock();
                    }
                }
            }

            public void onRemove(CacheListenerContext context, String key, ActivityFocusTracker obj) throws Exception {
            }

            public void onPut(CacheListenerContext context, String key, ActivityFocusTracker obj) throws Exception {
            }

            public void onGet(CacheListenerContext context, String key, ActivityFocusTracker obj) throws Exception {
            }

            public void onClearCache(CacheListenerContext context) throws Exception {
            }
        });
    }

    public void stop() {
    }

    protected String focusKey(ActivityFocusEntity focus) {
        return focus.getUserId() + focus.getActivityId();
    }

    protected void agregateFocus(ActivityFocusEntity tracked, ActivityFocusEntity add) {
        if (add.getStopTime() > tracked.getStopTime()) {
            tracked.setStopTime(add.getStopTime());
        }
        tracked.setTotalShown(this.sum(tracked.getTotalShown(), add.getTotalShown()));
        tracked.setContentShown(this.sum(tracked.getContentShown(), add.getContentShown()));
        tracked.setConvoShown(this.sum(tracked.getConvoShown(), add.getConvoShown()));
        tracked.setContentHits(this.sum(tracked.getContentHits(), add.getContentHits()));
        tracked.setConvoHits(this.sum(tracked.getConvoHits(), add.getConvoHits()));
        tracked.setAppHits(this.sum(tracked.getAppHits(), add.getAppHits()));
        tracked.setProfileHits(this.sum(tracked.getProfileHits(), add.getProfileHits()));
        tracked.setLinkHits(this.sum(tracked.getLinkHits(), add.getLinkHits()));
    }

    protected Long sum(Long existing, Long add) {
        if (existing == null) {
            return add;
        }
        if (add == null) {
            return existing;
        }
        return existing + add;
    }

    @ExoTransactional
    protected void saveActivityFocus(ActivityFocusEntity focus) throws ActivityStatsException {
        block8: {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(">> saveActivityFocus: " + focus));
            }
            try {
                List<ActivityFocusEntity> trackedAfter;
                ActivityFocusEntity tracked;
                FocusId fid = focus.getId();
                long startTimeAfter = System.currentTimeMillis() - 1200000L;
                if (startTimeAfter <= 0L) {
                    startTimeAfter = fid.getStartTime();
                }
                if ((tracked = (trackedAfter = this.focusStorage.findFocusAfter(fid.getUserId(), fid.getActivityId(), startTimeAfter)).size() > 0 ? trackedAfter.get(0) : null) == null) {
                    this.focusStorage.create(focus);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("<< saveActivityFocus => created: " + focus));
                    }
                    break block8;
                }
                if (tracked.getTrackerVersion().equals(focus.getTrackerVersion())) {
                    this.agregateFocus(tracked, focus);
                    this.focusStorage.update(tracked);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("<< saveActivityFocus => updated: " + tracked));
                    }
                    break block8;
                }
                LOG.warn((Object)("Cannot update activity focus of different tracker versions: " + tracked.getTrackerVersion() + " vs " + focus.getTrackerVersion()));
                throw new ActivityStatsException("Cannot update activity focus of different tracker versions");
            }
            catch (PersistenceException e) {
                LOG.error("Failed to save activity focus {}:{}", new Object[]{focus.getUserId(), focus.getActivityId(), e});
                throw new ActivityStatsException("Failed to save activity focus", e);
            }
        }
    }

    @ExoTransactional
    protected void saveTrackerCache(final boolean readyOnly) throws Exception {
        this.trackerCache.select((CachedObjectSelector)new CachedObjectSelector<String, ActivityFocusTracker>(){

            public boolean select(String key, ObjectCacheInfo<? extends ActivityFocusTracker> ocinfo) {
                if (readyOnly) {
                    ActivityFocusTracker ft = (ActivityFocusTracker)ocinfo.get();
                    return ft != null ? ft.isReady() && !ft.isLocked() : false;
                }
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSelect(ExoCache<? extends String, ? extends ActivityFocusTracker> cache, String key, ObjectCacheInfo<? extends ActivityFocusTracker> ocinfo) throws Exception {
                ActivityFocusTracker ft = (ActivityFocusTracker)ocinfo.get();
                if (ft != null) {
                    boolean cacheUnlocked = true;
                    try {
                        ft.lock();
                        cache.put((Serializable)((Object)key), (Object)ft);
                        ActivityStatsService.this.saveActivityFocus(ft.getEntity());
                        cache.remove((Serializable)((Object)key));
                        cacheUnlocked = false;
                    }
                    finally {
                        ft.unlock();
                        if (cacheUnlocked) {
                            cache.put((Serializable)((Object)key), (Object)ft);
                        }
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveCacheInContainerContext(ExoContainer exoContainer, boolean readyOnly) {
        if (exoContainer != null) {
            ExoContainer contextContainer = ExoContainerContext.getCurrentContainerIfPresent();
            try {
                ExoContainerContext.setCurrentContainer((ExoContainer)exoContainer);
                RequestLifeCycle.begin((ExoContainer)exoContainer);
                this.saveTrackerCache(readyOnly);
            }
            catch (Exception e) {
                LOG.error((Object)"Error saving trackers", (Throwable)e);
            }
            finally {
                RequestLifeCycle.end();
                ExoContainerContext.setCurrentContainer((ExoContainer)contextContainer);
            }
        } else {
            LOG.warn((Object)("Container not found " + exoContainer + " for saving trackers"));
        }
    }

    private void stopTracker(ExoContainer container) {
        if (this.focusSaverStarted.getAndSet(false)) {
            this.focusSaver.cancel();
            this.saveCacheInContainerContext(container, false);
        }
    }
}

