/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.smartactivitystream.stats.cometd;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.jcr.RepositoryException;
import org.cometd.annotation.Param;
import org.cometd.annotation.ServerAnnotationProcessor;
import org.cometd.annotation.Service;
import org.cometd.annotation.Session;
import org.cometd.annotation.Subscription;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.eclipse.jetty.util.component.LifeCycle;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.smartactivitystream.command.CommandThreadFactory;
import org.exoplatform.smartactivitystream.command.ContainerCommand;
import org.exoplatform.smartactivitystream.stats.ActivityStatsException;
import org.exoplatform.smartactivitystream.stats.ActivityStatsService;
import org.exoplatform.smartactivitystream.stats.domain.ActivityFocusEntity;
import org.mortbay.cometd.continuation.EXoContinuationBayeux;
import org.picocontainer.Startable;

public class CometdActivityStatsService
implements Startable {
    private static final Log LOG = ExoLogger.getLogger(CometdActivityStatsService.class);
    public static final String USERFOCUS_CHANNEL_NAME = "/eXo/Application/SmartActivity/userfocus/{userId}";
    public static final int MIN_THREADS = 2;
    public static final int MIN_MAX_THREADS = 4;
    public static final int THREAD_IDLE_TIME = 120;
    public static final int MAX_FACTOR = 100;
    public static final int QUEUE_FACTOR = 200;
    public static final String THREAD_PREFIX = "smartactivity-comet-thread-";
    protected final ActivityStatsService smartActivityService;
    protected final EXoContinuationBayeux exoBayeux;
    protected final CometdService service;
    protected final ExecutorService eventsHandlers;

    public CometdActivityStatsService(EXoContinuationBayeux exoBayeux, ActivityStatsService smartActivityService) {
        this.exoBayeux = exoBayeux;
        this.smartActivityService = smartActivityService;
        this.service = new CometdService();
        this.eventsHandlers = this.createThreadExecutor(THREAD_PREFIX, 100, 200);
    }

    public void start() {
        final AtomicReference processor = new AtomicReference();
        this.exoBayeux.addLifeCycleListener(new LifeCycle.Listener(){

            public void lifeCycleStarted(LifeCycle event) {
                ServerAnnotationProcessor p = new ServerAnnotationProcessor((BayeuxServer)CometdActivityStatsService.this.exoBayeux);
                processor.set(p);
                p.process((Object)CometdActivityStatsService.this.service);
            }

            public void lifeCycleStopped(LifeCycle event) {
                ServerAnnotationProcessor p = (ServerAnnotationProcessor)processor.get();
                if (p != null) {
                    p.deprocess((Object)CometdActivityStatsService.this.service);
                }
            }

            public void lifeCycleStarting(LifeCycle event) {
            }

            public void lifeCycleFailure(LifeCycle event, Throwable cause) {
            }

            public void lifeCycleStopping(LifeCycle event) {
            }
        });
        if (PropertyManager.isDevelopping()) {
            this.exoBayeux.addListener((BayeuxServer.BayeuxServerListener)new BayeuxServer.SessionListener(){

                public void sessionRemoved(ServerSession session, boolean timedout) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("sessionRemoved: " + session.getId() + " timedout:" + timedout + " channels: " + CometdActivityStatsService.this.channelsAsString(session.getSubscriptions())));
                    }
                }

                public void sessionAdded(ServerSession session, ServerMessage message) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("sessionAdded: " + session.getId() + " channels: " + CometdActivityStatsService.this.channelsAsString(session.getSubscriptions())));
                    }
                }
            });
        }
    }

    protected String channelsAsString(Set<ServerChannel> channels) {
        return channels.stream().map(c -> c.getId()).collect(Collectors.joining(", "));
    }

    public void stop() {
    }

    public String getCometdServerPath() {
        return "/" + this.exoBayeux.getCometdContextName() + "/cometd";
    }

    public String getUserToken(String userId) {
        return this.exoBayeux.getUserToken(userId);
    }

    protected ExecutorService createThreadExecutor(String threadNamePrefix, int maxFactor, int queueFactor) {
        int cpus = Runtime.getRuntime().availableProcessors();
        int poolThreads = cpus / 4;
        poolThreads = poolThreads < 2 ? 2 : poolThreads;
        int maxThreads = Math.round((float)cpus * 1.0f * (float)maxFactor);
        maxThreads = maxThreads > 0 ? maxThreads : 1;
        maxThreads = maxThreads < 4 ? 4 : maxThreads;
        int queueSize = cpus * queueFactor;
        int n = queueSize = queueSize < queueFactor ? queueFactor : queueSize;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating thread executor " + threadNamePrefix + "* for " + poolThreads + ".." + maxThreads + " threads, queue size " + queueSize));
        }
        return new ThreadPoolExecutor(poolThreads, maxThreads, 120L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(queueSize), new CommandThreadFactory(threadNamePrefix), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    @Service(value="smartactivity")
    public class CometdService {
        @Inject
        private BayeuxServer bayeux;
        @Session
        private LocalSession localSession;
        @Session
        private ServerSession serverSession;

        @PostConstruct
        public void postConstruct() {
        }

        @Subscription(value={"/eXo/Application/SmartActivity/userfocus/{userId}"})
        public void subscribeUserfocus(Message message, @Param(value="userId") String userId) throws RepositoryException {
            Object objData = message.getData();
            if (!Map.class.isInstance(objData)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Couldn't get data as a map from event");
                }
                return;
            }
            Map data = message.getDataAsMap();
            this.saveUserfocus(data);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Event published in " + message.getChannel() + ", userId: " + userId + ", data: " + message.getJSON()));
            }
        }

        protected void saveUserfocus(final Map<String, Object> data) {
            CometdActivityStatsService.this.eventsHandlers.submit(new ContainerCommand(PortalContainer.getCurrentPortalContainerName()){

                @Override
                protected void onContainerError(String error) {
                    LOG.error("An error has occured in container: {}", new Object[]{this.containerName});
                }

                @Override
                protected void execute(ExoContainer exoContainer) {
                    ActivityFocusEntity focus = new ActivityFocusEntity();
                    focus.setUserId((String)data.get("userId"));
                    focus.setActivityId((String)data.get("activityId"));
                    focus.setStartTime((Long)data.get("startTime"));
                    focus.setStopTime((Long)data.get("stopTime"));
                    focus.setTotalShown((Long)data.get("totalShown"));
                    focus.setContentShown((Long)data.get("contentShown"));
                    focus.setConvoShown((Long)data.get("convoShown"));
                    focus.setContentHits((Long)data.get("contentHits"));
                    focus.setConvoHits((Long)data.get("convoHits"));
                    focus.setAppHits((Long)data.get("appHits"));
                    focus.setProfileHits((Long)data.get("profileHits"));
                    focus.setLinkHits((Long)data.get("linkHits"));
                    focus.setTrackerVersion("1.0");
                    try {
                        CometdActivityStatsService.this.smartActivityService.submitActivityFocus(focus);
                    }
                    catch (ActivityStatsException activityStatsException) {
                        // empty catch block
                    }
                }
            });
        }
    }
}

