/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.addons.storage.dao.jpa;

import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.social.addons.storage.dao.SpaceDAO;
import org.exoplatform.social.addons.storage.entity.SpaceEntity;

public class SpaceDAOImpl
extends GenericDAOJPAImpl<SpaceEntity, Long>
implements SpaceDAO {
    public void delete(SpaceEntity entity) {
        this.getEntityManager().refresh((Object)entity);
        super.delete((Object)entity);
    }

    @Override
    public List<SpaceEntity> getLastSpaces(int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SpaceEntity.getLastSpaces", SpaceEntity.class);
        query.setMaxResults(limit);
        return query.getResultList();
    }

    @Override
    public SpaceEntity getSpaceByGroupId(String groupId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SpaceEntity.getSpaceByGroupId", SpaceEntity.class);
        query.setParameter("groupId", (Object)groupId);
        try {
            return (SpaceEntity)query.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    @Override
    public SpaceEntity getSpaceByURL(String url) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SpaceEntity.getSpaceByURL", SpaceEntity.class);
        query.setParameter("url", (Object)url);
        try {
            return (SpaceEntity)query.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    @Override
    public SpaceEntity getSpaceByDisplayName(String spaceDisplayName) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SpaceEntity.getSpaceByDisplayName", SpaceEntity.class);
        query.setParameter("displayName", (Object)spaceDisplayName);
        try {
            return (SpaceEntity)query.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    @Override
    public SpaceEntity getSpaceByPrettyName(String spacePrettyName) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SpaceEntity.getSpaceByPrettyName", SpaceEntity.class);
        query.setParameter("prettyName", (Object)spacePrettyName);
        query.setMaxResults(1);
        try {
            return (SpaceEntity)query.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }
}

