/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.addons.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addons.es.client.ElasticSearchingClient;
import org.exoplatform.addons.es.search.ElasticSearchException;
import org.exoplatform.addons.es.search.ElasticSearchFilter;
import org.exoplatform.addons.es.search.ElasticSearchServiceConnector;
import org.exoplatform.commons.api.search.data.SearchContext;
import org.exoplatform.commons.api.search.data.SearchResult;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class PeopleElasticUnifiedSearchServiceConnector
extends ElasticSearchServiceConnector {
    private static final Log LOG = ExoLogger.getLogger(PeopleElasticUnifiedSearchServiceConnector.class);
    private IdentityManager identityManager;
    private Map<String, String> sortMapping;

    public PeopleElasticUnifiedSearchServiceConnector(InitParams initParams, ElasticSearchingClient client, IdentityManager identityManager) {
        super(initParams, client);
        this.identityManager = identityManager;
        this.sortMapping = new HashMap<String, String>();
        this.sortMapping.put("date", "lastUpdatedDate");
        this.sortMapping.put("title", "name");
    }

    protected String getSourceFields() {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("name");
        fields.add("firstName");
        fields.add("lastName");
        fields.add("position");
        fields.add("skills");
        ArrayList<String> sourceFields = new ArrayList<String>();
        for (String sourceField : fields) {
            sourceFields.add("\"" + sourceField + "\"");
        }
        return StringUtils.join(sourceFields, (String)",");
    }

    protected String buildFilteredQuery(String query, Collection<String> sites, List<ElasticSearchFilter> filters, int offset, int limit, String sort, String order) {
        StringBuilder esQuery = new StringBuilder();
        esQuery.append("{\n");
        esQuery.append("     \"from\" : " + offset + ", \"size\" : " + limit + ",\n");
        esQuery.append("     \"track_scores\": true,\n");
        esQuery.append("     \"sort\" : [\n");
        esQuery.append("       { \"" + (StringUtils.isNotBlank((String)this.sortMapping.get(sort)) ? this.sortMapping.get(sort) : "_score") + "\" : ");
        esQuery.append("{\"order\" : \"" + (StringUtils.isNotBlank((String)order) ? order : "desc") + "\"}}\n");
        esQuery.append("     ],\n");
        esQuery.append("     \"_source\": [" + this.getSourceFields() + "],");
        esQuery.append("     \"query\": {\n");
        esQuery.append("        \"filtered\" : {\n");
        esQuery.append("            \"query\" : {\n");
        esQuery.append("                \"query_string\" : {\n");
        esQuery.append("                    \"fields\" : [" + this.getFields() + "],\n");
        esQuery.append("                    \"query\" : \"" + query + "\"\n");
        esQuery.append("                }\n");
        esQuery.append("            }\n");
        esQuery.append("        }\n");
        esQuery.append("     },\n");
        esQuery.append("     \"highlight\" : {\n");
        esQuery.append("       \"pre_tags\" : [\"<strong>\"],\n");
        esQuery.append("       \"post_tags\" : [\"</strong>\"],\n");
        esQuery.append("       \"fields\" : {\n");
        for (int i = 0; i < this.getSearchFields().size(); ++i) {
            esQuery.append("         \"" + (String)this.getSearchFields().get(i) + "\" : {\"fragment_size\" : 150, \"number_of_fragments\" : 3}");
            if (i < this.getSearchFields().size() - 1) {
                esQuery.append(",");
            }
            esQuery.append("\n");
        }
        esQuery.append("       }\n");
        esQuery.append("     }\n");
        esQuery.append("}");
        LOG.debug("Search Query request to ES : {} ", new Object[]{esQuery});
        return esQuery.toString();
    }

    protected Collection<SearchResult> buildResult(String jsonResponse, SearchContext context) {
        Map json;
        LOG.debug("Search Query response from ES : {} ", new Object[]{jsonResponse});
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        JSONParser parser = new JSONParser();
        try {
            json = (Map)parser.parse(jsonResponse);
        }
        catch (ParseException e) {
            throw new ElasticSearchException("Unable to parse JSON response", (Throwable)e);
        }
        JSONObject jsonResult = (JSONObject)json.get("hits");
        JSONArray jsonHits = (JSONArray)jsonResult.get((Object)"hits");
        for (Object jsonHit : jsonHits) {
            List phones;
            Identity identity = this.identityManager.getIdentity(((JSONObject)jsonHit).get((Object)"_id").toString(), true);
            Profile profile = identity.getProfile();
            if (identity.isDeleted()) continue;
            Double score = (Double)((JSONObject)jsonHit).get((Object)"_score");
            StringBuilder sb = new StringBuilder();
            if (profile.getEmail() != null) {
                sb.append(profile.getEmail());
            }
            if ((phones = (List)profile.getProperty("phones")) != null && phones.size() > 0) {
                sb.append(" - " + ((Map)phones.get(0)).get("value"));
            }
            if (profile.getProperty("gender") != null) {
                sb.append(" - " + profile.getProperty("gender"));
            }
            results.add(new SearchResult(profile.getUrl(), profile.getFullName(), profile.getPosition(), sb.toString(), profile.getAvatarUrl() != null ? profile.getAvatarUrl() : "/eXoSkin/skin/images/system/UserAvtDefault.png", profile.getCreatedTime(), score.longValue()));
        }
        return results;
    }
}

