/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.addons.storage.entity;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import org.exoplatform.commons.api.persistence.ExoEntity;
import org.exoplatform.social.addons.storage.entity.IdentityEntity;
import org.exoplatform.social.core.relationship.model.Relationship;

@Entity(name="SocConnection")
@ExoEntity
@Table(name="SOC_CONNECTIONS", uniqueConstraints={@UniqueConstraint(columnNames={"SENDER_ID", "RECEIVER_ID"})})
@NamedQueries(value={@NamedQuery(name="getRelationships", query="select r from SocConnection r"), @NamedQuery(name="SocConnection.findConnectionBySenderAndReceiver", query="SELECT c FROM SocConnection c WHERE c.sender.id = :sender AND c.receiver.id = :reciver"), @NamedQuery(name="SocConnection.deleteConnectionByIdentity", query="DELETE FROM SocConnection c WHERE c.sender.id = :identityId OR c.receiver.id = :identityId"), @NamedQuery(name="SocConnection.getConnections", query="SELECT connection.sender.id as sender, connection.receiver.id  as receiver from SocConnection connection where (connection.sender.id = :identityId or connection.receiver.id = :identityId) AND connection.status = :connStatus"), @NamedQuery(name="SocConnection.getReceiverBySenderAndStatus", query="SELECT c.receiver.id FROM SocConnection c WHERE c.sender.id = :senderId AND c.status in (:status)"), @NamedQuery(name="SocConnection.getSenderByReceiverAndStatus", query="SELECT c.sender.id FROM SocConnection c WHERE c.receiver.id = :receiverId AND c.status in (:status)"), @NamedQuery(name="SocConnection.countReceiverBySenderAndStatus", query="SELECT count(c.receiver.id) FROM SocConnection c WHERE c.sender.id = :senderId AND c.status in (:status)"), @NamedQuery(name="SocConnection.countSenderByReceiverAndStatus", query="SELECT count(c.sender.id) FROM SocConnection c WHERE c.receiver.id = :receiverId AND c.status in (:status)"), @NamedQuery(name="SocConnection.migrateSenderId", query="UPDATE SocConnection c SET c.sender.id = :newId WHERE c.sender.id = :oldId"), @NamedQuery(name="SocConnection.migrateReceiverId", query="UPDATE SocConnection c SET c.receiver.id = :newId WHERE c.receiver.id = :oldId")})
public class ConnectionEntity {
    @Id
    @SequenceGenerator(name="SEQ_SOC_CONNECTIONS_ID", sequenceName="SEQ_SOC_CONNECTIONS_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_SOC_CONNECTIONS_ID")
    @Column(name="CONNECTION_ID")
    private Long id;
    @ManyToOne(fetch=FetchType.EAGER, optional=false)
    @JoinColumn(name="SENDER_ID", referencedColumnName="IDENTITY_ID")
    private IdentityEntity sender;
    @ManyToOne(fetch=FetchType.EAGER, optional=false)
    @JoinColumn(name="RECEIVER_ID", referencedColumnName="IDENTITY_ID")
    private IdentityEntity receiver;
    @Enumerated
    @Column(name="STATUS", nullable=false)
    private Relationship.Type status;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="UPDATED_DATE", nullable=false)
    private Date updatedDate = new Date();

    public ConnectionEntity() {
    }

    public ConnectionEntity(IdentityEntity sender, IdentityEntity receiver) {
        this.sender = sender;
        this.receiver = receiver;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public IdentityEntity getSender() {
        return this.sender;
    }

    public void setSender(IdentityEntity sender) {
        this.sender = sender;
    }

    public IdentityEntity getReceiver() {
        return this.receiver;
    }

    public void setReceiver(IdentityEntity receiver) {
        this.receiver = receiver;
    }

    public Relationship.Type getStatus() {
        return this.status;
    }

    public void setStatus(Relationship.Type status) {
        if (status == Relationship.Type.ALL) {
            throw new IllegalArgumentException("Illegal status [" + status + "]");
        }
        this.status = status;
    }

    public Date getUpdatedDate() {
        return this.updatedDate;
    }

    public void setUpdatedDate(Date updatedDate) {
        this.updatedDate = updatedDate;
    }
}

