/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.addons.updater.listener;

import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.storage.api.IdentityStorage;

public class RelationshipActivityUpdaterListener
extends Listener<ExoSocialActivity, String> {
    private static final Log LOG = ExoLogger.getLogger(RelationshipActivityUpdaterListener.class);
    private static final String RELATIONSHIP_ACTIVITY_TYPE = "USER_ACTIVITIES_FOR_RELATIONSHIP";

    public void onEvent(Event<ExoSocialActivity, String> event) throws Exception {
        ExoSocialActivity activity = (ExoSocialActivity)event.getSource();
        String newActivityId = (String)event.getData();
        IdentityStorage identityStorage = (IdentityStorage)CommonsUtils.getService(IdentityStorage.class);
        if (RELATIONSHIP_ACTIVITY_TYPE.equals(activity.getType())) {
            Identity identity = identityStorage.findIdentity("organization", activity.getStreamOwner());
            identityStorage.updateProfileActivityId(identity, newActivityId, Profile.AttachedActivityType.RELATIONSHIP);
            LOG.info((Object)String.format("Migration the relationship activity '%s' with old id's %s and new id's %s", activity.getTitle(), activity.getId(), newActivityId));
        }
    }
}

